/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.mc.RebuildTaskExtender;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;

@Mixin(targets={"net/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk$RebuildTask"})
public abstract class RebuildTaskMixin
implements RebuildTaskExtender {
    @Unique
    public Set<RenderType> renderTypes;
    @Unique
    public ChunkBufferBuilderPack pack;
    @Unique
    public ChunkLayerMap<BufferCollection> caches;
    @Shadow(aliases={"this$0"})
    public ChunkRenderDispatcher.RenderChunk f_112859_;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/ModelBlockRenderer;enableCaching()V")}, method={"compile(FFFLnet/minecraft/client/renderer/ChunkBufferBuilderPack;)Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk$RebuildTask$CompileResults;"}, require=1)
    private void compileStart(float f1, float f2, float f3, ChunkBufferBuilderPack pack, CallbackInfoReturnable info) {
        this.pack = pack;
        LittleRenderPipelineType.startCompile((RenderChunkExtender)this.f_112859_, this);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/ModelBlockRenderer;clearCache()V")}, method={"compile(FFFLnet/minecraft/client/renderer/ChunkBufferBuilderPack;)Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk$RebuildTask$CompileResults;"}, require=1)
    private void compile(CallbackInfoReturnable info) {
        LittleRenderPipelineType.endCompile((RenderChunkExtender)this.f_112859_, this);
        this.pack = null;
        this.renderTypes = null;
    }

    @Redirect(at=@At(value="NEW", target="(I)Lit/unimi/dsi/fastutil/objects/ReferenceArraySet;", remap=false), method={"compile(FFFLnet/minecraft/client/renderer/ChunkBufferBuilderPack;)Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk$RebuildTask$CompileResults;"}, require=1)
    private ReferenceArraySet afterSetCreated(int capacity) {
        this.renderTypes = new ReferenceArraySet(capacity);
        return (ReferenceArraySet)this.renderTypes;
    }

    @Inject(at={@At(value="HEAD")}, method={"handleBlockEntity(Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$RenderChunk$RebuildTask$CompileResults;Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, require=1)
    private void handleBlockEntity(@Coerce Object object, BlockEntity block, CallbackInfo info) {
        if (block instanceof BETiles) {
            BETiles tiles = (BETiles)block;
            LittleRenderPipelineType.compile((RenderChunkExtender)this.f_112859_, tiles, this);
        }
    }

    @Inject(method={"doTask(Lnet/minecraft/client/renderer/ChunkBufferBuilderPack;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")}, cancellable=true, require=1)
    private void injected(CallbackInfoReturnable<CompletableFuture> cir) {
        cir.setReturnValue((Object)((CompletableFuture)cir.getReturnValue()).whenComplete((result, exception) -> {
            if (((Enum)result).ordinal() == 0) {
                ((RenderChunkExtender)this.f_112859_).prepareUpload();
                if (this.caches != null) {
                    for (Tuple tuple : this.caches.tuples()) {
                        ((RenderChunkExtender)this.f_112859_).uploaded((RenderType)tuple.key, (BufferCollection)tuple.value);
                    }
                }
            }
            this.caches = null;
        }));
    }

    @Unique
    public BufferBuilder builder(RenderType layer) {
        BufferBuilder builder = this.pack.m_108839_(layer);
        if (this.renderTypes.add(layer)) {
            ((RenderChunkExtender)this.f_112859_).begin(builder);
        }
        return builder;
    }

    @Override
    public BufferCache upload(RenderType layer, BufferCache cache) {
        if (cache.upload((ChunkBufferUploader)this.builder(layer))) {
            this.getOrCreateBuffers(layer).queueForUpload(cache);
            return cache;
        }
        return null;
    }

    @Unique
    public BufferCollection getOrCreateBuffers(RenderType layer) {
        BufferCollection cache;
        if (this.caches == null) {
            this.caches = new ChunkLayerMap();
        }
        if ((cache = (BufferCollection)this.caches.get(layer)) == null) {
            cache = new BufferCollection();
            this.caches.put(layer, (Object)cache);
        }
        return cache;
    }
}

