/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.InputEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.math.vec.LittleHitResult;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Unique
    public Minecraft asMinecraft() {
        return (Minecraft)this;
    }

    @Inject(method={"continueAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;")}, require=1, cancellable=true)
    private void continueAttack(boolean holding, CallbackInfo info) {
        HitResult hitResult;
        Minecraft mc = this.asMinecraft();
        if (holding && (hitResult = mc.f_91077_) instanceof LittleHitResult) {
            LittleHitResult result = (LittleHitResult)hitResult;
            if (result.hit.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockhitresult = result.asBlockHit();
                BlockPos blockpos = blockhitresult.m_82425_();
                if (!result.level.m_46859_(blockpos)) {
                    InputEvent.InteractionKeyMappingTriggered inputEvent = ForgeHooksClient.onClickInput((int)0, (KeyMapping)mc.f_91066_.f_92096_, (InteractionHand)InteractionHand.MAIN_HAND);
                    if (inputEvent.isCanceled()) {
                        if (inputEvent.shouldSwingHand()) {
                            mc.f_91061_.addBlockHitEffects(blockpos, blockhitresult);
                            mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                        }
                        info.cancel();
                        return;
                    }
                    Direction direction = blockhitresult.m_82434_();
                    if (LittleTilesClient.INTERACTION_HANDLER.continueDestroyBlock(result.level.asLevel(), blockpos, direction) && inputEvent.shouldSwingHand()) {
                        mc.f_91061_.addBlockHitEffects(blockpos, blockhitresult);
                        mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
                info.cancel();
            }
        }
    }

    @Inject(method={"continueAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;stopDestroyBlock()V")}, require=1)
    private void continueAttackStop(CallbackInfo info) {
        LittleTilesClient.INTERACTION_HANDLER.stopDestroyBlock();
    }

    @Inject(method={"startAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;")}, require=1, cancellable=true)
    private void startAttack(CallbackInfoReturnable<Boolean> info) {
        Minecraft mc = this.asMinecraft();
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof LittleHitResult) {
            BlockHitResult blockhitresult;
            BlockPos blockpos;
            LittleHitResult hit = (LittleHitResult)hitResult;
            if (hit.isEntity()) {
                LittleTilesClient.INTERACTION_HANDLER.attack(hit.level.asLevel(), (Player)mc.f_91074_, hit.asEntityHit().m_82443_());
                info.setReturnValue((Object)false);
            }
            if (!hit.level.m_46859_(blockpos = (blockhitresult = hit.asBlockHit()).m_82425_())) {
                LittleTilesClient.INTERACTION_HANDLER.startDestroyBlock(hit.level.asLevel(), blockpos, blockhitresult.m_82434_());
                info.setReturnValue((Object)hit.level.m_8055_(blockpos).m_60795_());
            }
        }
    }

    @WrapOperation(method={"startUseItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;isDestroying()Z")}, require=1)
    private boolean isDestroying(MultiPlayerGameMode mode, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{mode}) != false || LittleTilesClient.INTERACTION_HANDLER.isDestroying();
    }

    @Inject(method={"startUseItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;")}, require=1, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void startUseItem(CallbackInfo info, InteractionHand[] hands, int delay, int type, InteractionHand interactionhand, InputEvent.InteractionKeyMappingTriggered inputEvent, ItemStack itemstack) {
        Minecraft mc = this.asMinecraft();
        LocalPlayer player = mc.f_91074_;
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof LittleHitResult) {
            LittleHitResult hit = (LittleHitResult)hitResult;
            if (hit.isEntity()) {
                EntityHitResult entityhitresult = hit.asEntityHit();
                Entity entity = entityhitresult.m_82443_();
                if (!hit.level.m_6857_().m_61937_(entity.m_20183_())) {
                    return;
                }
                InteractionResult interactionresult = LittleTilesClient.INTERACTION_HANDLER.interactAt(hit.level.asLevel(), (Player)player, entity, entityhitresult, interactionhand);
                if (!interactionresult.m_19077_()) {
                    interactionresult = LittleTilesClient.INTERACTION_HANDLER.interact(hit.level.asLevel(), (Player)player, entity, interactionhand);
                }
                if (interactionresult.m_19077_()) {
                    if (interactionresult.m_19080_() && inputEvent.shouldSwingHand()) {
                        player.m_6674_(interactionhand);
                    }
                    info.cancel();
                }
                return;
            }
            BlockHitResult blockhitresult = hit.asBlockHit();
            int i = itemstack.m_41613_();
            InteractionResult interactionresult1 = LittleTilesClient.INTERACTION_HANDLER.useItemOn(hit.level.asLevel(), player, interactionhand, blockhitresult);
            if (interactionresult1.m_19077_()) {
                if (interactionresult1.m_19080_() && inputEvent.shouldSwingHand()) {
                    player.m_6674_(interactionhand);
                    if (!itemstack.m_41619_() && (itemstack.m_41613_() != i || mc.f_91072_.m_105290_())) {
                        mc.f_91063_.f_109055_.m_109320_(interactionhand);
                    }
                }
                info.cancel();
                return;
            }
            if (interactionresult1 == InteractionResult.FAIL) {
                info.cancel();
            }
        }
    }
}

