/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.premade;

import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.StackIngredient;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadeRegistry;

public abstract class LittleStructurePremade
extends LittleStructure {
    public LittleStructurePremade(LittlePremadeType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public ItemStack getStructureDrop() throws CorruptedConnectionException, NotYetConnectedException {
        ItemStack stack = LittlePremadeRegistry.createStack(this.type.id);
        this.checkConnections();
        BlockPos.MutableBlockPos pos = this.getMinPos(this.getStructurePos().m_122032_());
        CompoundTag structureNBT = new CompoundTag();
        this.savePreview(structureNBT, (BlockPos)pos);
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128365_("s", (Tag)structureNBT);
        if (this.name != null) {
            CompoundTag display = new CompoundTag();
            display.m_128359_("Name", this.name);
            stack.m_41783_().m_128365_("display", (Tag)display);
        }
        return stack;
    }

    public static class LittlePremadeType
    extends LittleStructureType {
        public final String path;
        public final String modid;
        public boolean showInCreativeTab = true;
        public boolean snapToGrid = true;

        public <T extends LittleStructurePremade> LittlePremadeType(String id, String path, Class<T> structureClass, BiFunction<? extends LittlePremadeType, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute, String modid) {
            super(id, structureClass, factory, attribute.premade());
            this.modid = modid;
            this.path = path;
        }

        public <T extends LittleStructurePremade> LittlePremadeType(String id, Class<T> structureClass, BiFunction<? extends LittlePremadeType, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute, String modid) {
            this(id, "", structureClass, factory, attribute, modid);
        }

        public boolean hasCustomTab() {
            return false;
        }

        public ItemStack createItemStackEmpty() {
            return new ItemStack((ItemLike)LittleTilesRegistry.PREMADE.get());
        }

        public ItemStack createItemStack() {
            ItemStack stack = this.createItemStackEmpty();
            CompoundTag structureNBT = new CompoundTag();
            structureNBT.m_128359_("id", this.id);
            CompoundTag stackNBT = new CompoundTag();
            stackNBT.m_128365_("s", (Tag)structureNBT);
            stack.m_41751_(stackNBT);
            return stack;
        }

        public LittlePremadeType setNotShowCreativeTab() {
            this.showInCreativeTab = false;
            return this;
        }

        public LittlePremadeType setNotSnapToGrid() {
            this.snapToGrid = false;
            return this;
        }

        @Override
        public boolean canOnlyBePlacedByItemStack() {
            return true;
        }

        public boolean canSnapToGrid() {
            return true;
        }

        @Override
        public boolean tileCountAsIngredient(LittleGroup group) {
            return false;
        }

        @Override
        public void addIngredients(LittleGroup group, LittleIngredients ingredients) {
            super.addIngredients(group, ingredients);
            ingredients.add(new StackIngredient(this.createItemStack()));
        }
    }
}

