/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.premade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import team.creative.creativecore.common.util.inventory.InventoryUtils;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.block.little.registry.LittleBlockRegistry;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

public class LittleStructureBuilder
extends LittleStructurePremade {
    public static final NamedHandlerRegistry<LittleStructureBuilderType> REGISTRY = new NamedHandlerRegistry(null);
    public SimpleContainer inventory = new SimpleContainer(1);
    public int lastSizeX = 16;
    public int lastSizeY = 16;
    public int lastThickness = 1;
    public BlockState lastBlockState;
    public String lastStructureType;
    public int lastGrid = 16;

    public static void register(LittleStructureBuilderType type) {
        REGISTRY.register(type.type.id, (Object)type);
    }

    public LittleStructureBuilder(LittleStructurePremade.LittlePremadeType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean canInteract() {
        return true;
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result, InteractionHand hand) {
        LittleTilesGuiRegistry.STRUCTURE_BUILDER.open(player, this);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        this.lastSizeX = nbt.m_128441_("sizeX") ? nbt.m_128451_("sizeX") : 16;
        this.lastSizeY = nbt.m_128441_("sizeY") ? nbt.m_128451_("sizeY") : 16;
        this.lastThickness = nbt.m_128441_("thickness") ? nbt.m_128451_("thickness") : 1;
        this.lastGrid = nbt.m_128441_("grid") ? nbt.m_128451_("grid") : 16;
        this.lastStructureType = nbt.m_128461_("type");
        this.lastBlockState = nbt.m_128441_("state") ? LittleBlockRegistry.loadState(nbt.m_128461_("state")) : Blocks.f_50705_.m_49966_();
        this.inventory = InventoryUtils.load((CompoundTag)nbt, (int)1);
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        nbt.m_128405_("sizeX", this.lastSizeX);
        nbt.m_128405_("sizeY", this.lastSizeY);
        nbt.m_128405_("thickness", this.lastThickness);
        InventoryUtils.save((SimpleContainer)this.inventory);
        nbt.m_128359_("state", LittleBlockRegistry.saveState(this.lastBlockState));
        nbt.m_128405_("grid", this.lastGrid);
        nbt.m_128359_("type", this.lastStructureType);
    }

    public static class LittleStructureBuilderType {
        public final LittleStructureType type;
        public final String frameVariableName;

        public LittleStructureBuilderType(LittleStructureType type, String frameVariableName) {
            this.type = type;
            this.frameVariableName = frameVariableName;
        }

        public LittleGroup construct(LittleGrid grid, int width, int height, int thickness, BlockState state) {
            CompoundTag structureNBT = new CompoundTag();
            structureNBT.m_128359_("id", this.type.id);
            structureNBT.m_128385_("topRight", new int[]{Float.floatToIntBits(0.0f), Float.floatToIntBits(1.0f), Float.floatToIntBits(1.0f)});
            structureNBT.m_128385_(this.frameVariableName, new int[]{thickness, 0, 0, thickness + 1, height, width, grid.count});
            LittleGroup previews = new LittleGroup(structureNBT, (List<LittleGroup>)Collections.EMPTY_LIST);
            ArrayList<LittleBox> boxes = new ArrayList<LittleBox>();
            for (int x = 0; x < thickness; x += grid.count) {
                for (int y = 0; y < height; y += grid.count) {
                    for (int z = 0; z < width; z += grid.count) {
                        boxes.add(new LittleBox(x, y, z, Math.min(x + 16, thickness), Math.min(y + 16, height), Math.min(z + 16, width)));
                    }
                }
            }
            previews.addTileFast(grid, new LittleTile(state, -1, (List<LittleBox>)boxes));
            previews.convertToSmallest();
            return previews;
        }
    }
}

