/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.bed;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.littletiles.common.structure.type.bed.ILittleBedPlayerExtension;
import team.creative.littletiles.common.structure.type.bed.LittleBed;

public class LittleBedEventHandler {
    @SubscribeEvent
    public void continueSleep(SleepingLocationCheckEvent event) {
        ILittleBedPlayerExtension b;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ILittleBedPlayerExtension && (b = (ILittleBedPlayerExtension)livingEntity).getBed() != null) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void isSleepingLocationAllowed(SleepingLocationCheckEvent event) {
        Player player;
        LittleBed bed;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (bed = ((ILittleBedPlayerExtension)(player = (Player)livingEntity)).getBed()) != null && bed.getSleepingPlayer() == player) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        LittleBed bed = ((ILittleBedPlayerExtension)event.getEntity()).getBed();
        if (bed != null) {
            bed.wakeUp();
        }
        ((ILittleBedPlayerExtension)event.getEntity()).setBed(null);
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent event) {
        LittleBed bed = ((ILittleBedPlayerExtension)event.getEntity()).getBed();
        if (bed != null) {
            bed.wakeUp();
        }
        ((ILittleBedPlayerExtension)event.getEntity()).setBed(null);
    }
}

