/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.bed;

import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.packet.structure.BedUpdate;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.directional.StructureDirectionalField;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.type.bed.ILittleBedPlayerExtension;

public class LittleBed
extends LittleStructure {
    private Player sleepingPlayer = null;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3d playerPostion;
    @StructureDirectional
    public Facing direction;

    public LittleBed(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
    }

    @Override
    protected Object failedLoadingRelative(CompoundTag nbt, StructureDirectionalField field) {
        if (field.key.equals("facing")) {
            return Facing.get((int)nbt.m_128451_("direction"));
        }
        return super.failedLoadingRelative(nbt, field);
    }

    @Override
    public boolean isBed(LivingEntity player) {
        return true;
    }

    @Override
    public Direction getBedDirection() {
        return this.direction.toVanilla();
    }

    public Player getSleepingPlayer() {
        return this.sleepingPlayer;
    }

    public void wakeUp() {
        if (!this.isClient()) {
            this.broadcastPacket(new BedUpdate(this.getStructureLocation(), this.getSleepingPlayer(), true));
        }
        this.setSleepingPlayer(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setSleepingPlayerClient(Player player) {
        this.sleepingPlayer = player;
    }

    private void setSleepingPlayer(Player player) {
        this.sleepingPlayer = player;
        if (!this.isClient()) {
            this.getInput(0).updateState(SignalState.of(player != null));
        }
    }

    public Player.BedSleepingProblem trySleep(Player player, Vec3d highest) {
        Player.BedSleepingProblem ret = ForgeEventFactory.onPlayerSleepInBed((Player)player, Optional.of(this.getStructurePos()));
        if (ret != null) {
            return ret;
        }
        if (!player.m_5803_() && player.m_6084_()) {
            ServerPlayer sPlayer;
            if (!player.m_9236_().m_6042_().f_63858_()) {
                return Player.BedSleepingProblem.NOT_POSSIBLE_HERE;
            }
            if (player instanceof ServerPlayer) {
                sPlayer = (ServerPlayer)player;
                sPlayer.m_9158_(player.m_9236_().m_46472_(), this.getStructurePos(), player.m_146908_(), false, true);
            }
            if (!ForgeEventFactory.fireSleepingTimeCheck((Player)player, Optional.empty())) {
                return Player.BedSleepingProblem.NOT_POSSIBLE_NOW;
            }
            if (!player.m_7500_()) {
                Vec3 vec3 = highest.toVanilla();
                List list = player.m_9236_().m_6443_(Monster.class, new AABB(vec3.m_7096_() - 8.0, vec3.m_7098_() - 5.0, vec3.m_7094_() - 8.0, vec3.m_7096_() + 8.0, vec3.m_7098_() + 5.0, vec3.m_7094_() + 8.0), p_9062_ -> p_9062_.m_6935_(player));
                if (!list.isEmpty()) {
                    return Player.BedSleepingProblem.NOT_SAFE;
                }
            }
            ((ILittleBedPlayerExtension)player).setSleepingCounter(0);
            if (player.m_20159_()) {
                player.m_8127_();
            }
            this.setSleepingPlayer(player);
            ((ILittleBedPlayerExtension)player).setBed(this);
            this.broadcastPacket(new BedUpdate(this.getStructureLocation(), player, false));
            player.m_20124_(Pose.SLEEPING);
            ((ILittleBedPlayerExtension)player).setPositionToBed();
            player.m_21250_(this.getStructurePos());
            player.m_20256_(Vec3.f_82478_);
            player.f_19812_ = true;
            if (player instanceof ServerPlayer) {
                sPlayer = (ServerPlayer)player;
                player.m_36220_(Stats.f_12969_);
                CriteriaTriggers.f_10583_.m_222618_(sPlayer);
                if (!sPlayer.m_284548_().m_143333_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"sleep.not_possible"), true);
                }
                sPlayer.m_284548_().m_8878_();
            }
            return null;
        }
        return Player.BedSleepingProblem.OTHER_PROBLEM;
    }

    @Override
    public void tileDestroyed() throws CorruptedConnectionException, NotYetConnectedException {
        super.tileDestroyed();
        if (this.sleepingPlayer != null) {
            ((ILittleBedPlayerExtension)this.sleepingPlayer).setBed(null);
        }
    }

    @Override
    public boolean canInteract() {
        return true;
    }

    @Override
    protected void transferOverFormChange(LittleStructure newStructure) {
        super.transferOverFormChange(newStructure);
        LittleBed bed = (LittleBed)newStructure;
        if (this.sleepingPlayer != null) {
            ((ILittleBedPlayerExtension)this.sleepingPlayer).setBed(bed);
            bed.sleepingPlayer = this.sleepingPlayer;
        }
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result, InteractionHand hand) {
        try {
            this.checkConnections();
            if (!LittleTiles.CONFIG.general.enableBed) {
                return InteractionResult.PASS;
            }
            if (level.f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (level instanceof ISubLevel) {
                ISubLevel l = (ISubLevel)level;
                level = l.getRealLevel();
            }
            if (level.m_6042_().f_63862_()) {
                Vec3d vec = this.getHighestCenterVec();
                if (this.sleepingPlayer != null) {
                    player.m_213846_((Component)Component.m_237110_((String)"tile.bed.occupied", (Object[])new Object[0]));
                    return InteractionResult.SUCCESS;
                }
                Player.BedSleepingProblem problem = this.trySleep(player, vec);
                if (problem != null) {
                    player.m_5661_(problem.m_36423_(), true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
        return InteractionResult.SUCCESS;
    }
}

