/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.animation;

import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.placement.box.LittlePlaceBoxRelative;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.animation.AnimationState;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.curve.ValueCurve;
import team.creative.littletiles.common.structure.animation.curve.ValueInterpolation;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.directional.StructureDirectionalField;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.signal.output.InternalSignalOutput;
import team.creative.littletiles.common.structure.type.animation.LittleStateStructure;
import team.creative.littletiles.common.structure.type.animation.LittleUndirectedStateStructure;

public abstract class LittleDoor
extends LittleUndirectedStateStructure {
    public int duration;
    public ValueInterpolation interpolation;
    public boolean activateParent = false;
    public boolean rightClick = true;
    public boolean noClip = false;
    public boolean playPlaceSounds = true;

    public LittleDoor(LittleStateStructure.LittleStateStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected AnimationTimeline generateTimeline(AnimationState start, AnimationState end) {
        return new AnimationTimeline(this.duration);
    }

    @Override
    protected ValueCurve<Vec1d> createEmptyCurve() {
        return this.interpolation.create1d();
    }

    @Override
    public boolean canRightClick() {
        return super.canRightClick() && this.rightClick;
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        super.loadExtra(nbt);
        this.duration = nbt.m_128451_("du");
        this.interpolation = ValueInterpolation.values()[nbt.m_128451_("in")];
        this.activateParent = nbt.m_128471_("actP");
        this.rightClick = nbt.m_128471_("hand");
        this.playPlaceSounds = nbt.m_128471_("sound");
        this.noClip = nbt.m_128471_("noClip");
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        super.saveExtra(nbt);
        nbt.m_128405_("du", this.duration);
        nbt.m_128405_("in", this.interpolation.ordinal());
        if (this.activateParent) {
            nbt.m_128379_("actP", this.activateParent);
        } else {
            nbt.m_128473_("actP");
        }
        if (this.rightClick) {
            nbt.m_128379_("hand", this.rightClick);
        } else {
            nbt.m_128473_("hand");
        }
        if (this.noClip) {
            nbt.m_128379_("noClip", this.noClip);
        } else {
            nbt.m_128473_("noClip");
        }
        if (this.playPlaceSounds) {
            nbt.m_128379_("sound", this.playPlaceSounds);
        } else {
            nbt.m_128473_("sound");
        }
    }

    @Override
    public void performInternalOutputChange(InternalSignalOutput output) {
        if (!this.activateParent) {
            super.performInternalOutputChange(output);
        }
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result, InteractionHand hand) {
        if (this.canRightClick()) {
            if (!this.isClient()) {
                if (this.activateParent && this.getParent() != null) {
                    try {
                        LittleStructure parentStructure = this.getParent().getStructure();
                        if (parentStructure instanceof LittleDoor) {
                            LittleDoor door = (LittleDoor)parentStructure;
                            return door.use(level, context, pos, player, result, hand);
                        }
                        throw new LittleActionException("Invalid parent");
                    }
                    catch (LittleActionException e) {
                        LittleTilesClient.displayActionMessage(e.getActionMessage());
                        return InteractionResult.SUCCESS;
                    }
                }
                this.toggleState();
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(level, context, pos, player, result, hand);
    }

    @Override
    protected boolean shouldStayAnimatedAfterTransitionEnd() {
        return !this.activateParent && super.shouldStayAnimatedAfterTransitionEnd();
    }

    public void toggleState() {
        InternalSignalOutput output = this.getOutput(0);
        output.toggle();
        if (this.activateParent) {
            this.startTransitionIfNecessary(output.getState().number());
        }
    }

    public static class LittleDoorTypeInvisibleCenter
    extends LittleDoorType {
        public <T extends LittleDoor> LittleDoorTypeInvisibleCenter(String id, Class<T> structureClass, BiFunction<? extends LittleStateStructure.LittleStateStructureType, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute) {
            super(id, structureClass, factory, attribute);
        }

        @Override
        protected LittlePlaceBoxRelative getPlaceBox(Object value, StructureDirectionalField type, LittleGroup previews) {
            if (type.key.equals("center")) {
                return null;
            }
            return super.getPlaceBox(value, type, previews);
        }
    }

    public static class LittleDoorType
    extends LittleStateStructure.LittleStateStructureType {
        public <T extends LittleDoor> LittleDoorType(String id, Class<T> structureClass, BiFunction<? extends LittleStateStructure.LittleStateStructureType, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute) {
            super(id, structureClass, factory, attribute, 1, SignalMode.TOGGLE);
        }
    }
}

