/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.animation;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.animation.AnimationStateDirected;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.AnimationTransition;
import team.creative.littletiles.common.structure.animation.curve.ValueCurve;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.type.animation.LittleStateStructure;

public class LittleDirectedStateStructure
extends LittleStateStructure<AnimationStateDirected> {
    private static final AnimationStateDirected EMPTY = new AnimationStateDirected("");
    @StructureDirectional(saveKey="t")
    private List<AnimationTransition> transitions = new ArrayList<AnimationTransition>();
    private int currentTransition = -1;

    public LittleDirectedStateStructure(LittleStateStructure.LittleStateStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected AnimationStateDirected getEmptyState() {
        return EMPTY;
    }

    @Override
    protected AnimationTimeline generateTimeline(AnimationStateDirected start, AnimationStateDirected end) {
        return null;
    }

    @Override
    protected ValueCurve<Vec1d> createEmptyCurve() {
        return null;
    }

    public void startTransition(int index) {
        if (this.isChanging()) {
            return;
        }
        if (index < 0 || index >= this.transitions.size()) {
            LittleTiles.LOGGER.error("Tried to trigger transition {}, but there are only ", (Object)index, (Object)this.transitions.size());
            return;
        }
        AnimationTransition transition = this.transitions.get(index);
        if (this.startTransition(transition)) {
            this.currentTransition = index;
        }
        this.startTransition(transition.start, transition.end, transition.timeline);
    }

    @Override
    protected boolean shouldStayAnimatedAfterTransitionEnd() {
        this.getOutput(0).updateState(SignalState.of(this.currentIndex()));
        this.currentTransition = -1;
        int transition = ((AnimationStateDirected)this.current()).signalChanged(this);
        if (transition >= 0 && transition < this.transitions.size()) {
            this.startTransition(transition);
            return true;
        }
        return false;
    }

    @Nullable
    public AnimationTransition transition() {
        if (this.isChanging()) {
            return this.transitions.get(this.currentTransition);
        }
        return null;
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        super.loadExtra(nbt);
        this.currentTransition = nbt.m_128451_("cT");
        if (this.currentTransition > 0 && this.currentTransition >= this.transitions.size()) {
            throw new RuntimeException("Invalid state structure! Transition " + this.currentTransition + " not found. Only got " + this.transitions.size() + " transitions");
        }
    }

    @Override
    public boolean canRightClick() {
        return super.canRightClick() && ((AnimationStateDirected)this.current()).hasRightClickTransition();
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        super.saveExtra(nbt);
        nbt.m_128405_("cT", this.currentTransition);
    }

    @Override
    protected void processSignalChangesInternal() {
        int transition;
        if (!this.isChanging() && (transition = ((AnimationStateDirected)this.current()).signalChanged(this)) >= 0 && transition < this.transitions.size()) {
            this.startTransition(transition);
        }
    }
}

