/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.StringUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.signal.output.InternalSignalOutput;

public class LittleStructureMessage
extends LittleStructure {
    public String text;
    public boolean allowRightClick = true;
    public boolean status = false;

    public LittleStructureMessage(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean canInteract() {
        return this.allowRightClick;
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result, InteractionHand hand) {
        if (this.allowRightClick) {
            if (!level.f_46443_) {
                player.m_5661_(this.message(), this.status);
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(level, context, pos, player, result, hand);
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        this.text = StringUtils.truncate((String)nbt.m_128461_("text"), (int)LittleTiles.CONFIG.general.messageStructureLength);
        this.allowRightClick = nbt.m_128471_("right");
        this.status = nbt.m_128471_("status");
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        nbt.m_128359_("text", this.text);
        nbt.m_128379_("right", this.allowRightClick);
        nbt.m_128379_("status", this.status);
    }

    public Component message() {
        try {
            return Component.Serializer.m_130701_((String)this.text);
        }
        catch (Exception exception) {
            return Component.m_237113_((String)this.text);
        }
    }

    @Override
    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("message")) {
            Level level = this.getStructureLevel();
            if (level.f_46443_) {
                return;
            }
            LevelChunk chunk = level.m_46745_(this.getStructurePos());
            if (chunk != null) {
                ((ServerChunkCache)chunk.m_62953_().m_7726_()).f_8325_.m_183262_(chunk.m_7697_(), false).forEach(x -> x.m_240418_(this.message(), this.status));
            }
        }
    }
}

