/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.output;

import java.text.ParseException;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.connection.children.StructureChildConnection;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.component.ISignalStructureComponent;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;
import team.creative.littletiles.common.structure.type.premade.signal.LittleSignalOutput;

public class SignalExternalOutputHandler
implements ISignalComponent {
    public final LittleStructure structure;
    public final int index;
    public SignalInputCondition condition;
    public SignalOutputHandler handler;

    public SignalExternalOutputHandler(LittleStructure structure, int index, SignalInputCondition condition, Function<ISignalComponent, SignalOutputHandler> function) {
        this.structure = structure;
        this.index = index;
        this.condition = condition;
        this.handler = function.apply(this);
    }

    public SignalExternalOutputHandler(LittleStructure structure, CompoundTag nbt) throws ParseException {
        this.structure = structure;
        this.index = nbt.m_128451_("index");
        try {
            this.condition = nbt.m_128441_("con") ? SignalInputCondition.parseInput(nbt.m_128461_("con")) : null;
        }
        catch (ParseException e) {
            this.condition = null;
        }
        SignalMode mode = SignalMode.EQUAL;
        if (nbt.m_128441_("mode")) {
            mode = SignalMode.valueOf(nbt.m_128461_("mode"));
        }
        int delay = nbt.m_128451_("delay");
        if (this.condition != null) {
            delay = Math.max((int)Math.ceil(this.condition.calculateDelay()), nbt.m_128451_("delay"));
        }
        this.handler = SignalOutputHandler.create(this, mode, delay, nbt, structure);
    }

    public ISignalStructureComponent getOutput() throws CorruptedConnectionException, NotYetConnectedException {
        StructureChildConnection connection = this.structure.children.getChild(this.index);
        LittleStructure output = connection.getStructure();
        if (output instanceof LittleSignalOutput) {
            return (ISignalStructureComponent)((Object)output);
        }
        throw new RuntimeException("Invalid structure child expected output " + output);
    }

    public void update() {
        if (this.condition == null) {
            return;
        }
        try {
            int bandwidth = this.handler.getBandwidth();
            if (bandwidth > 0) {
                SignalState outputState = SignalState.create(bandwidth);
                SignalState result = this.condition.test(this.structure, false);
                outputState = result.size() == SignalState.SignalStateSize.SINGLE ? outputState.fill(result.any()) : outputState.fill(result);
                this.handler.schedule(outputState);
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    public CompoundTag write(boolean preview) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("index", this.index);
        if (this.structure != null) {
            try {
                nbt.m_128365_("state", this.getState().save());
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
        if (this.condition != null) {
            nbt.m_128359_("con", this.condition.write());
        }
        nbt.m_128359_("mode", this.handler == null ? SignalMode.EQUAL.name() : this.handler.getMode().name());
        if (this.handler != null) {
            nbt.m_128405_("delay", this.handler.delay);
            this.handler.write(preview, nbt);
        }
        return nbt;
    }

    @Override
    public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getOutput().getBandwidth();
    }

    @Override
    public void changed() throws CorruptedConnectionException, NotYetConnectedException {
        this.getOutput().changed();
        this.structure.schedule();
    }

    @Override
    public SignalState getState() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getOutput().getState();
    }

    @Override
    @Deprecated
    public void overwriteState(SignalState state) throws CorruptedConnectionException, NotYetConnectedException {
        this.getOutput().overwriteState(state);
    }

    @Override
    public SignalComponentType getComponentType() {
        return SignalComponentType.OUTPUT;
    }

    @Override
    public LittleStructure getStructure() {
        return this.structure;
    }

    @Override
    public Level getStructureLevel() {
        if (this.structure == null) {
            return null;
        }
        return this.structure.getStructureLevel();
    }

    public String toString() {
        return "o" + this.index;
    }
}

