/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.output;

import java.text.ParseException;
import net.minecraft.nbt.CompoundTag;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.packet.update.OutputUpdate;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.InternalSignal;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;

public class InternalSignalOutput
extends InternalSignal<LittleStructureType.InternalComponentOutput> {
    public final SignalMode defaultMode;
    public final boolean syncToClient;
    public SignalInputCondition condition;
    public SignalOutputHandler handler;

    public InternalSignalOutput(LittleStructure parent, LittleStructureType.InternalComponentOutput component) {
        super(parent, component);
        this.defaultMode = component.defaultMode;
        this.syncToClient = component.syncToClient;
    }

    @Override
    public void changed() {
        this.parent.performInternalOutputChange(this);
        this.parent.schedule();
        if (this.syncToClient) {
            LittleTiles.NETWORK.sendToClient((CreativePacket)new OutputUpdate(this.parent.getStructureLocation(), ((LittleStructureType.InternalComponentOutput)this.component).index, this.getState()), this.getStructureLevel(), this.parent.getStructurePos());
        }
    }

    @Override
    public SignalComponentType getComponentType() {
        return SignalComponentType.OUTPUT;
    }

    @Override
    public void load(CompoundTag nbt) {
        this.overwrite(this.getState().load(nbt.m_128423_("state")));
        try {
            this.condition = nbt.m_128441_("con") ? SignalInputCondition.parseInput(nbt.m_128461_("con")) : null;
        }
        catch (ParseException e) {
            this.condition = null;
        }
        SignalMode mode = this.defaultMode;
        if (nbt.m_128441_("mode")) {
            mode = SignalMode.valueOf(nbt.m_128461_("mode"));
        }
        int delay = nbt.m_128451_("delay");
        if (this.condition != null) {
            delay = Math.max((int)Math.ceil(this.condition.calculateDelay()), nbt.m_128451_("delay"));
        }
        this.handler = SignalOutputHandler.create(this, mode, delay, nbt, this.parent);
    }

    @Override
    public CompoundTag save(boolean preview, CompoundTag nbt) {
        nbt.m_128365_("state", this.getState().save());
        if (this.condition != null) {
            nbt.m_128359_("con", this.condition.write());
        }
        nbt.m_128359_("mode", this.handler == null ? this.defaultMode.name() : this.handler.getMode().name());
        if (this.handler != null) {
            if (this.handler.delay > 0) {
                nbt.m_128405_("delay", this.handler.delay);
            } else {
                nbt.m_128473_("delay");
            }
            this.handler.write(preview, nbt);
        }
        return nbt;
    }

    public void toggle() {
        if (this.handler instanceof SignalMode.SignalOutputHandlerToggle) {
            ((SignalMode.SignalOutputHandlerToggle)this.handler).triggerToggle();
        }
    }

    public void update() {
        if (this.condition == null) {
            return;
        }
        int bandwidth = this.getBandwidth();
        if (bandwidth > 0) {
            SignalState outputState = SignalState.create(bandwidth);
            SignalState result = this.condition.test(this.getStructure(), false);
            outputState = result.size() == SignalState.SignalStateSize.SINGLE ? outputState.fill(result.any()) : outputState.fill(result);
            this.handler.schedule(outputState);
        }
    }
}

