/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal;

import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import team.creative.creativecore.common.util.math.utils.IntegerUtils;

public abstract class SignalState {
    public static final SignalState TRUE = new PrimitveState(true);
    public static final SignalState FALSE = new PrimitveState(false);

    public static SignalState of(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static SignalState of(int number) {
        return new IntegerState(number);
    }

    public static SignalState of(long number) {
        throw new UnsupportedOperationException();
    }

    public static SignalState create(int bandwidth) {
        if (bandwidth == 1) {
            return FALSE;
        }
        if (bandwidth <= 32) {
            return new IntegerState(0);
        }
        throw new UnsupportedOperationException();
    }

    public static SignalState loadFromTag(Tag tag) {
        if (tag instanceof NumericTag) {
            NumericTag number = (NumericTag)tag;
            if (tag instanceof LongTag) {
                throw new UnsupportedOperationException();
            }
            if (tag instanceof ByteTag) {
                return SignalState.of(number.m_7063_() != 0);
            }
            return SignalState.of(number.m_7047_());
        }
        return FALSE;
    }

    public static SignalState read(FriendlyByteBuf buffer) {
        int length = buffer.readInt();
        if (length == 0) {
            return SignalState.of(buffer.readBoolean());
        }
        if (length == 1) {
            return new IntegerState(buffer.readInt());
        }
        throw new UnsupportedOperationException();
    }

    public static SignalState copy(SignalState state) {
        if (state instanceof PrimitveState) {
            return state;
        }
        if (state instanceof IntegerState) {
            IntegerState iState = (IntegerState)state;
            return new IntegerState(iState.value);
        }
        throw new UnsupportedOperationException();
    }

    public static int getRequiredBandwidth(int number) {
        int digit = 0;
        while (number != 0) {
            ++digit;
            number /= 10;
        }
        return digit;
    }

    public abstract boolean equals(Object var1);

    public abstract SignalState overwrite(SignalState var1);

    public abstract SignalState set(int var1, boolean var2);

    public abstract SignalState setNumber(int var1);

    public abstract SignalState setLongNumber(long var1);

    public abstract SignalState fill(boolean var1);

    public abstract SignalState fill(SignalState var1);

    public abstract SignalState reset();

    public abstract boolean equals(int var1, SignalState var2);

    public abstract boolean any();

    public abstract SignalState or(SignalState var1);

    public abstract boolean is(int var1);

    public boolean is(int[] indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] == 2 || indexes[i] == (this.is(i) ? 1 : 0)) continue;
            return false;
        }
        return true;
    }

    public abstract SignalState load(Tag var1);

    public abstract SignalState load(int var1);

    public abstract Tag save();

    public abstract int number();

    public abstract long longNumber();

    public abstract String toString();

    public abstract String print(int var1);

    public abstract void write(FriendlyByteBuf var1);

    public abstract SignalState invert();

    public abstract SignalStateSize size();

    public abstract void shrinkTo(int var1);

    protected static class IntegerState
    extends SignalState {
        private int value;

        public IntegerState(int value) {
            this.value = value;
        }

        @Override
        public boolean is(int index) {
            if (index < 32) {
                return IntegerUtils.bitIs((int)this.value, (int)index);
            }
            return false;
        }

        @Override
        public String toString() {
            return "[" + this.value + "]";
        }

        @Override
        public String print(int length) {
            Object result = "[";
            for (int i = 0; i < length; ++i) {
                result = (String)result + (this.is(i) ? "1" : "0");
            }
            return (String)result + "]";
        }

        @Override
        public SignalState load(Tag tag) {
            if (tag instanceof NumericTag) {
                NumericTag num = (NumericTag)tag;
                this.value = num.m_7047_();
            } else {
                this.value = 0;
            }
            return this;
        }

        @Override
        public Tag save() {
            return IntTag.m_128679_((int)this.value);
        }

        @Override
        public SignalState overwrite(SignalState state) {
            this.value = state.number();
            return this;
        }

        @Override
        public SignalState set(int index, boolean value) {
            this.value = IntegerUtils.set((int)this.value, (int)index, (boolean)value);
            return this;
        }

        @Override
        public SignalState setNumber(int value) {
            this.value = value;
            return this;
        }

        @Override
        public SignalState setLongNumber(long value) {
            this.value = (int)value;
            return this;
        }

        @Override
        public SignalState fill(boolean value) {
            this.value = value ? -1 : 0;
            return this;
        }

        @Override
        public SignalState fill(SignalState other) {
            this.value = other.number();
            return this;
        }

        @Override
        public SignalState reset() {
            this.value = 0;
            return this;
        }

        @Override
        public boolean equals(int bandwidth, SignalState state) {
            return IntegerState.shrinkTo(state.number(), bandwidth) == IntegerState.shrinkTo(this.value, bandwidth);
        }

        @Override
        public boolean any() {
            return this.value != 0;
        }

        @Override
        public SignalState or(SignalState other) {
            this.value |= other.number();
            return this;
        }

        @Override
        public SignalState load(int number) {
            this.value = number;
            return this;
        }

        @Override
        public int number() {
            return this.value;
        }

        @Override
        public long longNumber() {
            return this.value;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(1);
            buffer.writeInt(this.value);
        }

        @Override
        public SignalState invert() {
            this.value ^= 0xFFFFFFFF;
            return this;
        }

        @Override
        public SignalStateSize size() {
            return SignalStateSize.INT;
        }

        @Override
        public void shrinkTo(int bandwidth) {
            this.value = IntegerState.shrinkTo(this.value, bandwidth);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof IntegerState) {
                IntegerState integer = (IntegerState)object;
                return this.value == integer.value;
            }
            if (object instanceof SignalState) {
                SignalState state = (SignalState)object;
                return state.longNumber() == this.longNumber();
            }
            return false;
        }

        private static int shrinkTo(int number, int bandwidth) {
            return number & -1 >>> 31 - --bandwidth;
        }
    }

    protected static class PrimitveState
    extends SignalState {
        private final boolean value;

        private PrimitveState(boolean value) {
            this.value = value;
        }

        @Override
        public boolean is(int index) {
            if (index == 0) {
                return this.value;
            }
            return false;
        }

        @Override
        public String toString() {
            return "[" + this.value + "]";
        }

        @Override
        public String print(int length) {
            return this.toString();
        }

        @Override
        public SignalState overwrite(SignalState state) {
            return PrimitveState.of(state.any());
        }

        @Override
        public SignalState set(int index, boolean value) {
            if (index == 0) {
                return PrimitveState.of(value);
            }
            return this;
        }

        @Override
        public SignalState reset() {
            return FALSE;
        }

        @Override
        public boolean equals(int bandwidth, SignalState state) {
            return this.value == state.any();
        }

        @Override
        public boolean any() {
            return this.value;
        }

        @Override
        public SignalState load(Tag tag) {
            if (tag instanceof NumericTag) {
                NumericTag num = (NumericTag)tag;
                return num.m_7063_() == 0 ? FALSE : TRUE;
            }
            return FALSE;
        }

        @Override
        public Tag save() {
            return ByteTag.m_128273_((boolean)this.value);
        }

        @Override
        public int number() {
            return this.value ? 1 : 0;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(0);
            buffer.writeBoolean(this.value);
        }

        @Override
        public SignalState setNumber(int value) {
            return PrimitveState.of(value != 0);
        }

        @Override
        public SignalState setLongNumber(long value) {
            return PrimitveState.of(value != 0L);
        }

        @Override
        public SignalState fill(boolean value) {
            return PrimitveState.of(value);
        }

        @Override
        public SignalState fill(SignalState other) {
            return PrimitveState.of(other.any());
        }

        @Override
        public SignalState or(SignalState other) {
            return PrimitveState.of(this.value || other.any());
        }

        @Override
        public SignalState load(int number) {
            return PrimitveState.of(number != 0);
        }

        @Override
        public long longNumber() {
            return this.value ? 1L : 0L;
        }

        @Override
        public SignalState invert() {
            return PrimitveState.of(!this.value);
        }

        @Override
        public SignalStateSize size() {
            return SignalStateSize.SINGLE;
        }

        @Override
        public void shrinkTo(int bandwidth) {
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof PrimitveState) {
                return this == object;
            }
            if (object instanceof IntegerState) {
                IntegerState integer = (IntegerState)object;
                return integer.number() == this.number();
            }
            if (object instanceof SignalState) {
                SignalState state = (SignalState)object;
                return state.longNumber() == this.longNumber();
            }
            return false;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SignalStateSize {
        SINGLE(1){

            @Override
            public SignalState create() {
                return FALSE;
            }
        }
        ,
        INT(32){

            @Override
            public SignalState create() {
                return new IntegerState(0);
            }
        }
        ,
        LONG(64){

            @Override
            public SignalState create() {
                throw new UnsupportedOperationException();
            }
        };

        public final int bandwidth;

        private SignalStateSize(int bandwidth) {
            this.bandwidth = bandwidth;
        }

        public abstract SignalState create();

        public SignalStateSize max(SignalStateSize size) {
            if (this.ordinal() > size.ordinal()) {
                return this;
            }
            return size;
        }
    }
}

