/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.registry.gui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.parent.GuiLabeledControl;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButtonMapped;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.controls.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.controls.animation.GuiChildEventPanel;
import team.creative.littletiles.common.gui.controls.animation.GuiIsoAnimationPanel;
import team.creative.littletiles.common.gui.controls.animation.GuiIsoAnimationViewer;
import team.creative.littletiles.common.gui.controls.animation.GuiSoundEventPanel;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.animation.AnimationState;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.animation.curve.ValueInterpolation;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiControl;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.type.animation.LittleDoor;

@OnlyIn(value=Dist.CLIENT)
public abstract class LittleDoorBaseGui
extends LittleStructureGuiControl {
    public GuiSoundEventPanel soundPanel;
    public GuiChildEventPanel childPanel;
    private boolean created = false;

    public LittleDoorBaseGui(LittleStructureGui gui, GuiTreeItemStructure item) {
        super(gui, item);
    }

    protected abstract boolean hasAxis();

    @Override
    public void create(@Nullable LittleStructure structure) {
        AnimationTimeline closing;
        AnimationTimeline opening;
        boolean playPlaceSounds;
        boolean noClip;
        boolean rightClick;
        boolean stayAnimated;
        int duration;
        ValueInterpolation inter;
        boolean even;
        LittleBox box;
        LittleGrid grid;
        if (structure instanceof LittleDoor) {
            LittleDoor door = (LittleDoor)structure;
            grid = door.center.getGrid();
            box = door.center.getBox();
            even = door.center.isEven();
            inter = door.interpolation;
            duration = Math.max(1, door.duration);
            stayAnimated = door.stayAnimated;
            rightClick = door.rightClick;
            noClip = door.noClip;
            playPlaceSounds = door.playPlaceSounds;
            opening = door.getTransition("opening");
            closing = door.getTransition("closing");
        } else {
            grid = this.item.group.getGrid();
            box = new LittleBox(this.item.group.getMinVec());
            even = false;
            inter = ValueInterpolation.HERMITE;
            duration = 10;
            stayAnimated = false;
            rightClick = true;
            noClip = false;
            playPlaceSounds = true;
            closing = null;
            opening = null;
        }
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
        GuiParent settings = new GuiParent((GuiFlow)GuiFlow.FIT_X).setVAlign(VAlign.CENTER);
        this.add((GuiControl)settings);
        settings.add((GuiControl)new GuiLabeledControl((Component)Component.m_237115_((String)"gui.interpolation").m_130946_(":"), (GuiControl)new GuiStateButtonMapped("inter", (Object)inter, new TextMapBuilder().addComponent((Object[])ValueInterpolation.values(), x -> x.translate()))));
        settings.add((GuiControl)new GuiLabeledControl((Component)Component.m_237115_((String)"gui.duration").m_130946_(":"), (GuiControl)new GuiSteppedSlider("duration", duration, 1, 500)));
        settings.add(new GuiCheckBox("stayAnimated", stayAnimated).setTranslate("gui.stay_animated").setTooltip("gui.door.stay_animated.tooltip"));
        settings.add(new GuiCheckBox("rightClick", rightClick).setTranslate("gui.rightclick").setTooltip("gui.door.rightclick.tooltip"));
        settings.add(new GuiCheckBox("noClip", noClip).setTranslate("gui.no_clip").setTooltip("gui.door.no_clip.tooltip"));
        settings.add(new GuiCheckBox("playPlaceSounds", playPlaceSounds).setTranslate("gui.door.play_place_sound").setTooltip("gui.door.play_place_sound.tooltip"));
        this.add((GuiControl)new GuiIsoAnimationPanel(this.item, box, grid, even).setVisibleAxis(this.hasAxis()).setViewerDim(200, 200));
        this.createSpecific(structure instanceof LittleDoor ? (LittleDoor)structure : null);
        GuiParent extraSettings = new GuiParent();
        this.add((GuiControl)extraSettings);
        extraSettings.spacing = 4;
        this.soundPanel = new GuiSoundEventPanel(this.item.recipe.animation, opening, closing, duration);
        extraSettings.add((GuiControl)this.soundPanel);
        this.childPanel = new GuiChildEventPanel(this.item, this.item.recipe.animation, opening, duration);
        extraSettings.add((GuiControl)this.childPanel);
        this.created = true;
        this.updateTimeline();
        this.registerEventChanged(x -> {
            if (x.control.is("duration")) {
                this.updateTimeline();
                this.soundPanel.durationChanged(((GuiSteppedSlider)x.control).getIntValue());
                this.childPanel.durationChanged(((GuiSteppedSlider)x.control).getIntValue());
            } else if (x.control.is("inter")) {
                this.updateTimeline();
            }
            if (x.control instanceof GuiTimeline) {
                this.updateTimeline();
            }
        });
    }

    @Override
    public LittleStructure save(LittleStructure structure) {
        AnimationTimeline closing;
        LittleDoor door = (LittleDoor)structure;
        GuiIsoAnimationViewer viewer = (GuiIsoAnimationViewer)this.get("viewer");
        door.center = new StructureRelative(viewer.getBox(), viewer.getGrid());
        GuiStateButtonMapped inter = (GuiStateButtonMapped)this.get("inter");
        door.interpolation = (ValueInterpolation)((Object)inter.getSelected());
        door.duration = ((GuiSteppedSlider)this.get("duration", GuiSteppedSlider.class)).getIntValue();
        door.stayAnimated = ((GuiCheckBox)this.get((String)"stayAnimated", GuiCheckBox.class)).value;
        door.rightClick = ((GuiCheckBox)this.get((String)"rightClick", GuiCheckBox.class)).value;
        door.noClip = ((GuiCheckBox)this.get((String)"noClip", GuiCheckBox.class)).value;
        door.playPlaceSounds = ((GuiCheckBox)this.get((String)"playPlaceSounds", GuiCheckBox.class)).value;
        door.putState(new AnimationState("closed"));
        AnimationState state = new AnimationState("opened");
        this.save(state);
        door.putState(state);
        if (this.soundPanel.isSoundEmpty() && this.childPanel.isChildEmpty()) {
            return structure;
        }
        AnimationTimeline opening = this.saveEventTimeline(door.duration, true);
        if (opening != null) {
            door.putTransition("closed", "opened", "opening", opening);
        }
        if ((closing = this.saveEventTimeline(door.duration, false)) != null) {
            door.putTransition("opened", "closed", "closing", closing);
        }
        return structure;
    }

    protected AnimationTimeline saveEventTimeline(int duration, boolean opening) {
        ArrayList<AnimationTimeline.AnimationEventEntry> events = new ArrayList<AnimationTimeline.AnimationEventEntry>();
        this.soundPanel.collectEvents(duration, events, opening);
        this.childPanel.collectEvents(duration, events, opening);
        if (events.isEmpty()) {
            return null;
        }
        return new AnimationTimeline(duration, events);
    }

    protected abstract void createSpecific(@Nullable LittleDoor var1);

    protected abstract void save(PhysicalState var1);

    public void updateTimeline() {
        if (!this.created) {
            return;
        }
        int duration = ((GuiSteppedSlider)this.get("duration", GuiSteppedSlider.class)).getIntValue();
        AnimationTimeline timeline = this.saveEventTimeline(duration, true);
        if (timeline == null) {
            timeline = new AnimationTimeline(duration);
        }
        GuiStateButtonMapped inter = (GuiStateButtonMapped)this.get("inter");
        PhysicalState end = new PhysicalState();
        this.save(end);
        timeline.start(new PhysicalState(), end, ((ValueInterpolation)((Object)inter.getSelected()))::create1d);
        this.item.recipe.animation.setTimeline(this.item, timeline);
    }
}

