/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.directional;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.placement.box.LittlePlaceBoxRelative;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.animation.AnimationState;
import team.creative.littletiles.common.structure.animation.AnimationStateDirected;
import team.creative.littletiles.common.structure.animation.AnimationTransition;
import team.creative.littletiles.common.structure.directional.StructureDirectionalField;
import team.creative.littletiles.common.structure.relative.StructureRelative;

public abstract class StructureDirectionalType<T> {
    private static HashMap<Class, StructureDirectionalType> types = new HashMap();
    private static List<BiFunction<Field, Class, StructureDirectionalType>> specialFactories = new ArrayList<BiFunction<Field, Class, StructureDirectionalType>>();

    public static StructureDirectionalType getType(Class origin, Field field) {
        StructureDirectionalType type = types.get(field.getType());
        if (type != null) {
            return type;
        }
        for (BiFunction<Field, Class, StructureDirectionalType> factory : specialFactories) {
            type = factory.apply(field, origin);
            if (type == null) continue;
            return type;
        }
        throw new RuntimeException("No registered directional type for " + field.getType() + ", " + field.getName());
    }

    public static StructureDirectionalType getSubType(Class clazz) {
        StructureDirectionalType type = types.get(clazz);
        if (type != null) {
            return type;
        }
        throw new RuntimeException("No registered directional type for " + clazz + ", " + clazz.getName());
    }

    public static <T> void register(Class<T> clazz, StructureDirectionalType<T> type) {
        if (types.containsKey(clazz)) {
            throw new IllegalArgumentException("Type already exists. " + clazz);
        }
        types.put(clazz, type);
    }

    public static void register(BiFunction<Field, Class, StructureDirectionalType> factory) {
        specialFactories.add(factory);
    }

    private static int searchIndex(Class clazz, TypeVariable toFind) {
        TypeVariable<Class<T>>[] typeParamters = clazz.getTypeParameters();
        for (int i = 0; i < typeParamters.length; ++i) {
            if (typeParamters[i] != toFind) continue;
            return i;
        }
        throw new IllegalArgumentException("Type parameter " + toFind + " could not be found in " + clazz);
    }

    private static Class searchType(Class origin, Class clazz, TypeVariable toFind) {
        Class newTemp;
        ArrayList classTree = new ArrayList();
        classTree.add(origin);
        Class temp = origin;
        while (temp.getSuperclass() != null && (newTemp = temp.getSuperclass()) != clazz) {
            if (newTemp == null) {
                throw new IllegalArgumentException(origin + " does not extend " + clazz);
            }
            classTree.add(newTemp);
            temp = newTemp;
        }
        int paramIndex = StructureDirectionalType.searchIndex(clazz, toFind);
        int index = classTree.size() - 1;
        while (index >= 0) {
            ParameterizedType genericType = (ParameterizedType)((Class)classTree.get(index)).getGenericSuperclass();
            Type actual = genericType.getActualTypeArguments()[paramIndex];
            if (actual instanceof Class) {
                Class c = (Class)actual;
                return c;
            }
            if (!(actual instanceof TypeVariable)) continue;
            TypeVariable t = (TypeVariable)actual;
            paramIndex = StructureDirectionalType.searchIndex((Class)classTree.get(index), t);
            --index;
        }
        throw new IllegalArgumentException("Could not find valid class type of " + toFind + " in " + clazz);
    }

    public abstract T read(StructureDirectionalField var1, LittleStructure var2, Tag var3);

    public abstract Tag write(StructureDirectionalField var1, T var2);

    public abstract T move(StructureDirectionalField var1, T var2, LittleVecGrid var3);

    public abstract T mirror(StructureDirectionalField var1, T var2, LittleGrid var3, Axis var4, LittleVec var5);

    public abstract T rotate(StructureDirectionalField var1, T var2, LittleGrid var3, Rotation var4, LittleVec var5);

    public abstract Object getDefault(StructureDirectionalField var1, LittleStructure var2, Object var3);

    public LittleGrid getGrid(StructureDirectionalField field, T value) {
        return null;
    }

    public void convertToSmallest(T value) {
    }

    public void advancedScale(T value, int from, int to) {
    }

    public LittlePlaceBoxRelative getPlaceBox(T value, LittleGroup group, StructureDirectionalField field) {
        return null;
    }

    static {
        StructureDirectionalType.register((x, y) -> {
            if (List.class.isAssignableFrom(x.getType())) {
                return new StructureDirectionalType<List>(){
                    private final StructureDirectionalType subType;
                    {
                        ParameterizedType type = (ParameterizedType)x.getGenericType();
                        Type actualType = type.getActualTypeArguments()[0];
                        if (actualType instanceof Class) {
                            Class c = (Class)actualType;
                            this.subType = 1.getSubType(c);
                        } else if (actualType instanceof TypeVariable) {
                            TypeVariable t = (TypeVariable)actualType;
                            this.subType = 1.getSubType(StructureDirectionalType.searchType(y, (Class)t.getGenericDeclaration(), t));
                        } else {
                            throw new IllegalArgumentException("Could not find subtype of " + x);
                        }
                    }

                    @Override
                    public List read(StructureDirectionalField field, LittleStructure structure, Tag nbt) {
                        List list = structure != null ? (List)field.get(structure) : new ArrayList();
                        list.clear();
                        if (nbt instanceof ListTag) {
                            ListTag tag = (ListTag)nbt;
                            for (int i = 0; i < tag.size(); ++i) {
                                Object object = this.subType.read(field, structure, tag.get(i));
                                if (object == null) continue;
                                list.add(object);
                            }
                        }
                        return list;
                    }

                    @Override
                    public Tag write(StructureDirectionalField field, List value) {
                        ListTag list = new ListTag();
                        for (int i = 0; i < value.size(); ++i) {
                            Tag tag = this.subType.write(field, value.get(i));
                            if (tag == null) continue;
                            list.add((Object)tag);
                        }
                        return list;
                    }

                    @Override
                    public List move(StructureDirectionalField field, List value, LittleVecGrid vec) {
                        for (int i = 0; i < value.size(); ++i) {
                            this.subType.move(field, value.get(i), vec);
                        }
                        return value;
                    }

                    @Override
                    public List mirror(StructureDirectionalField field, List value, LittleGrid grid, Axis axis, LittleVec doubledCenter) {
                        for (int i = 0; i < value.size(); ++i) {
                            this.subType.mirror(field, value.get(i), grid, axis, doubledCenter);
                        }
                        return value;
                    }

                    @Override
                    public List rotate(StructureDirectionalField field, List value, LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
                        for (int i = 0; i < value.size(); ++i) {
                            this.subType.rotate(field, value.get(i), grid, rotation, doubledCenter);
                        }
                        return value;
                    }

                    @Override
                    public Object getDefault(StructureDirectionalField field, LittleStructure structure, Object defaultValue) {
                        List value = (List)field.get(structure);
                        value.clear();
                        if (defaultValue != null && defaultValue instanceof List) {
                            List list = (List)defaultValue;
                            value.addAll(list);
                        }
                        return value;
                    }
                };
            }
            return null;
        });
        StructureDirectionalType.register(Facing.class, new StructureDirectionalTypeSimple<Facing>(){

            @Override
            public Facing read(Tag nbt) {
                if (nbt instanceof IntTag) {
                    return Facing.values()[((IntTag)nbt).m_7047_()];
                }
                return null;
            }

            @Override
            public Tag write(Facing value) {
                return IntTag.m_128679_((int)value.ordinal());
            }

            @Override
            public Facing move(Facing value, LittleVecGrid offset) {
                return value;
            }

            @Override
            public Facing mirror(Facing value, LittleGrid grid, Axis axis, LittleVec doubledCenter) {
                return axis.mirror(value);
            }

            @Override
            public Facing rotate(Facing value, LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
                return rotation.rotate(value);
            }

            @Override
            public Facing getDefault() {
                return Facing.EAST;
            }
        });
        StructureDirectionalType.register(Axis.class, new StructureDirectionalTypeSimple<Axis>(){

            @Override
            public Axis read(Tag nbt) {
                if (nbt instanceof IntTag) {
                    return Axis.values()[((IntTag)nbt).m_7047_()];
                }
                return null;
            }

            @Override
            public Tag write(Axis value) {
                return IntTag.m_128679_((int)value.ordinal());
            }

            @Override
            public Axis move(Axis value, LittleVecGrid offset) {
                return value;
            }

            @Override
            public Axis mirror(Axis value, LittleGrid grid, Axis axis, LittleVec doubledCenter) {
                return value;
            }

            @Override
            public Axis rotate(Axis value, LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
                return rotation.rotate(value);
            }

            @Override
            public Axis getDefault() {
                return Axis.X;
            }
        });
        StructureDirectionalType.register(StructureRelative.class, new StructureDirectionalTypeSimple<StructureRelative>(){

            @Override
            public StructureRelative read(Tag nbt) {
                if (nbt instanceof IntArrayTag) {
                    return new StructureRelative(((IntArrayTag)nbt).m_128648_());
                }
                return null;
            }

            @Override
            public Tag write(StructureRelative value) {
                return new IntArrayTag(value.write());
            }

            @Override
            public StructureRelative move(StructureRelative value, LittleVecGrid offset) {
                value.move(offset);
                return value;
            }

            @Override
            public StructureRelative mirror(StructureRelative value, LittleGrid grid, Axis axis, LittleVec doubledCenter) {
                value.mirror(grid, axis, doubledCenter);
                return value;
            }

            @Override
            public StructureRelative rotate(StructureRelative value, LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
                value.rotate(grid, rotation, doubledCenter);
                return value;
            }

            @Override
            public LittleGrid getGrid(StructureRelative value) {
                return value.getGrid();
            }

            @Override
            public void convertToSmallest(StructureRelative value) {
                value.convertToSmallest();
            }

            @Override
            public void advancedScale(StructureRelative value, int from, int to) {
                value.advancedScale(from, to);
            }

            @Override
            public LittlePlaceBoxRelative getPlaceBox(StructureRelative value, LittleGroup previews, StructureDirectionalField field) {
                return value.getPlaceBox(previews, field);
            }

            @Override
            public StructureRelative getDefault() {
                return new StructureRelative(new LittleBox(0, 0, 0, 1, 1, 1), LittleGrid.MIN);
            }
        });
        StructureDirectionalType.register(Vec3f.class, new StructureDirectionalTypeSimple<Vec3f>(){

            @Override
            public Vec3f read(Tag nbt) {
                int[] array;
                if (nbt instanceof IntArrayTag && (array = ((IntArrayTag)nbt).m_128648_()).length == 3) {
                    return new Vec3f(Float.intBitsToFloat(array[0]), Float.intBitsToFloat(array[1]), Float.intBitsToFloat(array[2]));
                }
                return null;
            }

            @Override
            public Tag write(Vec3f value) {
                return new IntArrayTag(new int[]{Float.floatToIntBits(value.x), Float.floatToIntBits(value.y), Float.floatToIntBits(value.z)});
            }

            @Override
            public Vec3f move(Vec3f value, LittleVecGrid offset) {
                return value;
            }

            @Override
            public Vec3f mirror(Vec3f value, LittleGrid grid, Axis axis, LittleVec doubledCenter) {
                axis.mirror(value);
                return value;
            }

            @Override
            public Vec3f rotate(Vec3f value, LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
                rotation.transform(value);
                return value;
            }

            @Override
            public Vec3f getDefault() {
                return new Vec3f();
            }
        });
        StructureDirectionalType.register(AnimationTransition.class, new StructureDirectionalTypeSimple<AnimationTransition>(){

            @Override
            public AnimationTransition read(Tag nbt) {
                if (nbt instanceof CompoundTag) {
                    CompoundTag c = (CompoundTag)nbt;
                    return new AnimationTransition(c);
                }
                return null;
            }

            @Override
            public Tag write(AnimationTransition value) {
                return value.save();
            }

            @Override
            public AnimationTransition move(AnimationTransition value, LittleVecGrid vec) {
                return value;
            }

            @Override
            public AnimationTransition mirror(AnimationTransition value, LittleGrid grid, Axis axis, LittleVec doubledCenter) {
                value.timeline.mirror(axis);
                return value;
            }

            @Override
            public AnimationTransition rotate(AnimationTransition value, LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
                value.timeline.rotate(rotation);
                return value;
            }

            @Override
            public AnimationTransition getDefault() {
                throw new UnsupportedOperationException();
            }
        });
        StructureDirectionalType.register(AnimationState.class, new StructureDirectionalTypeSimple<AnimationState>(){

            @Override
            public AnimationState read(Tag nbt) {
                if (nbt instanceof CompoundTag) {
                    CompoundTag c = (CompoundTag)nbt;
                    return new AnimationState(c);
                }
                return null;
            }

            @Override
            public Tag write(AnimationState value) {
                return value.save();
            }

            @Override
            public AnimationState move(AnimationState value, LittleVecGrid vec) {
                return value;
            }

            @Override
            public AnimationState mirror(AnimationState value, LittleGrid grid, Axis axis, LittleVec doubledCenter) {
                value.mirror(axis);
                return value;
            }

            @Override
            public AnimationState rotate(AnimationState value, LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
                value.rotate(rotation);
                return value;
            }

            @Override
            public AnimationState getDefault() {
                throw new UnsupportedOperationException();
            }
        });
        StructureDirectionalType.register(AnimationStateDirected.class, new StructureDirectionalTypeSimple<AnimationStateDirected>(){

            @Override
            public AnimationStateDirected read(Tag nbt) {
                if (nbt instanceof CompoundTag) {
                    CompoundTag c = (CompoundTag)nbt;
                    return new AnimationStateDirected(c);
                }
                return null;
            }

            @Override
            public Tag write(AnimationStateDirected value) {
                return value.save();
            }

            @Override
            public AnimationStateDirected move(AnimationStateDirected value, LittleVecGrid vec) {
                return value;
            }

            @Override
            public AnimationStateDirected mirror(AnimationStateDirected value, LittleGrid grid, Axis axis, LittleVec doubledCenter) {
                value.mirror(axis);
                return value;
            }

            @Override
            public AnimationStateDirected rotate(AnimationStateDirected value, LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
                value.rotate(rotation);
                return value;
            }

            @Override
            public AnimationStateDirected getDefault() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public static abstract class StructureDirectionalTypeSimple<T>
    extends StructureDirectionalType<T> {
        @Override
        public T read(StructureDirectionalField field, LittleStructure structure, Tag nbt) {
            return this.read(nbt);
        }

        public abstract T read(Tag var1);

        @Override
        public Tag write(StructureDirectionalField field, T value) {
            return this.write(value);
        }

        public abstract Tag write(T var1);

        @Override
        public T move(StructureDirectionalField field, T value, LittleVecGrid vec) {
            return this.move(value, vec);
        }

        public abstract T move(T var1, LittleVecGrid var2);

        @Override
        public T mirror(StructureDirectionalField field, T value, LittleGrid grid, Axis axis, LittleVec doubledCenter) {
            return this.mirror(value, grid, axis, doubledCenter);
        }

        public abstract T mirror(T var1, LittleGrid var2, Axis var3, LittleVec var4);

        @Override
        public T rotate(StructureDirectionalField field, T value, LittleGrid grid, Rotation rotation, LittleVec doubledCenter) {
            return this.rotate(value, grid, rotation, doubledCenter);
        }

        public abstract T rotate(T var1, LittleGrid var2, Rotation var3, LittleVec var4);

        @Override
        public Object getDefault(StructureDirectionalField field, LittleStructure structure, Object defaultValue) {
            if (defaultValue != null) {
                return defaultValue;
            }
            return this.getDefault();
        }

        public abstract T getDefault();

        @Override
        public LittleGrid getGrid(StructureDirectionalField field, T value) {
            return this.getGrid(value);
        }

        public LittleGrid getGrid(T value) {
            return null;
        }
    }
}

