/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.directional;

import java.lang.reflect.Field;
import net.minecraft.nbt.CompoundTag;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.placement.box.LittlePlaceBoxRelative;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.directional.StructureDirectionalType;

public class StructureDirectionalField {
    public final Field field;
    public final String key;
    public final String saveKey;
    public final StructureDirectional annotation;
    public final StructureDirectionalType type;
    private Object defaultValue;

    public StructureDirectionalField(Class structureClass, Field field, StructureDirectional annotation) {
        this.field = field;
        this.key = field.getName();
        this.saveKey = annotation.saveKey().isEmpty() ? this.key : annotation.saveKey();
        this.annotation = annotation;
        this.type = StructureDirectionalType.getType(structureClass, field);
    }

    public void set(LittleStructure structure, Object value) {
        try {
            this.field.set(structure, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public Object get(LittleStructure structure) {
        try {
            return this.field.get(structure);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public Object createAndSet(LittleStructure structure, CompoundTag nbt) {
        Object relative = this.create(structure, nbt);
        this.set(structure, relative);
        return relative;
    }

    public void setDefault(Object value) {
        this.defaultValue = value;
    }

    public Object create(LittleStructure structure, CompoundTag nbt) {
        Object value = this.type.read(this, structure, nbt.m_128423_(this.saveKey));
        if (value == null) {
            return this.getDefault(structure);
        }
        return value;
    }

    public Object createTemporary(CompoundTag nbt) {
        return this.create(null, nbt);
    }

    public void save(CompoundTag nbt, Object value) {
        nbt.m_128365_(this.saveKey, this.type.write(this, value));
    }

    public Object move(Object value, LittleVecGrid vec) {
        return this.type.move(this, value, vec);
    }

    public Object mirror(Object value, LittleGrid context, Axis axis, LittleVec doubledCenter) {
        return this.type.mirror(this, value, context, axis, doubledCenter);
    }

    public Object rotate(Object value, LittleGrid context, Rotation rotation, LittleVec doubledCenter) {
        return this.type.rotate(this, value, context, rotation, doubledCenter);
    }

    public LittleGrid getGrid(Object value) {
        return this.type.getGrid(this, value);
    }

    public void convertToSmallest(Object value) {
        this.type.convertToSmallest(value);
    }

    public void advancedScale(Object value, int from, int to) {
        this.type.advancedScale(value, from, to);
    }

    public LittlePlaceBoxRelative getPlaceBox(Object value, LittleGroup group) {
        return this.type.getPlaceBox(value, group, this);
    }

    public Object getDefault(LittleStructure structure) {
        return this.type.getDefault(this, structure, this.defaultValue);
    }
}

