/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.connection.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.MissingBlockException;
import team.creative.littletiles.common.structure.exception.MissingStructureException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class StructureBlockConnector {
    public final BlockPos pos;
    public final LittleStructure structure;
    private BETiles cachedBE;

    public StructureBlockConnector(LittleStructure structure, BlockPos pos) {
        this.structure = structure;
        this.pos = pos;
    }

    public boolean is(BlockPos pos) {
        BlockPos structurePos = this.structure.getStructurePos();
        return structurePos.m_123341_() + this.pos.m_123341_() == pos.m_123341_() && structurePos.m_123342_() + this.pos.m_123342_() == pos.m_123342_() && structurePos.m_123343_() + this.pos.m_123343_() == pos.m_123343_();
    }

    public BlockPos getAbsolutePos() {
        return this.structure.getStructurePos().m_121955_((Vec3i)this.pos);
    }

    public BETiles getBlockEntity() throws CorruptedConnectionException, NotYetConnectedException {
        BlockPos absoluteCoord;
        Level level;
        if (this.cachedBE != null) {
            if (this.cachedBE.m_58901_()) {
                this.cachedBE = null;
            } else {
                return this.cachedBE;
            }
        }
        if ((level = this.structure.getStructureLevel()).m_46805_(absoluteCoord = this.getAbsolutePos())) {
            BlockEntity be = level.m_7702_(absoluteCoord);
            if (be instanceof BETiles) {
                this.cachedBE = (BETiles)be;
                return this.cachedBE;
            }
            throw new MissingBlockException(absoluteCoord);
        }
        throw new NotYetConnectedException();
    }

    public void connect() throws CorruptedConnectionException, NotYetConnectedException {
        BETiles be = this.getBlockEntity();
        if (!be.hasLoaded()) {
            throw new NotYetConnectedException();
        }
        IStructureParentCollection structure = be.getStructure(this.structure.getIndex());
        if (structure == null) {
            throw new MissingStructureException(be.m_58899_());
        }
    }

    public IStructureParentCollection getList() throws CorruptedConnectionException, NotYetConnectedException {
        BETiles be = this.getBlockEntity();
        if (!be.hasLoaded()) {
            throw new NotYetConnectedException();
        }
        IStructureParentCollection structure = be.getStructure(this.structure.getIndex());
        if (structure != null) {
            return structure;
        }
        throw new MissingStructureException(be.m_58899_());
    }

    public int count() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getList().size();
    }

    public void remove() throws CorruptedConnectionException, NotYetConnectedException {
        this.getBlockEntity().updateTiles(x -> x.removeStructure(this.structure.getIndex()));
    }
}

