/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.animation;

import java.text.ParseException;
import net.minecraft.nbt.CompoundTag;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;

public class AnimationSignalTrigger {
    public final SignalInputCondition condition;
    public final int transition;

    public AnimationSignalTrigger(CompoundTag nbt) {
        try {
            this.condition = SignalInputCondition.parseInput(nbt.m_128461_("i"));
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid trigger condition found '" + nbt.m_128461_("i") + "'");
        }
        this.transition = nbt.m_128451_("t");
    }

    public int signalChanged(LittleStructure structure) {
        if (this.condition.test(structure, false).any()) {
            return this.transition;
        }
        return -1;
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("i", this.condition.toString());
        nbt.m_128405_("t", this.transition);
        return nbt;
    }
}

