/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.type.itr.IterableIterator;
import team.creative.creativecore.common.util.type.list.IndexedCollector;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupHolder;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.StructureParentCollection;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.level.LittleUpdateCollector;
import team.creative.littletiles.common.level.little.LittleLevelTransitionManager;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.math.box.SurroundingBox;
import team.creative.littletiles.common.math.location.StructureLocation;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecAbsolute;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.packet.structure.StructureBlockToEntityPacket;
import team.creative.littletiles.common.packet.structure.StructureEntityToBlockPacket;
import team.creative.littletiles.common.packet.structure.StructureUpdate;
import team.creative.littletiles.common.placement.Placement;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.PlacementResult;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.connection.ILevelPositionProvider;
import team.creative.littletiles.common.structure.connection.block.StructureBlockConnector;
import team.creative.littletiles.common.structure.connection.children.LevelChildrenList;
import team.creative.littletiles.common.structure.connection.children.StructureChildConnection;
import team.creative.littletiles.common.structure.directional.StructureDirectionalField;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.MissingChildException;
import team.creative.littletiles.common.structure.exception.MissingParentException;
import team.creative.littletiles.common.structure.exception.NotEnoughSpaceForStructureException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.exception.RemovedStructureException;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.component.ISignalStructureComponent;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.input.InternalSignalInput;
import team.creative.littletiles.common.structure.signal.output.InternalSignalOutput;
import team.creative.littletiles.common.structure.signal.output.SignalExternalOutputHandler;
import team.creative.littletiles.common.structure.signal.schedule.ISignalSchedulable;

public abstract class LittleStructure
implements ISignalSchedulable,
ILevelPositionProvider {
    public final LittleStructureType type;
    public final IStructureParentCollection mainBlock;
    private final List<StructureBlockConnector> blocks = new ArrayList<StructureBlockConnector>();
    public String name;
    public final LevelChildrenList children = new LevelChildrenList(this);
    private HashMap<Integer, SignalExternalOutputHandler> externalHandler;
    private final InternalSignalInput[] inputs;
    private final InternalSignalOutput[] outputs;
    private boolean signalChanged = false;

    public LittleStructure(LittleStructureType type, IStructureParentCollection mainBlock) {
        this.type = type;
        this.mainBlock = mainBlock;
        this.inputs = type.createInputs(this);
        this.outputs = type.createOutputs(this);
    }

    @Override
    public Level getStructureLevel() {
        if (this.mainBlock == null || this.mainBlock.isRemoved()) {
            return null;
        }
        return this.mainBlock.getLevel();
    }

    @Override
    public Level getComponentLevel() {
        return this.getStructureLevel();
    }

    public boolean hasLevel() {
        return this.mainBlock != null && this.mainBlock.getLevel() != null && !this.mainBlock.isRemoved();
    }

    public boolean isClient() {
        return this.mainBlock != null && this.mainBlock.isClient();
    }

    @Override
    public BlockPos getStructurePos() {
        return this.mainBlock.getPos();
    }

    public int getIndex() {
        return this.mainBlock.getIndex();
    }

    public int getAttribute() {
        return this.type.attribute;
    }

    public StructureLocation getStructureLocation() {
        return new StructureLocation(this);
    }

    public boolean hasParent() {
        return this.children.hasParent();
    }

    public StructureChildConnection getParent() {
        return (StructureChildConnection)this.children.getParent();
    }

    public void checkConnections() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.mainBlock.isRemoved()) {
            throw new RemovedStructureException();
        }
        for (StructureBlockConnector block : this.blocks) {
            block.connect();
        }
        try {
            if (this.hasParent()) {
                this.getParent().checkConnection();
            }
        }
        catch (CorruptedConnectionException e) {
            throw new MissingParentException(this.getParent(), e);
        }
        for (StructureChildConnection child : this.children.all()) {
            try {
                child.getStructure().checkConnections();
            }
            catch (CorruptedConnectionException e) {
                throw new MissingChildException(child, e);
            }
        }
    }

    public void updateConnectionToParent(StructureChildConnection parentConnection) throws CorruptedConnectionException, NotYetConnectedException {
        int childId = parentConnection.getChildId();
        LittleStructure parent = parentConnection.getStructure();
        parent.children.connectToChild(childId, this);
        this.children.connectToParentAsChild(childId, parent);
        parent.updateStructure();
    }

    public void tryAttributeChangeForBlocks() throws CorruptedConnectionException, NotYetConnectedException {
        int attribute = this.getAttribute();
        this.mainBlock.setAttribute(attribute);
        for (StructureBlockConnector block : this.blocks) {
            try {
                block.getList().setAttribute(attribute);
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
    }

    public int count() throws CorruptedConnectionException, NotYetConnectedException {
        int count = this.mainBlock.size();
        for (StructureBlockConnector block : this.blocks) {
            count += block.count();
        }
        return count;
    }

    public boolean isChildOf(LittleStructure structure) throws CorruptedConnectionException, NotYetConnectedException {
        if (structure == this) {
            return true;
        }
        if (this.hasParent()) {
            return this.getParent().getStructure().isChildOf(structure);
        }
        return false;
    }

    public LittleStructure findTopStructure() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.hasParent()) {
            return this.getParent().getStructure().findTopStructure();
        }
        return this;
    }

    public IStructureParentCollection getBlock(BlockPos pos) {
        if (this.mainBlock.getPos().equals((Object)pos)) {
            return this.mainBlock;
        }
        for (StructureBlockConnector block : this.blocks) {
            if (!block.is(pos)) continue;
            try {
                return block.getList();
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                return null;
            }
        }
        return null;
    }

    public void addBlock(StructureParentCollection block) {
        this.blocks.add(new StructureBlockConnector(this, block.getPos().m_121996_((Vec3i)this.getStructurePos())));
    }

    public Iterable<BlockPos> positions() {
        return new IterableIterator<BlockPos>(){
            boolean first = true;
            Iterator<StructureBlockConnector> iterator;
            {
                this.iterator = LittleStructure.this.blocks.iterator();
            }

            public boolean hasNext() {
                return this.first || this.iterator.hasNext();
            }

            public BlockPos next() {
                if (this.first) {
                    this.first = false;
                    return LittleStructure.this.mainBlock.getPos();
                }
                return this.iterator.next().getAbsolutePos();
            }
        };
    }

    public Iterable<BETiles> blocks() throws CorruptedConnectionException, NotYetConnectedException {
        this.checkConnections();
        return new IterableIterator<BETiles>(){
            boolean first = true;
            Iterator<StructureBlockConnector> iterator;
            {
                this.iterator = LittleStructure.this.blocks.iterator();
            }

            public boolean hasNext() {
                return this.first || this.iterator.hasNext();
            }

            public BETiles next() {
                if (this.first) {
                    this.first = false;
                    return LittleStructure.this.mainBlock.getBE();
                }
                try {
                    return this.iterator.next().getBlockEntity();
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Iterable<IStructureParentCollection> blocksList() throws CorruptedConnectionException, NotYetConnectedException {
        this.checkConnections();
        return new IterableIterator<IStructureParentCollection>(){
            boolean first = true;
            Iterator<StructureBlockConnector> iterator;
            {
                this.iterator = LittleStructure.this.blocks.iterator();
            }

            public boolean hasNext() {
                return this.first || this.iterator.hasNext();
            }

            public IStructureParentCollection next() {
                if (this.first) {
                    this.first = false;
                    return LittleStructure.this.mainBlock;
                }
                try {
                    return this.iterator.next().getList();
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Iterable<Pair<IStructureParentCollection, LittleTile>> tiles() throws CorruptedConnectionException, NotYetConnectedException {
        final Iterator<IStructureParentCollection> iterator = this.blocksList().iterator();
        return new IterableIterator<Pair<IStructureParentCollection, LittleTile>>(){
            Iterator<LittleTile> inBlock = null;
            Pair<IStructureParentCollection, LittleTile> pair = null;

            public boolean hasNext() {
                while (this.inBlock == null || !this.inBlock.hasNext()) {
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    IStructureParentCollection list = (IStructureParentCollection)iterator.next();
                    this.pair = new Pair((Object)list, null);
                    this.inBlock = list.iterator();
                }
                return true;
            }

            public Pair<IStructureParentCollection, LittleTile> next() {
                this.pair.setValue((Object)this.inBlock.next());
                return this.pair;
            }
        };
    }

    public HashMapList<BlockPos, IStructureParentCollection> collectAllBlocksListSameWorld() throws CorruptedConnectionException, NotYetConnectedException {
        return this.collectAllBlocksListSameWorld((HashMapList<BlockPos, IStructureParentCollection>)new HashMapList());
    }

    protected HashMapList<BlockPos, IStructureParentCollection> collectAllBlocksListSameWorld(HashMapList<BlockPos, IStructureParentCollection> map) throws CorruptedConnectionException, NotYetConnectedException {
        for (IStructureParentCollection list : this.blocksList()) {
            map.add((Object)list.getPos(), (Object)list);
        }
        for (StructureChildConnection child : this.children.all()) {
            if (child.isLinkToAnotherWorld()) continue;
            child.getStructure().collectAllBlocksListSameWorld(map);
        }
        return map;
    }

    public void placedStructure(@Nullable ItemStack stack) {
        CompoundTag nbt;
        if (this.name == null && stack != null && (nbt = stack.m_41737_("display")) != null && nbt.m_128425_("Name", 8)) {
            this.name = nbt.m_128461_("Name");
        }
    }

    public void afterPlaced() {
        if (!this.isClient()) {
            this.schedule();
        }
    }

    public void finishedPlacement(Placement placement) {
    }

    public void load(CompoundTag nbt) {
        int i;
        Object array;
        this.blocks.clear();
        if (nbt.m_128441_("b")) {
            this.blocks.clear();
            array = nbt.m_128465_("b");
            i = 0;
            while (i + 2 < ((int[])array).length) {
                this.blocks.add(new StructureBlockConnector(this, new BlockPos((int)array[i], (int)array[i + 1], (int)array[i + 2])));
                i += 3;
            }
        }
        this.name = nbt.m_128441_("n") ? nbt.m_128461_("n") : null;
        this.children.load(nbt);
        array = this.type.directional.iterator();
        while (array.hasNext()) {
            StructureDirectionalField field = (StructureDirectionalField)array.next();
            if (nbt.m_128441_(field.saveKey)) {
                field.createAndSet(this, nbt);
                continue;
            }
            field.set(this, this.failedLoadingRelative(nbt, field));
        }
        if (nbt.m_128441_("ex")) {
            ListTag list = nbt.m_128437_("ex", 10);
            this.externalHandler = new HashMap();
            for (i = 0; i < list.size(); ++i) {
                try {
                    SignalExternalOutputHandler handler = new SignalExternalOutputHandler(this, list.m_128728_(i));
                    this.externalHandler.put(handler.index, handler);
                    continue;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        this.loadExtra(nbt);
        if (this.inputs != null) {
            for (int i2 = 0; i2 < this.inputs.length; ++i2) {
                this.inputs[i2].load(nbt);
            }
        }
        if (this.outputs != null) {
            for (int i3 = 0; i3 < this.outputs.length; ++i3) {
                this.outputs[i3].load(nbt.m_128469_(((LittleStructureType.InternalComponentOutput)this.outputs[i3].component).identifier));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void loadUpdatePacket(CompoundTag nbt) {
        this.load(nbt);
    }

    protected Object failedLoadingRelative(CompoundTag nbt, StructureDirectionalField field) {
        return field.getDefault(this);
    }

    protected abstract void loadExtra(CompoundTag var1);

    public CompoundTag savePreview(CompoundTag nbt, BlockPos newCenter) {
        LittleVecGrid vec = new LittleVecGrid(new LittleVec(this.mainBlock.getGrid(), (Vec3i)this.getStructurePos().m_121996_((Vec3i)newCenter)), this.mainBlock.getGrid());
        LittleVecGrid inverted = vec.copy();
        inverted.invert();
        for (StructureDirectionalField field : this.type.directional) {
            Object value = field.get(this);
            field.set(this, field.move(value, vec));
            field.save(nbt, value);
            field.set(this, field.move(value, inverted));
        }
        this.saveInternalExtra(nbt, true);
        return nbt;
    }

    public void save(CompoundTag nbt) {
        this.children.save(nbt);
        int[] array = new int[this.blocks.size() * 3];
        for (int i = 0; i < this.blocks.size(); ++i) {
            StructureBlockConnector block = this.blocks.get(i);
            array[i * 3] = block.pos.m_123341_();
            array[i * 3 + 1] = block.pos.m_123342_();
            array[i * 3 + 2] = block.pos.m_123343_();
        }
        if (array.length > 0) {
            nbt.m_128385_("b", array);
        }
        for (StructureDirectionalField field : this.type.directional) {
            Object value = field.get(this);
            field.save(nbt, value);
        }
        this.saveInternalExtra(nbt, false);
    }

    protected void saveInternalExtra(CompoundTag nbt, boolean preview) {
        nbt.m_128359_("id", this.type.id);
        if (this.name != null) {
            nbt.m_128359_("n", this.name);
        } else {
            nbt.m_128473_("n");
        }
        if (this.externalHandler != null && !this.externalHandler.isEmpty()) {
            ListTag list = new ListTag();
            for (SignalExternalOutputHandler handler : this.externalHandler.values()) {
                list.add((Object)handler.write(preview));
            }
            nbt.m_128365_("ex", (Tag)list);
        } else {
            nbt.m_128473_("ex");
        }
        if (this.inputs != null) {
            for (int i = 0; i < this.inputs.length; ++i) {
                this.inputs[i].save(preview, nbt);
            }
        }
        if (this.outputs != null) {
            for (int i = 0; i < this.outputs.length; ++i) {
                nbt.m_128365_(((LittleStructureType.InternalComponentOutput)this.outputs[i].component).identifier, (Tag)this.outputs[i].save(preview, new CompoundTag()));
            }
        }
        this.saveExtra(nbt);
    }

    protected abstract void saveExtra(CompoundTag var1);

    public void unload() {
    }

    public void tileDestroyed() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.hasParent()) {
            this.getParent().getStructure().tileDestroyed();
            return;
        }
        this.checkConnections();
        LittleUpdateCollector neighbor = new LittleUpdateCollector();
        this.removeStructure(neighbor);
        neighbor.process();
    }

    public void removeStructure(LittleUpdateCollector neighbor) throws CorruptedConnectionException, NotYetConnectedException {
        this.checkConnections();
        this.structureDestroyed();
        for (StructureChildConnection child : this.children.all()) {
            child.destroyStructure(neighbor);
        }
        Level level = this.mainBlock.getLevel();
        neighbor.add(level, this.mainBlock.getPos());
        for (StructureBlockConnector block : this.blocks) {
            neighbor.add(level, block.getAbsolutePos());
            block.remove();
        }
        this.mainBlock.getBE().updateTilesSecretly(x -> x.removeStructure(this.getIndex()));
    }

    public void removeStructureSameLevel(LittleUpdateCollector neighbor) throws CorruptedConnectionException, NotYetConnectedException {
        this.checkConnections();
        this.structureDestroyed();
        for (StructureChildConnection child : this.children.all()) {
            if (child.isLinkToAnotherWorld()) continue;
            child.destroyStructureSameLevel(neighbor);
        }
        Level level = this.mainBlock.getLevel();
        neighbor.add(level, this.mainBlock.getPos());
        for (StructureBlockConnector block : this.blocks) {
            neighbor.add(level, block.getAbsolutePos());
            block.remove();
        }
        this.mainBlock.getBE().updateTilesSecretly(x -> x.removeStructure(this.getIndex()));
    }

    protected void callStructureDestroyedToSameWorld() {
        for (StructureChildConnection child : this.children.all()) {
            if (child.isLinkToAnotherWorld()) continue;
            try {
                child.getStructure().callStructureDestroyedToSameWorld();
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
        this.structureDestroyed();
    }

    @Override
    public void structureDestroyed() {
        this.unload();
    }

    public boolean isAnimated() {
        LittleAnimationEntity entity;
        LittleSubLevel sub;
        Level level = this.getStructureLevel();
        return level instanceof LittleSubLevel && (level = (sub = (LittleSubLevel)level).getHolder()) instanceof LittleAnimationEntity && (entity = (LittleAnimationEntity)level).is(this);
    }

    public LittleAnimationEntity getAnimationEntity() {
        LittleSubLevel sub;
        Level level = this.getStructureLevel();
        if (level instanceof LittleSubLevel && (level = (sub = (LittleSubLevel)level).getHolder()) instanceof LittleAnimationEntity) {
            LittleAnimationEntity entity = (LittleAnimationEntity)level;
            return entity;
        }
        return null;
    }

    public StructureAbsolute createAnimationCenter(BlockPos pos, LittleGrid grid) {
        return null;
    }

    protected void transferOverFormChange(LittleStructure newStructure) {
    }

    public LittleAnimationEntity changeToEntityForm() throws LittleActionException {
        if (this.isAnimated()) {
            return null;
        }
        this.checkConnections();
        StructureLocation location = this.getStructureLocation();
        Level level = this.getStructureLevel();
        LittleAnimationLevel subLevel = new LittleAnimationLevel(level);
        BlockPos pos = this.getStructurePos();
        Placement placement = new Placement(null, subLevel, PlacementPreview.load(null, PlacementMode.ALL, this.getAbsolutePreviewsSameLevelOnly(pos), Facing.EAST));
        LittleUpdateCollector collector = new LittleUpdateCollector();
        LittleAnimationEntity entity = new LittleAnimationEntity(level, subLevel, this.createAnimationCenter(this.mainBlock.getPos(), this.mainBlock.getGrid()), placement);
        if (this.getParent() != null) {
            entity.getStructure().updateConnectionToParent(this.getParent());
        }
        level.m_7967_((Entity)entity);
        LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new StructureBlockToEntityPacket(location, entity), (Entity)entity);
        this.transferOverFormChange(entity.getStructure());
        this.removeStructureSameLevel(collector);
        entity.getStructure().transferChildrenToAnimation(entity);
        collector.process();
        entity.clearTrackingChanges();
        entity.initialTick();
        return entity;
    }

    protected void transferChildrenToAnimation(LittleAnimationEntity entity) throws CorruptedConnectionException, NotYetConnectedException {
        for (StructureChildConnection child : this.children.all()) {
            LittleStructure childStructure = child.getStructure();
            if (child.isLinkToAnotherWorld()) {
                LittleAnimationEntity subAnimation = childStructure.getAnimationEntity();
                LittleLevelTransitionManager.moveTo(subAnimation, entity.getSubLevel());
                subAnimation.initialTick();
                continue;
            }
            childStructure.transferChildrenToAnimation(entity);
        }
    }

    public void changeToBlockForm() throws LittleActionException {
        if (!this.isAnimated()) {
            return;
        }
        LittleAnimationEntity entity = this.getAnimationEntity();
        Level level = entity.m_9236_();
        BlockPos pos = this.getStructurePos();
        Placement placement = new Placement(null, level, PlacementPreview.load(null, PlacementMode.ALL, this.getAbsolutePreviewsSameLevelOnly(pos), Facing.EAST));
        LittleUpdateCollector collector = new LittleUpdateCollector();
        PlacementResult result = placement.place();
        if (result == null) {
            throw new NotEnoughSpaceForStructureException();
        }
        result.parentStructure.transferChildrenFromAnimation(level);
        if (this.getParent() != null) {
            result.parentStructure.updateConnectionToParent(this.getParent());
        }
        LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new StructureEntityToBlockPacket(entity), (Entity)entity);
        this.transferOverFormChange(result.parentStructure);
        this.removeStructureSameLevel(collector);
        collector.process();
        entity.m_142467_(Entity.RemovalReason.KILLED);
    }

    protected void transferChildrenFromAnimation(Level level) throws CorruptedConnectionException, NotYetConnectedException {
        for (StructureChildConnection child : this.children.all()) {
            LittleStructure childStructure = child.getStructure();
            if (child.isLinkToAnotherWorld()) {
                LittleAnimationEntity subAnimation = childStructure.getAnimationEntity();
                LittleLevelTransitionManager.moveTo(subAnimation, level);
                subAnimation.initialTick();
                continue;
            }
            childStructure.transferChildrenFromAnimation(level);
        }
    }

    public Iterable<ISignalStructureComponent> inputs() {
        return new IterableIterator<ISignalStructureComponent>(){
            Iterator<StructureChildConnection> iterator;
            ISignalStructureComponent next;
            {
                this.iterator = LittleStructure.this.children.all().iterator();
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (this.iterator.hasNext()) {
                        StructureChildConnection connection = this.iterator.next();
                        try {
                            if (!(connection.getStructure() instanceof ISignalStructureComponent) || ((ISignalStructureComponent)((Object)connection.getStructure())).getComponentType() != SignalComponentType.INPUT) continue;
                            this.next = (ISignalStructureComponent)((Object)connection.getStructure());
                            break;
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        }
                    }
                }
                return this.next != null;
            }

            public ISignalStructureComponent next() {
                ISignalStructureComponent result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    public Iterable<ISignalStructureComponent> outputs() {
        return new IterableIterator<ISignalStructureComponent>(){
            Iterator<StructureChildConnection> iterator;
            ISignalStructureComponent next;
            {
                this.iterator = LittleStructure.this.children.all().iterator();
            }

            public boolean hasNext() {
                if (this.next == null) {
                    while (this.iterator.hasNext()) {
                        StructureChildConnection connection = this.iterator.next();
                        try {
                            if (!(connection.getStructure() instanceof ISignalStructureComponent) || ((ISignalStructureComponent)((Object)connection.getStructure())).getComponentType() != SignalComponentType.OUTPUT) continue;
                            this.next = (ISignalStructureComponent)((Object)connection.getStructure());
                            break;
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        }
                    }
                }
                return this.next != null;
            }

            public ISignalStructureComponent next() {
                ISignalStructureComponent result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    @Override
    public void notifyChange() {
        if (this.hasParent()) {
            try {
                this.getParent().getStructure().processSignalChanges();
                return;
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
        this.processSignalChanges();
    }

    protected void processSignalChangesInternal() {
    }

    protected void processSignalChanges() {
        if (this.externalHandler != null && !this.externalHandler.isEmpty()) {
            for (SignalExternalOutputHandler handler : this.externalHandler.values()) {
                handler.update();
            }
        }
        if (this.outputs != null) {
            for (int i = 0; i < this.outputs.length; ++i) {
                this.outputs[i].update();
            }
        }
        this.processSignalChangesInternal();
        for (StructureChildConnection child : this.children.all()) {
            try {
                child.getStructure().processSignalChanges();
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
        }
    }

    @Override
    public boolean isStillAvailable() {
        return !this.mainBlock.isRemoved();
    }

    public void markDirty() {
        this.getStructureLevel().m_151543_(this.mainBlock.getPos());
    }

    @Override
    public boolean hasChanged() {
        return this.signalChanged;
    }

    @Override
    public void markChanged() {
        this.signalChanged = true;
    }

    @Override
    public void markUnchanged() {
        this.signalChanged = false;
    }

    public void changed(ISignalComponent changed) {
        this.schedule();
    }

    public InternalSignalInput getInput(int id) {
        if (this.inputs != null && id < this.inputs.length) {
            return this.inputs[id];
        }
        return null;
    }

    public int internalInputCount() {
        return this.inputs == null ? 0 : this.inputs.length;
    }

    public InternalSignalOutput getOutput(int id) {
        if (this.outputs != null && id < this.outputs.length) {
            return this.outputs[id];
        }
        return null;
    }

    public int internalOutputCount() {
        return this.outputs == null ? 0 : this.outputs.length;
    }

    public SignalExternalOutputHandler getExternalOutput(int index) {
        return this.externalHandler.get(index);
    }

    public boolean tryGetExternalOutput(int index, Consumer<SignalExternalOutputHandler> consumer) {
        SignalExternalOutputHandler output;
        if (this.externalHandler != null && (output = this.externalHandler.get(index)) != null) {
            consumer.accept(output);
            return true;
        }
        return false;
    }

    public boolean hasExternalOutputs() {
        return this.externalHandler != null && !this.externalHandler.isEmpty();
    }

    public Iterable<SignalExternalOutputHandler> externalOutputs() {
        return this.externalHandler.values();
    }

    public void setExternalOutputs(HashMap<Integer, SignalExternalOutputHandler> handlers) {
        this.externalHandler = handlers;
    }

    public void performInternalOutputChange(InternalSignalOutput output) {
    }

    public void receiveInternalOutputChange(InternalSignalOutput output) {
    }

    public LittleGroupAbsolute getAbsolutePreviews(BlockPos pos) throws CorruptedConnectionException, NotYetConnectedException {
        return new LittleGroupAbsolute(pos, this.getPreviews(pos));
    }

    public LittleGroup getPreviews(BlockPos pos) throws CorruptedConnectionException, NotYetConnectedException {
        CompoundTag structureNBT = new CompoundTag();
        this.savePreview(structureNBT, pos);
        ArrayList<LittleGroup> childrenGroup = new ArrayList<LittleGroup>();
        for (StructureChildConnection child : this.children.children()) {
            childrenGroup.add(child.getStructure().getPreviews(pos));
        }
        LittleGroup previews = new LittleGroup(structureNBT, childrenGroup);
        for (Pair<IStructureParentCollection, LittleTile> pair : this.tiles()) {
            LittleGroupAbsolute.add(previews, pos, (IParentCollection)pair.key, (LittleTile)pair.value);
        }
        for (Map.Entry entry : this.children.extensionEntries()) {
            previews.children.addExtension((String)entry.getKey(), ((StructureChildConnection)entry.getValue()).getStructure().getPreviews(pos));
        }
        previews.convertToSmallest();
        return previews;
    }

    public LittleGroupAbsolute getAbsolutePreviewsSameLevelOnly(BlockPos pos) throws CorruptedConnectionException, NotYetConnectedException {
        return new LittleGroupAbsolute(pos, this.getPreviewsSameLevelOnly(pos));
    }

    public LittleGroup getPreviewsSameLevelOnly(BlockPos pos) throws CorruptedConnectionException, NotYetConnectedException {
        CompoundTag structureNBT = new CompoundTag();
        this.savePreview(structureNBT, pos);
        ArrayList<LittleGroup> childrenGroup = new ArrayList<LittleGroup>();
        for (StructureChildConnection child : this.children.children()) {
            if (child.isLinkToAnotherWorld()) {
                childrenGroup.add(new LittleGroupHolder(child.getStructure()));
                continue;
            }
            childrenGroup.add(child.getStructure().getPreviewsSameLevelOnly(pos));
        }
        LittleGroup previews = new LittleGroup(structureNBT, childrenGroup);
        for (Pair<IStructureParentCollection, LittleTile> pair : this.tiles()) {
            LittleGroupAbsolute.add(previews, pos, (IParentCollection)pair.key, (LittleTile)pair.value);
        }
        for (Map.Entry entry : this.children.extensionEntries()) {
            if (((StructureChildConnection)entry.getValue()).isLinkToAnotherWorld()) {
                previews.children.addExtension((String)entry.getKey(), new LittleGroupHolder(((StructureChildConnection)entry.getValue()).getStructure()));
                continue;
            }
            previews.children.addExtension((String)entry.getKey(), ((StructureChildConnection)entry.getValue()).getStructure().getPreviewsSameLevelOnly(pos));
        }
        previews.convertToSmallest();
        return previews;
    }

    public BlockPos.MutableBlockPos getMinPos(BlockPos.MutableBlockPos pos) throws CorruptedConnectionException, NotYetConnectedException {
        for (BlockPos tePos : this.positions()) {
            pos.m_122178_(Math.min(pos.m_123341_(), tePos.m_123341_()), Math.min(pos.m_123342_(), tePos.m_123342_()), Math.min(pos.m_123343_(), tePos.m_123343_()));
        }
        for (StructureChildConnection child : this.children.all()) {
            child.getStructure().getMinPos(pos);
        }
        return pos;
    }

    public SurroundingBox getSurroundingBox() throws CorruptedConnectionException, NotYetConnectedException {
        SurroundingBox box = new SurroundingBox(true, this.getStructureLevel());
        box.add(this.mainBlock);
        for (StructureBlockConnector block : this.blocks) {
            box.add(block.getList());
        }
        return box;
    }

    public double getPercentVolume() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getSurroundingBox().getPercentVolume();
    }

    public Vec3d getHighestCenterVec() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getSurroundingBox().getHighestCenterVec();
    }

    public LittleVecAbsolute getHighestCenterPoint() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getSurroundingBox().getHighestCenterPoint();
    }

    public void updateStructure() {
        this.updateStructure(false);
    }

    public void updateStructure(boolean notifyNeighbours) {
        if (this.getStructureLevel() == null || this.isClient()) {
            return;
        }
        this.markDirty();
        LittleTiles.TICKERS.markUpdate(this, notifyNeighbours);
    }

    public CreativePacket generateUpdatePacket(boolean notifyNeighbours) {
        CompoundTag nbt = new CompoundTag();
        this.save(nbt);
        return new StructureUpdate(this.getStructureLocation(), nbt, notifyNeighbours);
    }

    public void broadcastPacket(CreativePacket packet) {
        LittleTiles.NETWORK.sendToClient(packet, this.getStructureLevel(), this.getStructurePos());
    }

    public ItemStack getStructureDrop() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.hasParent()) {
            return this.findTopStructure().getStructureDrop();
        }
        this.checkConnections();
        BlockPos.MutableBlockPos pos = this.getMinPos(this.getStructurePos().m_122032_());
        ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.get());
        stack.m_41751_(LittleGroup.save(this.getPreviews((BlockPos)pos)));
        if (this.name != null) {
            CompoundTag display = new CompoundTag();
            display.m_128359_("Name", this.name);
            stack.m_41783_().m_128365_("display", (Tag)display);
        }
        return stack;
    }

    public boolean canInteract() {
        return false;
    }

    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public boolean isBed(LivingEntity player) {
        return false;
    }

    public Direction getBedDirection() {
        return null;
    }

    public void onEntityCollidedWithBlock(Level level, IStructureParentCollection parent, BlockPos pos, Entity entityIn) {
    }

    public int getLightValue(BlockPos pos) {
        return 0;
    }

    public float getExplosionResistance() {
        return 0.0f;
    }

    public boolean hasStructureColor() {
        return false;
    }

    public int getStructureColor() {
        return -1;
    }

    public int getDefaultColor() {
        return -1;
    }

    public void paint(int color) {
    }

    public void tick() {
    }

    public void queueForNextTick() {
        LittleTiles.TICKERS.queueNexTick(this);
    }

    public boolean queuedTick() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(PoseStack pose, MultiBufferSource buffer, BlockPos pos, float partialTickTime) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getMaxRenderDistance() {
        return 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getRenderingBoxes(BlockPos pos, RenderType layer, IndexedCollector<LittleRenderBox> boxes) {
    }

    public void collectExtraBoxes(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, List<ABB> boxes) {
    }

    public void neighbourChanged() {
    }

    @Deprecated
    public void mirrorForWarpDrive(LittleGrid context, Axis axis) {
        ArrayList<StructureBlockConnector> newBlocks = new ArrayList<StructureBlockConnector>(this.blocks.size());
        for (StructureBlockConnector block : this.blocks) {
            newBlocks.add(new StructureBlockConnector(this, axis.mirror(block.pos)));
        }
        this.blocks.clear();
        this.blocks.addAll(newBlocks);
        for (StructureDirectionalField relative : this.type.directional) {
            relative.set(this, relative.mirror(relative.get(this), context, axis, context.rotationCenter));
        }
    }

    @Deprecated
    public void rotateForWarpDrive(LittleGrid context, Rotation rotation, int steps) {
        ArrayList<StructureBlockConnector> newBlocks = new ArrayList<StructureBlockConnector>(this.blocks.size());
        for (StructureBlockConnector block : this.blocks) {
            BlockPos pos = block.pos;
            for (int rotationStep = 0; rotationStep < steps; ++rotationStep) {
                pos = rotation.transform(pos);
            }
            newBlocks.add(new StructureBlockConnector(this, pos));
        }
        this.blocks.clear();
        this.blocks.addAll(newBlocks);
        for (StructureDirectionalField relative : this.type.directional) {
            relative.set(this, relative.rotate(relative.get(this), context, rotation, context.rotationCenter));
        }
    }

    public String info() {
        ArrayList<CallSite> infos = new ArrayList<CallSite>();
        if (this.inputs != null) {
            for (int i = 0; i < this.inputs.length; ++i) {
                infos.add((CallSite)((Object)("a" + i + ":" + this.inputs[i].getState().print(this.inputs[i].getBandwidth()))));
            }
        }
        for (ISignalStructureComponent component : this.inputs()) {
            try {
                infos.add((CallSite)((Object)("i" + component.getId() + ":" + component.getState().print(component.getBandwidth()))));
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                infos.add((CallSite)((Object)("i" + component.getId() + ":broken")));
            }
        }
        if (this.outputs != null) {
            for (int i = 0; i < this.outputs.length; ++i) {
                infos.add((CallSite)((Object)("b" + i + ":" + this.outputs[i].getState().print(this.outputs[i].getBandwidth()))));
            }
        }
        for (ISignalStructureComponent component : this.outputs()) {
            try {
                infos.add((CallSite)((Object)("o" + component.getId() + ":" + component.getState().print(component.getBandwidth()))));
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                infos.add((CallSite)((Object)("o" + component.getId() + ":broken")));
            }
        }
        return String.join((CharSequence)",", infos);
    }
}

