/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleTransformableBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeSelection;
import team.creative.littletiles.common.placement.shape.type.LittleShapePillar;

public class LittleShapeWall
extends LittleShape {
    public LittleShapeWall() {
        super(2);
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        int direction = selection.getNBT().m_128451_("direction");
        PlacementPosition originalMin = selection.getFirst().pos.copy();
        PlacementPosition originalMax = selection.getLast().pos.copy();
        originalMin.convertTo(boxes.getGrid());
        originalMax.convertTo(boxes.getGrid());
        int thickness = Math.max(0, selection.getNBT().m_128451_("thickness") - 1);
        LittleTransformableBox box = new LittleTransformableBox(selection.getOverallBox(), new int[1]);
        Axis toIgnore = direction == 0 ? Axis.Y : (direction == 1 ? Axis.X : Axis.Z);
        Axis oneIgnore = toIgnore.one();
        Axis twoIgnore = toIgnore.two();
        Axis axis = box.getSize(oneIgnore) > box.getSize(twoIgnore) ? oneIgnore : twoIgnore;
        Facing minFacing = originalMin.facing;
        Facing maxFacing = originalMax.facing;
        if (minFacing.axis == toIgnore || box.getSize(minFacing.axis) == 1) {
            minFacing = null;
        }
        if (maxFacing.axis == toIgnore || box.getSize(maxFacing.axis) == 1) {
            maxFacing = null;
        }
        if (minFacing != null && minFacing.axis != axis) {
            axis = minFacing.axis;
        }
        LittleTransformableBox littleTransformableBox = box;
        Objects.requireNonNull(littleTransformableBox);
        LittleTransformableBox.CornerCache cache = littleTransformableBox.new LittleTransformableBox.CornerCache(false);
        LittleVec originalMinVec = originalMin.getRelative(boxes.pos);
        LittleVec originalMaxVec = originalMax.getRelative(boxes.pos);
        LittleBox minBox = new LittleBox(originalMinVec);
        LittleBox maxBox = new LittleBox(originalMaxVec);
        if (minFacing != null && minFacing == maxFacing) {
            minFacing = Facing.get((Axis)axis, (originalMinVec.get(axis) > originalMaxVec.get(axis) ? 1 : 0) != 0);
            maxFacing = minFacing.opposite();
        }
        minBox.growAway(thickness, originalMin.facing);
        maxBox.growAway(thickness, originalMax.facing);
        box.growToInclude(minBox);
        box.growToInclude(maxBox);
        minBox.setMin(toIgnore, box.getMin(toIgnore));
        maxBox.setMin(toIgnore, box.getMin(toIgnore));
        minBox.setMax(toIgnore, box.getMax(toIgnore));
        maxBox.setMax(toIgnore, box.getMax(toIgnore));
        boolean facingPositive = originalMinVec.get(axis) > originalMaxVec.get(axis);
        LittleShapePillar.setStartAndEndBox(cache, axis.facing(facingPositive), minFacing, maxFacing, minBox, maxBox, selection.inside);
        box.setData(cache.getData());
        boxes.add(box);
    }

    @Override
    public void addExtraInformation(CompoundTag nbt, List<Component> list) {
        list.add((Component)Component.m_237115_((String)"gui.thickness").m_130946_(": " + nbt.m_128451_("thickness")).m_7220_((Component)Component.m_237115_((String)"gui.pixel.length")));
        int facing = nbt.m_128451_("direction");
        list.add((Component)Component.m_237115_((String)"gui.facing").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("gui.axis." + (switch (facing) {
            case 1 -> "x";
            case 2 -> "z";
            default -> "y";
        })))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<GuiControl> getCustomSettings(CompoundTag nbt, LittleGrid grid) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiLabel("label").setTranslate("gui.thickness"));
        controls.add((GuiControl)new GuiSteppedSlider("thickness", nbt.m_128451_("thickness"), 1, grid.count));
        controls.add((GuiControl)new GuiStateButton("direction", nbt.m_128451_("direction"), new String[]{"facing: y", "facing: x", "facing: z"}));
        return controls;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void saveCustomSettings(GuiParent gui, CompoundTag nbt, LittleGrid grid) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.m_128405_("thickness", (int)slider.getValue());
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.m_128405_("direction", state.getState());
    }

    @Override
    public void rotate(CompoundTag nbt, Rotation rotation) {
        int direction = nbt.m_128451_("direction");
        direction = rotation.axis != Axis.Y ? 0 : (direction == 1 ? 2 : 1);
        nbt.m_128405_("direction", direction);
    }

    @Override
    public void mirror(CompoundTag nbt, Axis axis) {
    }
}

