/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleTransformableBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeSelection;

public class LittleShapeSlice
extends LittleShape {
    public LittleShapeSlice() {
        super(2);
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        LittleTransformableBox box;
        LittleTransformableBox littleTransformableBox = box = new LittleTransformableBox(selection.getOverallBox(), new int[1]);
        Objects.requireNonNull(littleTransformableBox);
        LittleTransformableBox.CornerCache cache = littleTransformableBox.new LittleTransformableBox.CornerCache(false);
        Vec3i vec = this.getVec(selection.getNBT());
        Axis axis = vec.m_123341_() == 0 ? Axis.X : (vec.m_123342_() == 0 ? Axis.Y : Axis.Z);
        LittleVec size = box.getSize();
        Facing facingOne = axis.one().facing(vec.m_123304_(axis.one().toVanilla()) > 0);
        Facing facingTwo = axis.two().facing(vec.m_123304_(axis.two().toVanilla()) > 0);
        int sizeOne = size.get(axis.one());
        int sizeTwo = size.get(axis.two());
        Facing prefered = sizeOne > sizeTwo ? facingTwo : (sizeOne < sizeTwo ? facingOne : (axis.one() == Axis.Y ? facingOne : facingTwo));
        BoxCorner corner = BoxCorner.getCornerUnsorted((Facing)axis.facing(false), (Facing)facingOne, (Facing)facingTwo);
        cache.setAbsolute(corner, prefered.axis, box.get(prefered.opposite()));
        cache.setAbsolute(corner.mirror(axis), prefered.axis, box.get(prefered.opposite()));
        box.setData(cache.getData());
        boxes.add(box);
    }

    public Vec3i getVec(CompoundTag nbt) {
        int[] array;
        if (nbt.m_128441_("vec") && (array = nbt.m_128465_("vec")).length == 3) {
            return new Vec3i(array[0], array[1], array[2]);
        }
        return new Vec3i(0, 1, 1);
    }

    public void setVec(CompoundTag nbt, Vec3i vec) {
        nbt.m_128385_("vec", new int[]{vec.m_123341_(), vec.m_123342_(), vec.m_123343_()});
    }

    @Override
    public void addExtraInformation(CompoundTag nbt, List<Component> list) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<GuiControl> getCustomSettings(CompoundTag nbt, LittleGrid grid) {
        return new ArrayList<GuiControl>();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void saveCustomSettings(GuiParent gui, CompoundTag nbt, LittleGrid grid) {
    }

    @Override
    public void rotate(CompoundTag nbt, Rotation rotation) {
        this.setVec(nbt, rotation.transform(this.getVec(nbt)));
    }

    @Override
    public void mirror(CompoundTag nbt, Axis axis) {
        this.setVec(nbt, axis.mirror(this.getVec(nbt)));
    }
}

