/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleTransformableBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeSelection;

public class LittleShapePillar
extends LittleShape {
    public static void setStartAndEndBox(LittleTransformableBox.CornerCache cache, Facing facing, Facing startFace, Facing endFace, LittleBox start, LittleBox end, boolean inside) {
        BoxCorner corner;
        int i;
        Axis axis = facing.axis;
        Axis one = facing.one();
        Axis two = facing.two();
        if (startFace == null || startFace == facing.opposite()) {
            startFace = facing;
        }
        BoxCorner[] corners = BoxCorner.faceCorners((Facing)startFace);
        for (i = 0; i < corners.length; ++i) {
            cache.setAbsolute(corner, one, (corner = corners[i]).isFacingPositive(one) ? start.getMax(one) : start.getMin(one));
            cache.setAbsolute(corner, two, corner.isFacingPositive(two) ? start.getMax(two) : start.getMin(two));
        }
        if (endFace == null || startFace == endFace) {
            endFace = facing.opposite();
        }
        if (axis == endFace.axis) {
            corners = BoxCorner.faceCorners((Facing)endFace);
            for (i = 0; i < corners.length; ++i) {
                cache.setAbsolute(corner, one, (corner = corners[i]).isFacingPositive(one) ? end.getMax(one) : end.getMin(one));
                cache.setAbsolute(corner, two, corner.isFacingPositive(two) ? end.getMax(two) : end.getMin(two));
            }
            return;
        }
        corners = BoxCorner.faceCorners((Facing)facing.opposite());
        Axis targetAxis = endFace.axis;
        Axis third = Axis.third((Axis)axis, (Axis)targetAxis);
        for (int i2 = 0; i2 < corners.length; ++i2) {
            BoxCorner corner2 = corners[i2];
            BoxCorner newCorner = BoxCorner.getCornerUnsorted((Facing)(inside ? endFace : endFace.opposite()), (Facing)axis.facing(inside != facing.positive == endFace.positive != corner2.isFacingPositive(targetAxis)), (Facing)corner2.getFacing(third));
            cache.setAbsolute(corner2, axis, end.get(newCorner, axis));
            cache.setAbsolute(corner2, one, end.get(newCorner, one));
            cache.setAbsolute(corner2, two, end.get(newCorner, two));
        }
    }

    public LittleShapePillar() {
        super(2);
    }

    @Override
    public int maxAllowed() {
        return 2;
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        boolean facingPositive;
        int thickness = Math.max(0, selection.getNBT().m_128451_("thickness") - 1);
        PlacementPosition originalMin = selection.getFirst().pos.copy();
        PlacementPosition originalMax = selection.getLast().pos.copy();
        originalMin.convertTo(boxes.getGrid());
        originalMax.convertTo(boxes.getGrid());
        LittleTransformableBox box = new LittleTransformableBox(selection.getOverallBox(), new int[1]);
        Axis axis = box.getSize().getLongestAxis();
        Facing minFacing = originalMin.facing;
        Facing maxFacing = originalMax.facing;
        LittleVec originalMinVec = originalMin.getRelative(boxes.pos);
        LittleVec originalMaxVec = originalMax.getRelative(boxes.pos);
        LittleBox minBox = new LittleBox(originalMinVec);
        LittleBox maxBox = new LittleBox(originalMaxVec);
        if (selection.getNBT().m_128471_("simple")) {
            minFacing = null;
            maxFacing = null;
        } else {
            if (box.getSize(minFacing.axis) == 1 || (minFacing.positive ? minBox.getMax(minFacing.axis) > maxBox.getMax(minFacing.axis) : minBox.getMin(minFacing.axis) < maxBox.getMin(minFacing.axis))) {
                minFacing = null;
            }
            if (box.getSize(maxFacing.axis) == 1 || (maxFacing.positive ? minBox.getMax(maxFacing.axis) < maxBox.getMax(maxFacing.axis) : minBox.getMin(maxFacing.axis) > maxBox.getMin(maxFacing.axis))) {
                maxFacing = null;
            }
        }
        if (minFacing != null) {
            if (minFacing.axis != axis) {
                axis = minFacing.axis;
            }
        } else if (maxFacing != null && maxFacing.axis != axis) {
            axis = maxFacing.axis;
        }
        LittleTransformableBox littleTransformableBox = box;
        Objects.requireNonNull(littleTransformableBox);
        LittleTransformableBox.CornerCache cache = littleTransformableBox.new LittleTransformableBox.CornerCache(false);
        boolean bl = facingPositive = originalMinVec.get(axis) > originalMaxVec.get(axis);
        if (minFacing != null && minFacing == maxFacing) {
            minFacing = Facing.get((Axis)axis, (originalMinVec.get(axis) > originalMaxVec.get(axis) ? 1 : 0) != 0);
            maxFacing = minFacing.opposite();
        }
        minBox.growAway(thickness, originalMin.facing);
        maxBox.growAway(thickness, originalMax.facing);
        box.growToInclude(minBox);
        box.growToInclude(maxBox);
        LittleShapePillar.setStartAndEndBox(cache, axis.facing(facingPositive), minFacing, maxFacing, minBox, maxBox, selection.inside);
        box.setData(cache.getData());
        if (maxFacing == null) {
            maxFacing = axis.facing(!facingPositive);
        }
        Axis one = axis.one();
        Axis two = axis.two();
        switch (axis) {
            case X: {
                if (maxFacing.positive != facingPositive == originalMinVec.get(one) < originalMaxVec.get(one)) {
                    box.setFlipped(one.facing(true), true);
                    box.setFlipped(one.facing(false), true);
                }
                if (maxFacing.positive == facingPositive != originalMinVec.get(two) < originalMaxVec.get(two)) break;
                box.setFlipped(two.facing(true), true);
                box.setFlipped(two.facing(false), true);
                break;
            }
            case Y: {
                if (maxFacing.positive == facingPositive == originalMinVec.get(one) < originalMaxVec.get(one)) {
                    box.setFlipped(one.facing(true), true);
                    box.setFlipped(one.facing(false), true);
                }
                if (maxFacing.positive != facingPositive != originalMinVec.get(two) < originalMaxVec.get(two)) break;
                box.setFlipped(two.facing(true), true);
                box.setFlipped(two.facing(false), true);
                break;
            }
            case Z: {
                if (maxFacing.positive != facingPositive == originalMinVec.get(one) < originalMaxVec.get(one)) {
                    box.setFlipped(one.facing(true), true);
                    box.setFlipped(one.facing(false), true);
                }
                if (maxFacing.positive != facingPositive != originalMinVec.get(two) < originalMaxVec.get(two)) break;
                box.setFlipped(two.facing(true), true);
                box.setFlipped(two.facing(false), true);
            }
        }
        boxes.add(box);
    }

    @Override
    public void addExtraInformation(CompoundTag nbt, List<Component> list) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<GuiControl> getCustomSettings(CompoundTag nbt, LittleGrid grid) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiLabel("label").setTranslate("gui.thickness"));
        controls.add((GuiControl)new GuiSteppedSlider("thickness", nbt.m_128451_("thickness"), 1, grid.count));
        controls.add((GuiControl)new GuiCheckBox("simple", nbt.m_128471_("simple")).setTranslate("gui.simple"));
        return controls;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void saveCustomSettings(GuiParent gui, CompoundTag nbt, LittleGrid grid) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.m_128405_("thickness", (int)slider.getValue());
        nbt.m_128379_("simple", ((GuiCheckBox)gui.get((String)"simple", GuiCheckBox.class)).value);
    }

    @Override
    public void rotate(CompoundTag nbt, Rotation rotation) {
    }

    @Override
    public void mirror(CompoundTag nbt, Axis axis) {
    }
}

