/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.interpolation.CubicInterpolation;
import team.creative.creativecore.common.util.math.interpolation.HermiteInterpolation;
import team.creative.creativecore.common.util.math.interpolation.LinearInterpolation;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec2d;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.math.vec.VectorUtils;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeSelection;

public class LittleShapeCurveWall
extends LittleShape {
    private static String[] interpolationTypes = new String[]{"hermite", "cubic", "linear"};

    public LittleShapeCurveWall() {
        super(2);
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        int direction = selection.getNBT().m_128451_("direction");
        LittleBox overallBox = selection.getOverallBox();
        Axis axis = direction == 0 ? Axis.Y : (direction == 1 ? Axis.X : Axis.Z);
        Axis one = axis.one();
        Axis two = axis.two();
        ArrayList<Vec2d> points = new ArrayList<Vec2d>();
        double halfPixelSize = selection.getGrid().halfPixelLength;
        for (ShapeSelection.ShapeSelectPos pos : selection) {
            points.add(new Vec2d(pos.pos.getVanillaGrid(one) + halfPixelSize, pos.pos.getVanillaGrid(two) + halfPixelSize));
        }
        int thickness = Math.max(0, selection.getNBT().m_128451_("thickness") - 1);
        if (points.size() <= 1) {
            LittleBox box = selection.getOverallBox();
            box.growCentered(thickness);
            boxes.add(box);
            return;
        }
        HermiteInterpolation interpolation = switch (selection.getNBT().m_128451_("interpolation")) {
            case 0 -> new HermiteInterpolation((VecNd[])points.toArray(new Vec2d[0]));
            case 1 -> new CubicInterpolation((VecNd[])points.toArray(new Vec2d[0]));
            default -> new LinearInterpolation((VecNd[])points.toArray(new Vec2d[0]));
        };
        Vec2d origin = new Vec2d((double)VectorUtils.get((Axis)one, (Vec3i)boxes.pos), (double)VectorUtils.get((Axis)two, (Vec3i)boxes.pos));
        double pointTime = 1.0 / (double)(points.size() - 1);
        for (int i = 0; i < points.size() - 1; ++i) {
            Vec2d before = (Vec2d)points.get(i);
            Vec2d end = (Vec2d)points.get(i + 1);
            Vec2d middle = (Vec2d)interpolation.valueAt(pointTime * ((double)i + 0.5));
            double distance = before.distance(middle) + middle.distance(end);
            int stepCount = (int)Math.ceil(distance / boxes.grid.pixelLength * 2.0);
            double stepSize = pointTime / (double)(stepCount - 1);
            for (int j = 0; j < stepCount; ++j) {
                Vec2d vec = (Vec2d)interpolation.valueAt(pointTime * (double)i + stepSize * (double)j);
                vec.sub(origin);
                LittleVec point = new LittleVec(0, 0, 0);
                point.set(one, boxes.grid.toGrid(vec.x));
                point.set(two, boxes.grid.toGrid(vec.y));
                LittleBox box = new LittleBox(point);
                box.setMin(axis, overallBox.getMin(axis));
                box.setMax(axis, overallBox.getMax(axis));
                box.growCentered(thickness);
                boxes.add(box);
            }
        }
    }

    @Override
    public boolean requiresNoOverlap(ShapeSelection selection) {
        return true;
    }

    @Override
    public void addExtraInformation(CompoundTag nbt, List<Component> list) {
        list.add((Component)Component.m_237115_((String)"gui.interpolation").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("gui." + interpolationTypes[nbt.m_128451_("interpolation")]))));
        int facing = nbt.m_128451_("direction");
        list.add((Component)Component.m_237115_((String)"gui.facing").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("gui.axis." + (switch (facing) {
            case 1 -> "x";
            case 2 -> "z";
            default -> "y";
        })))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<GuiControl> getCustomSettings(CompoundTag nbt, LittleGrid grid) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiLabel("label").setTranslate("gui.thickness"));
        controls.add((GuiControl)new GuiSteppedSlider("thickness", nbt.m_128451_("thickness"), 1, grid.count));
        controls.add((GuiControl)new GuiStateButton("interpolation", nbt.m_128451_("interpolation"), interpolationTypes));
        controls.add((GuiControl)new GuiStateButton("direction", nbt.m_128451_("direction"), new String[]{"facing: y", "facing: x", "facing: z"}));
        return controls;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void saveCustomSettings(GuiParent gui, CompoundTag nbt, LittleGrid grid) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.m_128405_("thickness", (int)slider.getValue());
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.m_128405_("direction", state.getState());
        nbt.m_128405_("interpolation", ((GuiStateButton)gui.get("interpolation")).getState());
    }

    @Override
    public void rotate(CompoundTag nbt, Rotation rotation) {
        int direction = nbt.m_128451_("direction");
        direction = rotation.axis != Axis.Y ? 0 : (direction == 1 ? 2 : 1);
        nbt.m_128405_("direction", direction);
    }

    @Override
    public void mirror(CompoundTag nbt, Axis axis) {
    }
}

