/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.placement.shape.ShapeSelection;
import team.creative.littletiles.common.placement.shape.type.LittleShapeSelectable;

public class LittleShapeConnected
extends LittleShapeSelectable {
    private static final ConnectedBlock EMPTY = new ConnectedBlock(null, null);

    public LittleShapeConnected() {
        super(1);
    }

    @Override
    public boolean requiresNoOverlap(ShapeSelection selection) {
        return !selection.inside;
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        for (ShapeSelection.ShapeSelectPos pos : selection) {
            if (pos.result.isComplete()) {
                new ConnectedSearch(pos.result, selection.inside ? null : pos.pos.facing, selection.getGrid()).start(boxes);
                continue;
            }
            this.addBox(boxes, selection.inside, selection.getGrid(), pos.ray.m_82425_(), pos.pos.facing);
        }
    }

    @Override
    public void addExtraInformation(CompoundTag nbt, List<Component> list) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<GuiControl> getCustomSettings(CompoundTag nbt, LittleGrid grid) {
        return Collections.EMPTY_LIST;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void saveCustomSettings(GuiParent gui, CompoundTag nbt, LittleGrid grid) {
    }

    @Override
    public void rotate(CompoundTag nbt, Rotation rotation) {
    }

    @Override
    public void mirror(CompoundTag nbt, Axis axis) {
    }

    private static class ConnectedSearch {
        public final LittleElement element;
        public final LittleBox box;
        public final LittleGrid aimedGrid;
        public final HashMap<BlockPos, ConnectedBlock> blocks = new HashMap();
        public final Facing facing;
        public final ConnectedBlock origin;
        private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

        public ConnectedSearch(LittleTileContext context, Facing facing, LittleGrid aimedGrid) {
            this.element = context.tile;
            this.box = context.box;
            this.facing = facing;
            this.aimedGrid = aimedGrid;
            this.origin = new ConnectedBlock(context.parent.getBE(), this);
            this.blocks.put(context.parent.getPos(), this.origin);
        }

        public void addBox(LittleBoxes boxes, ConnectedBlock block, LittleBox box, Facing facing) {
            LittleShapeSelectable.addBox(boxes, facing == null, this.aimedGrid, block.parent.noneStructureTiles(), box, facing);
        }

        public LittleBoxes start(LittleBoxes boxes) {
            this.addBox(boxes, this.origin, this.box, this.facing);
            this.origin.performSearchIn(boxes, this, true, this.origin.parent.getGrid(), this.box, this.facing);
            return boxes;
        }

        public ConnectedBlock get(BlockPos pos, Facing facing) {
            this.pos.m_122190_((Vec3i)pos);
            this.pos.m_122173_(facing.toVanilla());
            ConnectedBlock block = this.blocks.get(this.pos);
            if (block == null) {
                if (this.blocks.size() > LittleTiles.CONFIG.rendering.connectedShapeBlocksLimit) {
                    return EMPTY;
                }
                BlockEntity be = this.origin.parent.m_58904_().m_7702_((BlockPos)this.pos);
                if (be instanceof BETiles) {
                    BETiles t = (BETiles)be;
                    block = new ConnectedBlock(t, this);
                } else {
                    block = EMPTY;
                }
                this.blocks.put(this.pos.m_7949_(), block);
            }
            return block;
        }
    }

    private static class ConnectedBlock {
        private final BETiles parent;
        private final List<LittleBox> potential;

        public ConnectedBlock(BETiles be, ConnectedSearch search) {
            this.parent = be;
            if (be != null) {
                this.potential = new ArrayList<LittleBox>();
                for (LittleTile tile : be.noneStructureTiles()) {
                    if (!tile.is(search.element)) continue;
                    for (LittleBox box : tile) {
                        if (box == search.box) continue;
                        this.potential.add(box);
                    }
                }
            } else {
                this.potential = Collections.EMPTY_LIST;
            }
        }

        public void performSearchIn(LittleBoxes boxes, ConnectedSearch search, boolean start, LittleGrid other, LittleBox otherBox, Facing insideFace) {
            LittleGrid context = this.parent.getGrid();
            ArrayList<LittleBox> added = new ArrayList<LittleBox>();
            for (int index = 0; index <= added.size(); ++index) {
                Iterator<LittleBox> iterator = this.potential.iterator();
                while (iterator.hasNext()) {
                    LittleBox box = iterator.next();
                    if (!(index == 0 ? box.doesTouch(context, other, otherBox) : box.doesTouch((LittleBox)added.get(index - 1)))) continue;
                    LittleBox copy = box.copy();
                    search.addBox(boxes, this, copy, insideFace);
                    added.add(box.copy());
                    iterator.remove();
                }
            }
            if (start) {
                added.add(otherBox);
            }
            for (LittleBox box : added) {
                for (int i = 0; i < Facing.VALUES.length; ++i) {
                    ConnectedBlock block;
                    Facing facing = Facing.get((int)i);
                    if (!box.isFaceAtEdge(context, facing) || (block = search.get(this.parent.m_58899_(), facing)).isEmpty()) continue;
                    LittleBox copyBox = box.copy();
                    copyBox.sub(context.count * facing.offset(Axis.X), context.count * facing.offset(Axis.Y), context.count * facing.offset(Axis.Z));
                    LittleGrid used = context;
                    if (block.getGrid().count > context.count) {
                        copyBox.convertTo(context, block.getGrid());
                        used = block.getGrid();
                    }
                    block.performSearchIn(boxes, search, false, used, copyBox, insideFace);
                }
            }
        }

        public LittleGrid getGrid() {
            return this.parent.getGrid();
        }

        public boolean isEmpty() {
            return this.potential.isEmpty();
        }
    }
}

