/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.box.collection.LittleBoxesNoOverlap;
import team.creative.littletiles.common.math.box.collection.LittleBoxesSimple;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;
import team.creative.littletiles.common.placement.shape.ShapeSelection;

public abstract class LittleShape {
    public final int pointsBeforePlacing;

    public LittleShape(int pointsBeforePlacing) {
        this.pointsBeforePlacing = pointsBeforePlacing;
    }

    public String getKey() {
        return ShapeRegistry.REGISTRY.getId((Object)this);
    }

    public String getTranslatableName() {
        return "shape." + this.getKey();
    }

    public Component getTranslatable() {
        return Component.m_237115_((String)this.getTranslatableName());
    }

    public int maxAllowed() {
        return -1;
    }

    protected abstract void addBoxes(LittleBoxes var1, ShapeSelection var2, boolean var3);

    public LittleBoxes getBoxes(ShapeSelection selection, boolean lowResolution) {
        LittleBoxes boxes = this.requiresNoOverlap(selection) ? new LittleBoxesNoOverlap(selection.getPos(), selection.getGrid()) : new LittleBoxesSimple(selection.getPos(), selection.getGrid());
        this.addBoxes(boxes, selection, lowResolution);
        return boxes;
    }

    public boolean requiresNoOverlap(ShapeSelection selection) {
        return false;
    }

    public abstract void addExtraInformation(CompoundTag var1, List<Component> var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<GuiControl> getCustomSettings(CompoundTag var1, LittleGrid var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void saveCustomSettings(GuiParent var1, CompoundTag var2, LittleGrid var3);

    public abstract void rotate(CompoundTag var1, Rotation var2);

    public abstract void mirror(CompoundTag var1, Axis var2);
}

