/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.selection;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.config.LittleBuildingConfig;
import team.creative.littletiles.common.config.LittleTilesConfig;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import team.creative.littletiles.common.placement.selection.SelectionMode;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class AreaSelectionMode
extends SelectionMode {
    @Override
    public SelectionMode.SelectionResult generateResult(Level level, CompoundTag nbt) {
        BlockPos pos = null;
        if (nbt.m_128441_("pos1")) {
            int[] array = nbt.m_128465_("pos1");
            pos = new BlockPos(array[0], array[1], array[2]);
        }
        BlockPos pos2 = null;
        if (nbt.m_128441_("pos2")) {
            int[] array = nbt.m_128465_("pos2");
            pos2 = new BlockPos(array[0], array[1], array[2]);
        }
        if (pos == null && pos2 == null) {
            return null;
        }
        if (pos == null) {
            pos = pos2;
        } else if (pos2 == null) {
            pos2 = pos;
        }
        SelectionMode.SelectionResult result = new SelectionMode.SelectionResult(level);
        result.addBlocks(pos, pos2);
        return result;
    }

    @Override
    public void leftClick(Player player, CompoundTag nbt, BlockPos pos) {
        nbt.m_128385_("pos1", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        if (!player.m_9236_().f_46443_) {
            player.m_213846_((Component)Component.m_237110_((String)"selection.mode.area.pos.first", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
        }
    }

    @Override
    public void rightClick(Player player, CompoundTag nbt, BlockPos pos) {
        nbt.m_128385_("pos2", new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        if (!player.m_9236_().f_46443_) {
            player.m_213846_((Component)Component.m_237110_((String)"selection.mode.area.pos.second", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
        }
    }

    @Override
    public void clear(ItemStack stack) {
        stack.m_41783_().m_128473_("pos1");
        stack.m_41783_().m_128473_("pos2");
    }

    @Override
    public LittleGroup getGroup(Level level, Player player, CompoundTag nbt, boolean includeVanilla, boolean includeCB, boolean includeLT, boolean rememberStructure) throws LittleActionException {
        BlockPos pos = null;
        if (nbt.m_128441_("pos1")) {
            int[] array = nbt.m_128465_("pos1");
            pos = new BlockPos(array[0], array[1], array[2]);
        }
        BlockPos pos2 = null;
        if (nbt.m_128441_("pos2")) {
            int[] array = nbt.m_128465_("pos2");
            pos2 = new BlockPos(array[0], array[1], array[2]);
        }
        if (pos == null && pos2 == null) {
            return null;
        }
        if (pos == null) {
            pos = pos2;
        } else if (pos2 == null) {
            pos2 = pos;
        }
        int minX = Math.min(pos.m_123341_(), pos2.m_123341_());
        int minY = Math.min(pos.m_123342_(), pos2.m_123342_());
        int minZ = Math.min(pos.m_123343_(), pos2.m_123343_());
        int maxX = Math.max(pos.m_123341_(), pos2.m_123341_());
        int maxY = Math.max(pos.m_123342_(), pos2.m_123342_());
        int maxZ = Math.max(pos.m_123343_(), pos2.m_123343_());
        LittleBuildingConfig config = (LittleBuildingConfig)LittleTiles.CONFIG.build.get(player);
        if (config.blueprintSizeLimit.isEnabled() && (maxX - minX) * (maxY - minY) * (maxZ - minZ) > (Integer)config.blueprintSizeLimit.value) {
            throw new LittleTilesConfig.AreaTooLarge(player, config);
        }
        AreaSelectionSearch search = new AreaSelectionSearch(player, includeVanilla, includeCB, includeLT, rememberStructure);
        search.scanLevel(level, minX, minY, minZ, maxX, maxY, maxZ);
        AABB bb = new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
        for (LittleEntity animation : ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(level)).find(bb)) {
            search.scanLevel(level, animation.getOrigin().getOBB(bb));
        }
        return search.build();
    }

    public static class AreaSelectionSearch {
        public final Player player;
        private final List<LittleStructure> structures;
        private final List<LittleGroup> children = new ArrayList<LittleGroup>();
        private final LittleGroup previews = new LittleGroup();
        private final boolean includeVanilla;
        private final boolean includeCB;
        private final boolean includeLT;
        private final boolean rememberStructure;
        private final boolean includeBE;
        private final BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();

        public AreaSelectionSearch(Player player, boolean includeVanilla, boolean includeCB, boolean includeLT, boolean rememberStructure) throws LittleTilesConfig.AreaTooLarge {
            this.player = player;
            this.includeVanilla = includeVanilla;
            this.includeCB = includeCB;
            this.includeLT = includeLT;
            this.rememberStructure = rememberStructure;
            this.includeBE = includeCB || includeLT;
            this.structures = rememberStructure ? new ArrayList() : null;
        }

        public void scanLevel(Level level, ABB bb) throws LittleActionException {
            this.scanLevel(level, Mth.m_14107_((double)bb.minX), Mth.m_14107_((double)bb.minY), Mth.m_14107_((double)bb.minZ), Mth.m_14165_((double)bb.maxX), Mth.m_14165_((double)bb.maxY), Mth.m_14165_((double)bb.maxZ));
        }

        public void scanLevel(Level level, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) throws LittleActionException {
            BlockPos center = new BlockPos(minX, minY, minZ);
            for (int posX = minX; posX <= maxX; ++posX) {
                for (int posY = minY; posY <= maxY; ++posY) {
                    for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                        BlockState state;
                        this.temp.m_122178_(posX, posY, posZ);
                        if (this.includeBE) {
                            LittleGroup specialPreviews;
                            BlockEntity blockEntity = level.m_7702_((BlockPos)this.temp);
                            if (this.includeLT && blockEntity instanceof BETiles) {
                                BETiles be = (BETiles)blockEntity;
                                for (IParentCollection parent : be.groups()) {
                                    if (this.rememberStructure && parent.isStructure()) {
                                        try {
                                            LittleStructure structure = parent.getStructure();
                                            while (structure.getParent() != null) {
                                                structure = structure.getParent().getStructure();
                                            }
                                            structure.checkConnections();
                                            if (this.structures.contains(structure)) continue;
                                            this.children.add(structure.getPreviews(center));
                                            this.structures.add(structure);
                                        }
                                        catch (CorruptedConnectionException | NotYetConnectedException e) {}
                                        continue;
                                    }
                                    for (LittleTile tile : parent) {
                                        tile = tile.copy();
                                        tile.move(new LittleVec(parent.getGrid().toGrid(posX - minX), parent.getGrid().toGrid(posY - minY), parent.getGrid().toGrid(posZ - minZ)));
                                        this.previews.add(parent.getGrid(), (LittleElement)tile, tile);
                                    }
                                }
                            }
                            if (this.includeCB && (specialPreviews = ChiselsAndBitsManager.getGroup(blockEntity)) != null) {
                                specialPreviews.move(new LittleVecGrid(new LittleVec(this.previews.getGrid().toGrid(posX - minX), this.previews.getGrid().toGrid(posY - minY), this.previews.getGrid().toGrid(posZ - minZ)), this.previews.getGrid()));
                                this.previews.add(specialPreviews);
                                continue;
                            }
                        }
                        if (!this.includeVanilla || !LittleAction.isBlockValid(state = level.m_8055_((BlockPos)this.temp))) continue;
                        LittleBox box = this.previews.getGrid().box();
                        box.add(new LittleVec((posX - minX) * this.previews.getGrid().count, (posY - minY) * this.previews.getGrid().count, (posZ - minZ) * this.previews.getGrid().count));
                        this.previews.add(this.previews.getGrid(), new LittleElement(state, -1), box);
                    }
                }
            }
        }

        public LittleGroup build() {
            if (this.children.isEmpty()) {
                return this.previews;
            }
            ArrayList<LittleGroup> newChildren = new ArrayList<LittleGroup>();
            for (LittleGroup child : this.previews.children.children()) {
                newChildren.add(child);
            }
            newChildren.addAll(this.children);
            return new LittleGroup(this.previews, newChildren);
        }
    }
}

