/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.mode;

import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.placement.PlacementContext;
import team.creative.littletiles.common.placement.mode.PlacementModeAll;
import team.creative.littletiles.common.placement.mode.PlacementModeColorize;
import team.creative.littletiles.common.placement.mode.PlacementModeFill;
import team.creative.littletiles.common.placement.mode.PlacementModeNormal;
import team.creative.littletiles.common.placement.mode.PlacementModeOverwrite;
import team.creative.littletiles.common.placement.mode.PlacementModeOverwriteAll;
import team.creative.littletiles.common.placement.mode.PlacementModeReplace;
import team.creative.littletiles.common.placement.mode.PlacementModeStencil;
import team.creative.littletiles.common.structure.LittleStructure;

public abstract class PlacementMode {
    private static final NamedHandlerRegistry<PlacementMode> REGISTRY = new NamedHandlerRegistry(null);
    public static final PlacementMode NORMAL = new PlacementModeNormal(PreviewMode.PREVIEWS, false);
    public static final PlacementMode FILL = new PlacementModeFill(PreviewMode.PREVIEWS);
    public static final PlacementMode ALL = new PlacementModeAll(PreviewMode.PREVIEWS);
    public static final PlacementMode OVERWRITE = new PlacementModeOverwrite(PreviewMode.PREVIEWS);
    public static final PlacementMode OVERWRITE_ALL = new PlacementModeOverwriteAll(PreviewMode.PREVIEWS);
    public static final PlacementMode REPLACE = new PlacementModeReplace(PreviewMode.LINES);
    public static final PlacementMode STENCIL = new PlacementModeStencil(PreviewMode.LINES);
    public static final PlacementMode COLORIZE = new PlacementModeColorize(PreviewMode.LINES);
    private static final TextMapBuilder<PlacementMode> MAP = new TextMapBuilder();
    public final boolean placeInside;
    private final PreviewMode mode;

    public static PlacementMode getStructureDefault() {
        return ALL;
    }

    public static PlacementMode getDefault() {
        return (PlacementMode)REGISTRY.getDefault();
    }

    public static PlacementMode getMode(String name) {
        return (PlacementMode)REGISTRY.get(name);
    }

    public static PlacementMode getMode(String name, boolean structure) {
        PlacementMode mode = (PlacementMode)REGISTRY.get(name);
        if (mode.canPlaceStructures() || !structure) {
            return mode;
        }
        return PlacementMode.getStructureDefault();
    }

    public static void register(String id, PlacementMode handler) {
        REGISTRY.register(id, (Object)handler);
        MAP.addComponent((Object)handler, (Component)Component.m_237115_((String)("placement.mode." + id)));
    }

    private static void registerDefault(String id, PlacementMode handler) {
        REGISTRY.registerDefault(id, (Object)handler);
        MAP.addComponent((Object)handler, (Component)Component.m_237115_((String)("placement.mode." + id)));
    }

    public static TextMapBuilder<PlacementMode> map() {
        return MAP;
    }

    public PlacementMode(PreviewMode mode, boolean placeInside) {
        this.mode = mode;
        this.placeInside = placeInside;
    }

    public String getId() {
        return REGISTRY.getId((Object)this);
    }

    public PreviewMode getPreviewMode() {
        if (LittleTiles.CONFIG.rendering.previewLines) {
            return PreviewMode.LINES;
        }
        return this.mode;
    }

    public abstract List<BlockPos> getCoordsToCheck(Set<BlockPos> var1, BlockPos var2);

    public abstract boolean placeTile(PlacementContext var1, LittleStructure var2, LittleTile var3) throws LittleActionException;

    @OnlyIn(value=Dist.CLIENT)
    public PlacementMode place() {
        return this;
    }

    public boolean canPlaceStructures() {
        return false;
    }

    public boolean checkAll() {
        return true;
    }

    public boolean shouldConvertBlock() {
        return false;
    }

    public void prepareBlock(PlacementContext context) {
    }

    public String translatableKey() {
        return "placement.mode." + REGISTRY.getId((Object)this);
    }

    public Component translatable() {
        return Component.m_237115_((String)this.translatableKey());
    }

    public LittleIngredients getBeforePlaceIngredients(LittleGroup previews) {
        return LittleAction.getIngredients(previews);
    }

    static {
        PlacementMode.register("normal", NORMAL);
        PlacementMode.registerDefault("fill", FILL);
        PlacementMode.register("all", ALL);
        PlacementMode.register("overwrite", OVERWRITE);
        PlacementMode.register("overwrite_all", OVERWRITE_ALL);
        PlacementMode.register("replace", REPLACE);
        PlacementMode.register("stencil", STENCIL);
        PlacementMode.register("colorize", COLORIZE);
    }

    public static enum PreviewMode {
        LINES,
        PREVIEWS;

    }
}

