/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecAbsolute;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.mode.PlacementMode;

public class PlacementHelper {
    public static ILittlePlacer getLittleInterface(ItemStack stack) {
        if (stack.m_41720_() instanceof ILittlePlacer) {
            return (ILittlePlacer)stack.m_41720_();
        }
        return null;
    }

    public static boolean isLittleBlock(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.m_41720_() instanceof ILittlePlacer) {
            return ((ILittlePlacer)stack.m_41720_()).hasTiles(stack);
        }
        return false;
    }

    public static LittleVecGrid getInternalOffset(ILittlePlacer iTile, ItemStack stack, LittleGroup tiles) {
        LittleVecGrid offset = iTile.getCachedMin(stack);
        if (offset != null) {
            return offset;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (LittleBox box : tiles.allBoxes()) {
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
        }
        return new LittleVecGrid(new LittleVec(minX, minY, minZ), tiles.getGrid());
    }

    public static LittleVecGrid getSize(ILittlePlacer iTile, ItemStack stack, LittleGroup tiles) {
        LittleVecGrid cached = iTile.getCachedSize(stack);
        if (cached != null) {
            return cached;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        LittleVec size = new LittleVec(0, 0, 0);
        for (LittleBox box : tiles.allBoxes()) {
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
            maxX = Math.max(maxX, box.maxX);
            maxY = Math.max(maxY, box.maxY);
            maxZ = Math.max(maxZ, box.maxZ);
        }
        return new LittleVecGrid(new LittleVec(maxX - minX, maxY - minY, maxZ - minZ).max(size), tiles.getGrid());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PlacementPosition getPosition(Level level, BlockHitResult moving, LittleGrid context, ILittleTool tile, ItemStack stack) {
        int x = moving.m_82425_().m_123341_();
        int y = moving.m_82425_().m_123342_();
        int z = moving.m_82425_().m_123343_();
        boolean canBePlacedInsideBlock = true;
        if (!PlacementHelper.canBePlacedInside(level, moving.m_82425_(), moving.m_82450_(), Facing.get((Direction)moving.m_82434_()))) {
            switch (moving.m_82434_()) {
                case EAST: {
                    ++x;
                    break;
                }
                case WEST: {
                    --x;
                    break;
                }
                case UP: {
                    ++y;
                    break;
                }
                case DOWN: {
                    --y;
                    break;
                }
                case SOUTH: {
                    ++z;
                    break;
                }
                case NORTH: {
                    --z;
                    break;
                }
            }
            canBePlacedInsideBlock = false;
        }
        if (context == null) {
            return null;
        }
        return new PlacementPosition(new BlockPos(x, y, z), PlacementHelper.getHitVec(moving, context, canBePlacedInsideBlock).getVecGrid(), Facing.get((Direction)moving.m_82434_()));
    }

    public static LittleBox getTilesBox(LittleVecAbsolute pos, LittleVec size, boolean centered, @Nullable Facing facing, PlacementMode mode) {
        LittleVec temp = pos.getVec().copy();
        if (centered) {
            if (mode.placeInside) {
                facing = facing.opposite();
            }
            if (facing.positive) {
                temp.set(facing.axis, temp.get(facing.axis) + size.calculateCenter().get(facing.axis));
            } else {
                temp.set(facing.axis, temp.get(facing.axis) - size.calculateInvertedCenter().get(facing.axis));
            }
        }
        return new LittleBox(temp, size.x, size.y, size.z);
    }

    public static boolean canBlockBeUsed(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BETiles) {
            return true;
        }
        return ChiselsAndBitsManager.isChiselsAndBitsStructure(blockEntity);
    }

    public static boolean canBePlacedInside(Level level, BlockPos pos, Vec3 hitVec, Facing side) {
        if (PlacementHelper.canBlockBeUsed(level, pos)) {
            switch (side) {
                case EAST: 
                case WEST: {
                    return !Maths.equals((double)((int)Maths.round((double)hitVec.f_82479_)), (double)hitVec.f_82479_, (double)1.0E-5);
                }
                case UP: 
                case DOWN: {
                    return !Maths.equals((double)((int)Maths.round((double)hitVec.f_82480_)), (double)hitVec.f_82480_, (double)1.0E-5);
                }
                case SOUTH: 
                case NORTH: {
                    return !Maths.equals((double)((int)Maths.round((double)hitVec.f_82481_)), (double)hitVec.f_82481_, (double)1.0E-5);
                }
            }
            return false;
        }
        return false;
    }

    public static LittleVecAbsolute getHitVec(BlockHitResult result, LittleGrid grid, boolean isInsideOfBlock) {
        LittleVecAbsolute pos = new LittleVecAbsolute((HitResult)result, grid);
        Facing facing = Facing.get((Direction)result.m_82434_());
        if (!isInsideOfBlock) {
            pos.getVec().set(facing.axis, facing.positive ? 0 : grid.count);
        }
        return pos;
    }
}

