/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.packet.structure;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.math.location.StructureLocation;
import team.creative.littletiles.common.packet.structure.StructurePacket;
import team.creative.littletiles.common.structure.LittleStructure;

public class StructureUpdate
extends StructurePacket {
    public CompoundTag structureNBT;
    public boolean notifyNeighbours;

    public StructureUpdate() {
    }

    public StructureUpdate(StructureLocation location, CompoundTag structureNBT, boolean notifyNeighbours) {
        super(location);
        this.structureNBT = structureNBT;
        this.notifyNeighbours = notifyNeighbours;
    }

    @Override
    public void execute(Player player, LittleStructure structure) {
        this.requiresClient(player);
        Consumer<BETiles.BlockEntityInteractor> action = x -> x.get(structure.mainBlock).setStructureNBT(this.structureNBT);
        if (this.notifyNeighbours) {
            structure.mainBlock.getBE().updateTiles(action);
        } else {
            structure.mainBlock.getBE().updateTilesSecretly(action);
        }
    }
}

