/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.mod.chiselsandbits;

import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;

public class ChiselAndBitsConveration {
    public static ConcurrentLinkedQueue<BlockEntity> blockEntities = new ConcurrentLinkedQueue();

    @SubscribeEvent
    public static void worldTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (!level.f_46443_ && event.phase == TickEvent.Phase.END) {
            LittleGrid chiselContext = LittleGrid.get(ChiselsAndBitsManager.convertingFrom);
            int progress = 0;
            int size = blockEntities.size();
            if (!blockEntities.isEmpty()) {
                LittleTiles.LOGGER.info("Attempting to convert " + size + " blocks ...");
            }
            while (!blockEntities.isEmpty()) {
                BlockEntity be = blockEntities.poll();
                LittleGroup tiles = ChiselsAndBitsManager.getGroup(be);
                if (tiles != null && !tiles.isEmpty()) {
                    be.m_58904_().m_46597_(be.m_58899_(), BlockTile.getState(false, false));
                    BETiles tileEntity = (BETiles)be.m_58904_().m_7702_(be.m_58899_());
                    tileEntity.convertTo(chiselContext);
                    tileEntity.updateTiles(x -> x.noneStructureTiles().addAll((Iterable<LittleTile>)((Object)tiles)));
                }
                if (++progress % 100 != 0) continue;
                LittleTiles.LOGGER.info("Converted " + progress + "/" + size + " blocks ...");
            }
            if (size > 0) {
                LittleTiles.LOGGER.info("Converted " + size + " blocks ...");
            }
        }
    }

    public static void onAddedTileEntity(BlockEntity te) {
        if (ChiselsAndBitsManager.isInstalled() && ChiselsAndBitsManager.isChiselsAndBitsStructure(te)) {
            blockEntities.add(te);
        }
    }
}

