/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.transformation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;

public class LittleTransformation {
    public BlockPos center;
    public int rotX;
    public int rotY;
    public int rotZ;
    public LittleVec doubledRotationCenter;
    public LittleVecGrid offset;

    public LittleTransformation(int[] array) {
        if (array.length != 13) {
            throw new IllegalArgumentException("Invalid array when creating door transformation!");
        }
        this.center = new BlockPos(array[0], array[1], array[2]);
        this.rotX = array[3];
        this.rotY = array[4];
        this.rotZ = array[5];
        this.doubledRotationCenter = new LittleVec(array[6], array[7], array[8]);
        this.offset = new LittleVecGrid(new LittleVec(array[9], array[10], array[11]), LittleGrid.get(array[12]));
    }

    public LittleTransformation(BlockPos center, int rotX, int rotY, int rotZ, LittleVec doubledRotationCenter, LittleVecGrid offset) {
        this.center = center;
        this.rotX = rotX;
        this.rotY = rotY;
        this.rotZ = rotZ;
        this.doubledRotationCenter = doubledRotationCenter;
        this.offset = offset;
    }

    public LittleTransformation(BlockPos center, Rotation rotation) {
        this.center = center;
        int n = rotation.axis == Axis.X ? (rotation.clockwise ? 1 : -1) : (this.rotX = 0);
        int n2 = rotation.axis == Axis.Y ? (rotation.clockwise ? 1 : -1) : (this.rotY = 0);
        this.rotZ = rotation.axis == Axis.Z ? (rotation.clockwise ? 1 : -1) : 0;
        this.doubledRotationCenter = new LittleVec(0, 0, 0);
        this.offset = new LittleVecGrid();
    }

    public Rotation getRotation(Axis axis) {
        switch (axis) {
            case X: {
                if (this.rotX == 0) {
                    return null;
                }
                return Rotation.getRotation((Axis)axis, (this.rotX > 0 ? 1 : 0) != 0);
            }
            case Y: {
                if (this.rotY == 0) {
                    return null;
                }
                return Rotation.getRotation((Axis)axis, (this.rotY > 0 ? 1 : 0) != 0);
            }
            case Z: {
                if (this.rotZ == 0) {
                    return null;
                }
                return Rotation.getRotation((Axis)axis, (this.rotZ > 0 ? 1 : 0) != 0);
            }
        }
        return null;
    }

    public BlockPos transform(BlockPos pos) {
        int i;
        Rotation rotation;
        pos = pos.m_121996_((Vec3i)this.center);
        if (this.rotX != 0) {
            rotation = this.getRotation(Axis.X);
            for (i = 0; i < Math.abs(this.rotX); ++i) {
                pos = rotation.transform(pos);
            }
        }
        if (this.rotY != 0) {
            rotation = this.getRotation(Axis.Y);
            for (i = 0; i < Math.abs(this.rotY); ++i) {
                pos = rotation.transform(pos);
            }
        }
        if (this.rotZ != 0) {
            rotation = this.getRotation(Axis.Z);
            for (i = 0; i < Math.abs(this.rotZ); ++i) {
                pos = rotation.transform(pos);
            }
        }
        pos = pos.m_121955_((Vec3i)this.center);
        if (this.offset != null) {
            pos = pos.m_121955_((Vec3i)this.offset.getBlockPos());
        }
        return pos;
    }

    public void transform(LittleGroupAbsolute previews) {
        int i;
        Rotation rotation;
        if (this.rotX != 0) {
            rotation = this.getRotation(Axis.X);
            for (i = 0; i < Math.abs(this.rotX); ++i) {
                previews.group.rotate(rotation, this.doubledRotationCenter);
            }
        }
        if (this.rotY != 0) {
            rotation = this.getRotation(Axis.Y);
            for (i = 0; i < Math.abs(this.rotY); ++i) {
                previews.group.rotate(rotation, this.doubledRotationCenter);
            }
        }
        if (this.rotZ != 0) {
            rotation = this.getRotation(Axis.Z);
            for (i = 0; i < Math.abs(this.rotZ); ++i) {
                previews.group.rotate(rotation, this.doubledRotationCenter);
            }
        }
        if (this.offset != null) {
            previews.group.move(this.offset);
        }
    }

    public int[] array() {
        return new int[]{this.center.m_123341_(), this.center.m_123342_(), this.center.m_123343_(), this.rotX, this.rotY, this.rotZ, this.doubledRotationCenter.x, this.doubledRotationCenter.y, this.doubledRotationCenter.z, this.offset.getVec().x, this.offset.getVec().y, this.offset.getVec().z, this.offset.getGrid().count};
    }

    public String toString() {
        return "center:" + this.center.m_123341_() + "," + this.center.m_123342_() + "," + this.center.m_123343_() + ";rotation:" + this.rotX + "," + this.rotY + "," + this.rotZ + ";offset:" + this.offset.getVec().x + "," + this.offset.getVec().y + "," + this.offset.getVec().z + ";context:" + this.offset.getGrid();
    }
}

