/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.face;

import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.face.ILittleFace;
import team.creative.littletiles.common.math.face.LittleFaceState;
import team.creative.littletiles.common.structure.attribute.LittleStructureAttribute;

public class LittleServerFace
implements ILittleFace {
    private final BETiles be;
    private final HashMap<Facing, Boolean> neighbours = new HashMap();
    private final HashMap<Facing, BETiles> neighboursTiles = new HashMap();
    private boolean validFace = false;
    private boolean partiallyFilled = false;
    private LittleTile tile;
    public LittleGrid grid;
    public LittleBox box = new LittleBox(0, 0, 0, 0, 0, 0);
    public Axis one;
    public Axis two;
    public Facing facing;
    public int minOne;
    public int minTwo;
    public int maxOne;
    public int maxTwo;
    public int origin;
    public int oldOrigin;
    public boolean[][] filled;

    public LittleServerFace(BETiles be) {
        this.be = be;
    }

    public LittleServerFace set(IParentCollection parent, LittleTile tile, LittleBox box, Facing facing) {
        this.box = box;
        this.facing = facing;
        this.one = facing.one();
        this.two = facing.two();
        this.grid = parent.getGrid();
        this.tile = tile;
        this.validFace = this.box.set(this, this.grid, facing);
        this.partiallyFilled = false;
        return this;
    }

    public void set(int minOne, int minTwo, int maxOne, int maxTwo, int origin) {
        this.minOne = minOne;
        this.minTwo = minTwo;
        this.maxOne = maxOne;
        this.maxTwo = maxTwo;
        this.origin = origin;
        this.oldOrigin = origin;
        this.filled = new boolean[maxOne - minOne][maxTwo - minTwo];
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    @Override
    public LittleBox box() {
        return this.box;
    }

    @Override
    public int getSmallest() {
        return this.box.getSmallest(this.grid);
    }

    @Override
    public void convertTo(LittleGrid to) {
        int ratio = to.count / this.grid.count;
        this.minOne *= ratio;
        this.minTwo *= ratio;
        this.maxOne *= ratio;
        this.maxTwo *= ratio;
        this.origin *= ratio;
        this.oldOrigin *= ratio;
        this.box = this.box.copy();
        this.box.convertTo(this.grid, to);
        this.grid = to;
        this.filled = new boolean[this.maxOne - this.minOne][this.maxTwo - this.minTwo];
    }

    public boolean isPartiallyFilled() {
        if (this.partiallyFilled) {
            return true;
        }
        for (int one = 0; one < this.filled.length; ++one) {
            for (int two = 0; two < this.filled[one].length; ++two) {
                if (!this.filled[one][two]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFilled() {
        for (int one = 0; one < this.filled.length; ++one) {
            for (int two = 0; two < this.filled[one].length; ++two) {
                if (this.filled[one][two]) continue;
                return false;
            }
        }
        return true;
    }

    public LittleBox getBox() {
        return this.box;
    }

    public boolean isFaceInsideBlock() {
        return this.origin > 0 && this.origin < this.grid.count;
    }

    public void move(Facing facing) {
        this.origin = facing.positive ? 0 : this.grid.count;
    }

    @Override
    public boolean supportsCutting() {
        return false;
    }

    @Override
    public void setPartiallyFilled() {
        this.partiallyFilled = true;
    }

    @Override
    public void cut(List<VectorFan> fans) {
    }

    @Override
    public Facing facing() {
        return this.facing;
    }

    @Override
    public Axis one() {
        return this.one;
    }

    @Override
    public Axis two() {
        return this.two;
    }

    @Override
    public int origin() {
        return this.origin;
    }

    @Override
    public int minOne() {
        return this.minOne;
    }

    @Override
    public int minTwo() {
        return this.minTwo;
    }

    @Override
    public int maxOne() {
        return this.maxOne;
    }

    @Override
    public int maxTwo() {
        return this.maxTwo;
    }

    @Override
    public void set(int one, int two, boolean value) {
        this.filled[one][two] = value;
    }

    public static LittleFaceState calculate(BETiles be, Facing facing, LittleServerFace face, LittleTile rendered, boolean outside) {
        return face.unsafeSameGridRestore((IGridBased)be, () -> {
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                if (((IParentCollection)pair.key).isStructure() && LittleStructureAttribute.noCollision(((IParentCollection)pair.key).getAttribute()) || !((LittleTile)pair.value).doesProvideSolidFace() && !((LittleTile)pair.value).canBeRenderCombined(rendered)) continue;
                ((LittleTile)pair.value).fillFace((IParentCollection)pair.key, face, be.getGrid());
            }
            if (outside) {
                if (face.isFilled()) {
                    return LittleFaceState.OUTISDE_COVERED;
                }
                if (face.isPartiallyFilled()) {
                    return LittleFaceState.OUTSIDE_PARTIALLY_COVERED;
                }
                return LittleFaceState.OUTSIDE_UNCOVERED;
            }
            if (face.isFilled()) {
                return LittleFaceState.INSIDE_COVERED;
            }
            if (face.isPartiallyFilled()) {
                return LittleFaceState.INSIDE_PARTIALLY_COVERED;
            }
            return LittleFaceState.INSIDE_UNCOVERED;
        });
    }

    public LittleFaceState calculate() {
        if (!this.validFace) {
            return LittleFaceState.UNLOADED;
        }
        if (this.isFaceInsideBlock()) {
            return LittleServerFace.calculate(this.be, this.facing, this, this.tile, false);
        }
        if (!this.tile.cullOverEdge()) {
            return LittleFaceState.OUTSIDE_UNCOVERED;
        }
        Boolean neighbourBlock = this.neighbours.get(this.facing);
        if (neighbourBlock == null) {
            neighbourBlock = LittleServerFace.checkforNeighbour(this.be.m_58904_(), this.facing.toVanilla(), this.be.m_58899_(), this.tile.getState(), this.tile.color);
            this.neighbours.put(this.facing, neighbourBlock);
        }
        if (neighbourBlock.booleanValue()) {
            return LittleFaceState.OUTISDE_COVERED;
        }
        BETiles otherTile = null;
        if (!this.neighboursTiles.containsKey(this.facing)) {
            otherTile = LittleServerFace.checkforBE(this.be.m_58904_(), this.facing.toVanilla(), this.be.m_58899_());
            this.neighboursTiles.put(this.facing, otherTile);
        } else {
            otherTile = this.neighboursTiles.get(this.facing);
        }
        if (otherTile != null) {
            this.move(this.facing);
            return LittleServerFace.calculate(otherTile, this.facing.opposite(), this, this.tile, true);
        }
        return LittleFaceState.OUTSIDE_UNCOVERED;
    }

    private static BETiles checkforBE(Level level, Direction facing, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos.m_121945_(facing));
        if (be instanceof BETiles) {
            return (BETiles)be;
        }
        return null;
    }

    private static boolean checkforNeighbour(Level level, Direction facing, BlockPos pos, BlockState state, int color) {
        return !Block.m_152444_((BlockState)state, (BlockGetter)level, (BlockPos)pos, (Direction)facing, (BlockPos)pos.m_121945_(facing)) || -1 == color && state == level.m_8055_(pos.m_121945_(facing));
    }
}

