/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.LittleBoxCombiner;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;

public final class LittleBoxesSimple
extends LittleBoxes
implements IGridBased,
Iterable<LittleBox> {
    protected List<LittleBox> boxes = new ArrayList<LittleBox>();

    public LittleBoxesSimple(BlockPos pos, LittleGrid context) {
        super(pos, context);
    }

    @Override
    public void add(LittleBox box) {
        this.boxes.add(box);
    }

    @Override
    public boolean isEmpty() {
        return this.boxes.isEmpty();
    }

    @Override
    public void clear() {
        this.boxes.clear();
    }

    @Override
    public int size() {
        return this.boxes.size();
    }

    @Override
    public void convertTo(LittleGrid to) {
        for (LittleBox box : this.boxes) {
            box.convertTo(this.grid, to);
        }
        this.grid = to;
    }

    @Override
    public int getSmallest() {
        int size = LittleGrid.MIN.count;
        for (LittleBox box : this.boxes) {
            size = Math.max(size, box.getSmallest(this.grid));
        }
        return size;
    }

    @Override
    public LittleBox getSurroundingBox() {
        if (this.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleBox box : this.boxes) {
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
            maxX = Math.max(maxX, box.maxX);
            maxY = Math.max(maxY, box.maxY);
            maxZ = Math.max(maxZ, box.maxZ);
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public Iterator<LittleBox> iterator() {
        return this.boxes.iterator();
    }

    @Override
    public Iterable<LittleBox> all() {
        return this;
    }

    @Override
    public HashMapList<BlockPos, LittleBox> generateBlockWise() {
        HashMapList map = new HashMapList();
        for (LittleBox box : this) {
            box.split(this.grid, this.pos, LittleVec.ZERO, (HashMapList<BlockPos, LittleBox>)map, null);
        }
        return map;
    }

    @Override
    public void mirror(Axis axis, LittleBoxAbsolute absoluteBox) {
        this.sameGrid((IGridBased)absoluteBox, () -> {
            LittleVec center = absoluteBox.getDoubledCenter(this.pos);
            for (LittleBox box : this.boxes) {
                box.mirror(axis, center);
            }
        });
    }

    @Override
    public LittleBoxes copy() {
        LittleBoxesSimple boxes = new LittleBoxesSimple(this.pos, this.grid);
        boxes.addBoxes(this.grid, this.pos, this);
        return boxes;
    }

    @Override
    public void combineBoxesBlocks() {
        HashMapList chunked = new HashMapList();
        for (int i = 0; i < this.boxes.size(); ++i) {
            chunked.add((Object)this.boxes.get(i).getMinVec().getBlockPos(this.grid), (Object)this.boxes.get(i));
        }
        this.boxes.clear();
        for (ArrayList list : chunked.values()) {
            LittleBoxCombiner.combine(list);
            this.boxes.addAll(list);
        }
    }

    @Override
    public int littleVolume() {
        int volume = 0;
        for (LittleBox box : this.boxes) {
            volume += box.getVolume();
        }
        return volume;
    }
}

