/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.RangedBitSet;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBoxCombiner;
import team.creative.littletiles.common.math.box.LittleBoxSorting;
import team.creative.littletiles.common.math.box.LittleTransformableBox;
import team.creative.littletiles.common.math.box.volume.LittleBoxReturnedVolume;
import team.creative.littletiles.common.math.face.ILittleFace;
import team.creative.littletiles.common.math.face.LittleFace;
import team.creative.littletiles.common.math.face.LittleFaceState;
import team.creative.littletiles.common.math.face.LittleServerFace;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.SplitRangeBoxes;

public class LittleBox {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    protected int faceCache;
    private static final Comparator<LittleBox> SORT_BY_FACHE_CACHE = (box1, box2) -> Integer.compare(box1.faceCache, box2.faceCache);

    public LittleBox(LittleVec center, int sizeX, int sizeY, int sizeZ) {
        LittleVec offset = new LittleVec(sizeX, sizeY, sizeZ).calculateCenter();
        this.minX = center.x - offset.x;
        this.minY = center.y - offset.y;
        this.minZ = center.z - offset.z;
        this.maxX = this.minX + sizeX;
        this.maxY = this.minY + sizeY;
        this.maxZ = this.minZ + sizeZ;
    }

    public LittleBox(LittleGrid context, AlignedBox cube) {
        this(context.toGrid(cube.minX), context.toGrid(cube.minY), context.toGrid(cube.minZ), context.toGrid(cube.maxX), context.toGrid(cube.maxY), context.toGrid(cube.maxZ));
    }

    public LittleBox(LittleGrid context, AABB box) {
        this(context.toGrid(box.f_82288_), context.toGrid(box.f_82289_), context.toGrid(box.f_82290_), context.toGrid(box.f_82291_), context.toGrid(box.f_82292_), context.toGrid(box.f_82293_));
    }

    public LittleBox(LittleBox ... boxes) {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (int i = 0; i < boxes.length; ++i) {
            this.minX = Math.min(boxes[i].minX, this.minX);
            this.minY = Math.min(boxes[i].minY, this.minY);
            this.minZ = Math.min(boxes[i].minZ, this.minZ);
            this.maxX = Math.max(boxes[i].maxX, this.maxX);
            this.maxY = Math.max(boxes[i].maxY, this.maxY);
            this.maxZ = Math.max(boxes[i].maxZ, this.maxZ);
        }
    }

    public LittleBox(LittleVec min, LittleVec max) {
        this(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public LittleBox(LittleVec min) {
        this(min.x, min.y, min.z, min.x + 1, min.y + 1, min.z + 1);
    }

    public LittleBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public ABB getABB(LittleGrid grid) {
        return new ABB(grid.toVanillaGrid(this.minX), grid.toVanillaGrid(this.minY), grid.toVanillaGrid(this.minZ), grid.toVanillaGrid(this.maxX), grid.toVanillaGrid(this.maxY), grid.toVanillaGrid(this.maxZ));
    }

    public AABB getSelectionBB(LittleGrid grid, BlockPos pos) {
        return this.getBB(grid, pos);
    }

    public AABB getBB(LittleGrid grid, BlockPos offset) {
        return new AABB(grid.toVanillaGrid(this.minX) + (double)offset.m_123341_(), grid.toVanillaGrid(this.minY) + (double)offset.m_123342_(), grid.toVanillaGrid(this.minZ) + (double)offset.m_123343_(), grid.toVanillaGrid(this.maxX) + (double)offset.m_123341_(), grid.toVanillaGrid(this.maxY) + (double)offset.m_123342_(), grid.toVanillaGrid(this.maxZ) + (double)offset.m_123343_());
    }

    public VoxelShape getShape(LittleGrid grid) {
        return Shapes.m_83048_((double)grid.toVanillaGrid(this.minX), (double)grid.toVanillaGrid(this.minY), (double)grid.toVanillaGrid(this.minZ), (double)grid.toVanillaGrid(this.maxX), (double)grid.toVanillaGrid(this.maxY), (double)grid.toVanillaGrid(this.maxZ));
    }

    public AABB getBB(LittleGrid grid) {
        return new AABB(grid.toVanillaGrid(this.minX), grid.toVanillaGrid(this.minY), grid.toVanillaGrid(this.minZ), grid.toVanillaGrid(this.maxX), grid.toVanillaGrid(this.maxY), grid.toVanillaGrid(this.maxZ));
    }

    public AlignedBox getBox(LittleGrid grid) {
        return new AlignedBox((float)grid.toVanillaGrid(this.minX), (float)grid.toVanillaGrid(this.minY), (float)grid.toVanillaGrid(this.minZ), (float)grid.toVanillaGrid(this.maxX), (float)grid.toVanillaGrid(this.maxY), (float)grid.toVanillaGrid(this.maxZ));
    }

    public AlignedBox getBox(LittleGrid grid, LittleVec offset) {
        return new AlignedBox((float)grid.toVanillaGrid(this.minX + offset.x), (float)grid.toVanillaGrid(this.minY + offset.y), (float)grid.toVanillaGrid(this.minZ + offset.z), (float)grid.toVanillaGrid(this.maxX + offset.x), (float)grid.toVanillaGrid(this.maxY + offset.y), (float)grid.toVanillaGrid(this.maxZ + offset.z));
    }

    public void changed() {
    }

    public int[] getArray() {
        return new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }

    public IntArrayTag getArrayTag() {
        return new IntArrayTag(this.getArray());
    }

    public int[] getArrayExtended(IParentCollection parent, LittleTile tile, LittleServerFace face) {
        this.hasOrCreateFaceState(parent, tile, face);
        return new int[]{this.faceCache, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }

    public IntArrayTag getArrayTagExtended(IParentCollection parent, LittleTile tile, LittleServerFace face) {
        return new IntArrayTag(this.getArrayExtended(parent, tile, face));
    }

    public int getSmallest(LittleGrid grid) {
        int size = LittleGrid.MIN.count;
        size = Math.max(size, grid.getMinGrid(this.minX));
        size = Math.max(size, grid.getMinGrid(this.minY));
        size = Math.max(size, grid.getMinGrid(this.minZ));
        size = Math.max(size, grid.getMinGrid(this.maxX));
        size = Math.max(size, grid.getMinGrid(this.maxY));
        size = Math.max(size, grid.getMinGrid(this.maxZ));
        return size;
    }

    protected void scale(int ratio) {
        this.minX *= ratio;
        this.minY *= ratio;
        this.minZ *= ratio;
        this.maxX *= ratio;
        this.maxY *= ratio;
        this.maxZ *= ratio;
    }

    protected void divide(int ratio) {
        this.minX /= ratio;
        this.minY /= ratio;
        this.minZ /= ratio;
        this.maxX /= ratio;
        this.maxY /= ratio;
        this.maxZ /= ratio;
    }

    public void convertTo(LittleGrid from, LittleGrid to) {
        if (from.count > to.count) {
            this.divide(from.count / to.count);
        } else {
            this.scale(to.count / from.count);
        }
    }

    public void convertTo(int from, int to) {
        if (from > to) {
            this.divide(from / to);
        } else {
            this.scale(to / from);
        }
    }

    public int getLongestSide() {
        return Math.max(this.maxX - this.minX, Math.max(this.maxY - this.minY, this.maxZ - this.minZ));
    }

    public boolean isMinimumSize() {
        return this.maxX - this.minX == 1 && this.maxY - this.minY == 1 && this.maxZ - this.minZ == 1;
    }

    public LittleVec getSize() {
        return new LittleVec(this.maxX - this.minX, this.maxY - this.minY, this.maxZ - this.minZ);
    }

    public int getVolume() {
        return (this.maxX - this.minX) * (this.maxY - this.minY) * (this.maxZ - this.minZ);
    }

    public double getPercentVolume(LittleGrid context) {
        return (double)this.getVolume() / (double)context.count3d;
    }

    public int get(Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> this.maxX;
            case Facing.WEST -> this.minX;
            case Facing.UP -> this.maxY;
            case Facing.DOWN -> this.minY;
            case Facing.SOUTH -> this.maxZ;
            case Facing.NORTH -> this.minZ;
        };
    }

    public void set(Facing facing, int value) {
        if (facing.positive) {
            this.setMax(facing.axis, value);
        } else {
            this.setMin(facing.axis, value);
        }
    }

    public LittleVec get(BoxCorner corner) {
        return new LittleVec(this.getX(corner), this.getY(corner), this.getZ(corner));
    }

    public int get(BoxCorner corner, Axis axis) {
        return this.get(corner.getFacing(axis));
    }

    public int getX(BoxCorner corner) {
        return this.get(corner.x);
    }

    public int getY(BoxCorner corner) {
        return this.get(corner.y);
    }

    public int getZ(BoxCorner corner) {
        return this.get(corner.z);
    }

    public int getSize(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.maxX - this.minX;
            case Axis.Y -> this.maxY - this.minY;
            case Axis.Z -> this.maxZ - this.minZ;
        };
    }

    public void setMin(Axis axis, int value) {
        switch (axis) {
            case X: {
                this.minX = value;
                break;
            }
            case Y: {
                this.minY = value;
                break;
            }
            case Z: {
                this.minZ = value;
            }
        }
        this.changed();
    }

    public int getMin(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.minX;
            case Axis.Y -> this.minY;
            case Axis.Z -> this.minZ;
        };
    }

    public void setMax(Axis axis, int value) {
        switch (axis) {
            case X: {
                this.maxX = value;
                break;
            }
            case Y: {
                this.maxY = value;
                break;
            }
            case Z: {
                this.maxZ = value;
            }
        }
        this.changed();
    }

    public int getMax(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.maxX;
            case Axis.Y -> this.maxY;
            case Axis.Z -> this.maxZ;
        };
    }

    public void setMinMax(Axis axis, int min, int max) {
        this.setMin(axis, min);
        this.setMax(axis, max);
    }

    public void setMinMax(Axis one, int minOne, int maxOne, Axis two, int minTwo, int maxTwo) {
        this.setMin(one, minOne);
        this.setMax(one, maxOne);
        this.setMin(two, minTwo);
        this.setMax(two, maxTwo);
    }

    public LittleVec[] getCorners() {
        LittleVec[] corners = new LittleVec[BoxCorner.values().length];
        for (int i = 0; i < corners.length; ++i) {
            BoxCorner corner = BoxCorner.values()[i];
            corners[i] = new LittleVec(this.get(corner.x), this.get(corner.y), this.get(corner.z));
        }
        return corners;
    }

    public LittleVec[] getCorners(BoxCorner[] corners) {
        LittleVec[] vecs = new LittleVec[corners.length];
        for (int i = 0; i < corners.length; ++i) {
            vecs[i] = new LittleVec(this.get(corners[i].x), this.get(corners[i].y), this.get(corners[i].z));
        }
        return vecs;
    }

    public LittleVec[] fillCorners(BoxCorner[] corners, LittleVec[] vecs) {
        for (int i = 0; i < corners.length; ++i) {
            vecs[i] = new LittleVec(this.get(corners[i].x), this.get(corners[i].y), this.get(corners[i].z));
        }
        return vecs;
    }

    public boolean isValidBox() {
        return this.maxX > this.minX && this.maxY > this.minY && this.maxZ > this.minZ;
    }

    public void setMinPos(BlockPos.MutableBlockPos pos, LittleGrid grid) {
        pos.m_122178_(grid.toBlockOffset(this.minX), grid.toBlockOffset(this.minY), grid.toBlockOffset(this.minZ));
    }

    public boolean needsMultipleBlocks(LittleGrid grid) {
        int x = this.minX / grid.count;
        int y = this.minY / grid.count;
        int z = this.minZ / grid.count;
        return this.maxX - x * grid.count <= grid.count && this.maxY - y * grid.count <= grid.count && this.maxZ - z * grid.count <= grid.count;
    }

    public boolean isBoxInsideBlock(LittleGrid grid) {
        return this.minX >= 0 && this.maxX <= grid.count && this.minY >= 0 && this.maxY <= grid.count && this.minZ >= 0 && this.maxZ <= grid.count;
    }

    public void splitIterator(LittleGrid grid, BlockPos.MutableBlockPos toUse, LittleVec vec, BiConsumer<BlockPos.MutableBlockPos, LittleBox> consumer) {
        int minOffX = grid.toBlockOffset(this.minX + vec.x);
        int minOffY = grid.toBlockOffset(this.minY + vec.y);
        int minOffZ = grid.toBlockOffset(this.minZ + vec.z);
        int maxOffX = grid.toBlockOffset(this.maxX + vec.x);
        int maxOffY = grid.toBlockOffset(this.maxY + vec.y);
        int maxOffZ = grid.toBlockOffset(this.maxZ + vec.z);
        for (int x = minOffX; x <= maxOffX; ++x) {
            for (int y = minOffY; y <= maxOffY; ++y) {
                for (int z = minOffZ; z <= maxOffZ; ++z) {
                    int minX = Math.max(this.minX + vec.x, x * grid.count);
                    int minY = Math.max(this.minY + vec.y, y * grid.count);
                    int minZ = Math.max(this.minZ + vec.z, z * grid.count);
                    int maxX = Math.min(this.maxX + vec.x, x * grid.count + grid.count);
                    int maxY = Math.min(this.maxY + vec.y, y * grid.count + grid.count);
                    int maxZ = Math.min(this.maxZ + vec.z, z * grid.count + grid.count);
                    if (maxX <= minX || maxY <= minY || maxZ <= minZ) continue;
                    toUse.m_122178_(x, y, z);
                    LittleBox box = this.extractBox(grid, minX - vec.x, minY - vec.y, minZ - vec.z, maxX - vec.x, maxY - vec.y, maxZ - vec.z, null);
                    if (box == null) continue;
                    box.add(vec);
                    box.sub(x * grid.count, y * grid.count, z * grid.count);
                    consumer.accept(toUse, box);
                }
            }
        }
    }

    public void split(LittleGrid grid, BlockPos offset, LittleVec vec, HashMapList<BlockPos, LittleBox> boxes, @Nullable LittleBoxReturnedVolume volume) {
        int minOffX = grid.toBlockOffset(this.minX + vec.x);
        int minOffY = grid.toBlockOffset(this.minY + vec.y);
        int minOffZ = grid.toBlockOffset(this.minZ + vec.z);
        int maxOffX = grid.toBlockOffset(this.maxX + vec.x);
        int maxOffY = grid.toBlockOffset(this.maxY + vec.y);
        int maxOffZ = grid.toBlockOffset(this.maxZ + vec.z);
        for (int x = minOffX; x <= maxOffX; ++x) {
            for (int y = minOffY; y <= maxOffY; ++y) {
                for (int z = minOffZ; z <= maxOffZ; ++z) {
                    int minX = Math.max(this.minX + vec.x, x * grid.count);
                    int minY = Math.max(this.minY + vec.y, y * grid.count);
                    int minZ = Math.max(this.minZ + vec.z, z * grid.count);
                    int maxX = Math.min(this.maxX + vec.x, x * grid.count + grid.count);
                    int maxY = Math.min(this.maxY + vec.y, y * grid.count + grid.count);
                    int maxZ = Math.min(this.maxZ + vec.z, z * grid.count + grid.count);
                    if (maxX <= minX || maxY <= minY || maxZ <= minZ) continue;
                    BlockPos pos = new BlockPos(x + offset.m_123341_(), y + offset.m_123342_(), z + offset.m_123343_());
                    LittleBox box = this.extractBox(grid, minX - vec.x, minY - vec.y, minZ - vec.z, maxX - vec.x, maxY - vec.y, maxZ - vec.z, volume);
                    if (box == null) continue;
                    box.add(vec);
                    box.sub(x * grid.count, y * grid.count, z * grid.count);
                    boxes.add((Object)pos, (Object)box);
                }
            }
        }
    }

    public boolean doesFillEntireBlock(LittleGrid context) {
        return this.minX == 0 && this.minY == 0 && this.minZ == 0 && this.maxX == context.count && this.maxY == context.count && this.maxZ == context.count;
    }

    public LittleBox createOutsideBlockBox(LittleGrid context, Facing facing) {
        LittleBox box = this.copy();
        switch (facing) {
            case EAST: {
                box.minX = 0;
                box.maxX -= context.count;
                break;
            }
            case WEST: {
                box.minX += context.count;
                box.maxX = context.count;
                break;
            }
            case UP: {
                box.minY = 0;
                box.maxY -= context.count;
                break;
            }
            case DOWN: {
                box.minY += context.count;
                box.maxY = context.count;
                break;
            }
            case SOUTH: {
                box.minZ = 0;
                box.maxZ -= context.count;
                break;
            }
            case NORTH: {
                box.minZ += context.count;
                box.maxZ = context.count;
            }
        }
        return box;
    }

    protected LittleBox combine(LittleBox box) {
        boolean z;
        boolean x = this.minX == box.minX && this.maxX == box.maxX;
        boolean y = this.minY == box.minY && this.maxY == box.maxY;
        boolean bl = z = this.minZ == box.minZ && this.maxZ == box.maxZ;
        if (x && y && z) {
            return this;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return new LittleBox(this.minX, this.minY, box.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxZ == box.minZ) {
                return new LittleBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, box.maxZ);
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return new LittleBox(this.minX, box.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxY == box.minY) {
                return new LittleBox(this.minX, this.minY, this.minZ, this.maxX, box.maxY, this.maxZ);
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return new LittleBox(box.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxX == box.minX) {
                return new LittleBox(this.minX, this.minY, this.minZ, box.maxX, this.maxY, this.maxZ);
            }
        }
        return null;
    }

    public LittleBox combineBoxes(LittleBox box) {
        if (box.getClass() != LittleBox.class) {
            return null;
        }
        return this.combine(box);
    }

    @Nullable
    public Facing sharedBoxFaceWithoutBounds(LittleBox box) {
        boolean z;
        boolean x = box.maxX > this.minX && box.minX < this.maxX;
        boolean y = box.maxY > this.minY && box.minY < this.maxY;
        boolean bl = z = box.maxZ > this.minZ && box.minZ < this.maxZ;
        if (this.minZ == box.maxZ) {
            if (x && y) {
                return Facing.SOUTH;
            }
            return null;
        }
        if (this.maxZ == box.minZ) {
            if (x && y) {
                return Facing.NORTH;
            }
            return null;
        }
        if (this.minY == box.maxY) {
            if (x && z) {
                return Facing.UP;
            }
            return null;
        }
        if (this.maxY == box.minY) {
            if (x && z) {
                return Facing.DOWN;
            }
            return null;
        }
        if (this.minX == box.maxX) {
            if (y && z) {
                return Facing.EAST;
            }
            return null;
        }
        if (this.maxX == box.minX) {
            if (y && z) {
                return Facing.WEST;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public Facing sharedBoxFace(LittleBox box) {
        boolean z;
        boolean x = this.minX == box.minX && this.maxX == box.maxX;
        boolean y = this.minY == box.minY && this.maxY == box.maxY;
        boolean bl = z = this.minZ == box.minZ && this.maxZ == box.maxZ;
        if (x && y && z) {
            return null;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return Facing.SOUTH;
            }
            if (this.maxZ == box.minZ) {
                return Facing.NORTH;
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return Facing.UP;
            }
            if (this.maxY == box.minY) {
                return Facing.DOWN;
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return Facing.EAST;
            }
            if (this.maxX == box.minX) {
                return Facing.WEST;
            }
        }
        return null;
    }

    public SplitRangeBoxes split(List<LittleBox> boxes) {
        RangedBitSet x = this.split(Axis.X, boxes);
        RangedBitSet y = this.split(Axis.Y, boxes);
        RangedBitSet z = this.split(Axis.Z, boxes);
        if (x != null && y != null && z != null) {
            return new SplitRangeBoxes(x, y, z);
        }
        return null;
    }

    protected RangedBitSet split(Axis axis, List<LittleBox> boxes) {
        int min = this.getMin(axis);
        int max = this.getMax(axis);
        RangedBitSet set = new RangedBitSet(min, max);
        for (LittleBox box : boxes) {
            if (!box.intersectsWith(this)) continue;
            set.add(box.getMin(axis));
            set.add(box.getMax(axis));
        }
        return set;
    }

    public List<LittleBox> cutOut(LittleGrid grid, List<LittleBox> boxes, List<LittleBox> cutout, @Nullable LittleBoxReturnedVolume volume) {
        ArrayList<LittleBox> newBoxes = new ArrayList<LittleBox>();
        if (boxes.isEmpty()) {
            newBoxes.add(this.copy());
            return newBoxes;
        }
        SplitRangeBoxes ranges = this.split(boxes);
        block0: for (SplitRangeBoxes.SplitRangeBox range : ranges) {
            LittleBox box = this.extractBox(grid, range.x.min(), range.y.min(), range.z.min(), range.x.max(), range.y.max(), range.z.max(), volume);
            if (box == null) continue;
            for (LittleBox cutBox : boxes) {
                int z;
                int y;
                int x;
                if (!cutBox.intersectsWith(box)) continue;
                if (cutBox.isSolid() || box.isMinimumSize()) {
                    cutout.add(box);
                    continue block0;
                }
                boolean[][][] filled = new boolean[box.getSize(Axis.X)][box.getSize(Axis.Y)][box.getSize(Axis.Z)];
                cutBox.fillInSpace(box, filled);
                boolean expected = filled[0][0][0];
                boolean continuous = true;
                block2: for (x = 0; x < filled.length; ++x) {
                    for (y = 0; y < filled[x].length; ++y) {
                        for (z = 0; z < filled[x][y].length; ++z) {
                            if (filled[x][y][z] == expected) continue;
                            continuous = false;
                            break block2;
                        }
                    }
                }
                if (continuous) {
                    if (expected) {
                        cutout.add(box);
                        continue block0;
                    }
                    newBoxes.add(box);
                    continue block0;
                }
                for (x = 0; x < filled.length; ++x) {
                    for (y = 0; y < filled[x].length; ++y) {
                        for (z = 0; z < filled[x][y].length; ++z) {
                            LittleBox box2 = box.extractBox(x + box.minX, y + box.minY, z + box.minZ, volume);
                            if (box2 == null) continue;
                            if (filled[x][y][z]) {
                                cutout.add(box2);
                                continue;
                            }
                            newBoxes.add(box2);
                        }
                    }
                }
                continue block0;
            }
            newBoxes.add(box);
        }
        LittleBoxCombiner.combine(newBoxes);
        LittleBoxCombiner.combine(cutout);
        return newBoxes;
    }

    protected boolean intersectsWith(LittleBox box) {
        return box.maxX > this.minX && box.minX < this.maxX && box.maxY > this.minY && box.minY < this.maxY && box.maxZ > this.minZ && box.minZ < this.maxZ;
    }

    public boolean intersectsWith(AABB bb, LittleGrid grid) {
        return bb.f_82291_ > grid.toVanillaGrid(this.minX) && bb.f_82288_ < grid.toVanillaGrid(this.maxX) && bb.f_82292_ > grid.toVanillaGrid(this.minY) && bb.f_82289_ < grid.toVanillaGrid(this.maxY) && bb.f_82293_ > grid.toVanillaGrid(this.minZ) && bb.f_82290_ < grid.toVanillaGrid(this.maxZ);
    }

    public boolean containsBox(LittleBox box) {
        return this.minX <= box.minX && this.maxX >= box.maxX && this.minY <= box.minY && this.maxY >= box.maxY && this.minZ <= box.minZ && this.maxZ >= box.maxZ;
    }

    public void fillInSpace(boolean[][][] filled) {
        if (!this.isSolid()) {
            return;
        }
        for (int x = this.minX; x < this.maxX; ++x) {
            for (int y = this.minY; y < this.maxY; ++y) {
                for (int z = this.minZ; z < this.maxZ; ++z) {
                    filled[x][y][z] = true;
                }
            }
        }
    }

    public boolean fillInSpaceInaccurate(LittleBox otherBox, Axis one, Axis two, Axis axis, boolean[][] filled) {
        boolean changed = false;
        if (this.isSolid()) {
            int minOne = Math.max(this.getMin(one), otherBox.getMin(one));
            int maxOne = Math.min(this.getMax(one), otherBox.getMax(one));
            int minTwo = Math.max(this.getMin(two), otherBox.getMin(two));
            int maxTwo = Math.min(this.getMax(two), otherBox.getMax(two));
            for (int valueOne = minOne; valueOne < maxOne; ++valueOne) {
                for (int valueTwo = minTwo; valueTwo < maxTwo; ++valueTwo) {
                    filled[valueOne - otherBox.getMin((Axis)one)][valueTwo - otherBox.getMin((Axis)two)] = true;
                    changed = true;
                }
            }
        }
        return changed;
    }

    public boolean fillInSpaceInaccurate(LittleBox otherBox, boolean[][][] filled) {
        boolean changed = false;
        if (this.isSolid()) {
            int minX = Math.max(this.minX, otherBox.minX);
            int maxX = Math.min(this.maxX, otherBox.maxX);
            int minY = Math.max(this.minY, otherBox.minY);
            int maxY = Math.min(this.maxY, otherBox.maxY);
            int minZ = Math.max(this.minZ, otherBox.minZ);
            int maxZ = Math.min(this.maxZ, otherBox.maxZ);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        filled[x - otherBox.minX][y - otherBox.minY][z - otherBox.minZ] = true;
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }

    public boolean fillInSpace(LittleBox otherBox, boolean[][][] filled) {
        boolean changed = false;
        int minX = Math.max(this.minX, otherBox.minX);
        int maxX = Math.min(this.maxX, otherBox.maxX);
        int minY = Math.max(this.minY, otherBox.minY);
        int maxY = Math.min(this.maxY, otherBox.maxY);
        int minZ = Math.max(this.minZ, otherBox.minZ);
        int maxZ = Math.min(this.maxZ, otherBox.maxZ);
        if (this.isSolid()) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        filled[x - otherBox.minX][y - otherBox.minY][z - otherBox.minZ] = true;
                        changed = true;
                    }
                }
            }
        } else {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        LittleBox box = otherBox.extractBox(x, y, z, null);
                        if (box == null || !this.intersectsWith(box)) continue;
                        filled[x - otherBox.minX][y - otherBox.minY][z - otherBox.minZ] = true;
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }

    public boolean isSolid() {
        return true;
    }

    public void add(int x, int y, int z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        this.changed();
    }

    public void add(LittleVec vec) {
        this.add(vec.x, vec.y, vec.z);
    }

    public void sub(int x, int y, int z) {
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX -= x;
        this.maxY -= y;
        this.maxZ -= z;
        this.changed();
    }

    public void sub(LittleVec vec) {
        this.sub(vec.x, vec.y, vec.z);
    }

    public LittleVec getMinVec() {
        return new LittleVec(this.minX, this.minY, this.minZ);
    }

    public LittleVec getMaxVec() {
        return new LittleVec(this.maxX, this.maxY, this.maxZ);
    }

    public LittleVec getNearstedPointTo(LittleVec vec) {
        int x = this.minX;
        if (vec.x >= this.minX || vec.x <= this.maxX) {
            x = vec.x;
        }
        if (Math.abs(this.minX - x) > Math.abs(this.maxX - x)) {
            x = this.maxX;
        }
        int y = this.minY;
        if (vec.y >= this.minY || vec.y <= this.maxY) {
            y = vec.y;
        }
        if (Math.abs(this.minY - y) > Math.abs(this.maxY - y)) {
            y = this.maxY;
        }
        int z = this.minZ;
        if (vec.z >= this.minZ || vec.z <= this.maxZ) {
            z = vec.z;
        }
        if (Math.abs(this.minZ - z) > Math.abs(this.maxZ - z)) {
            z = this.maxZ;
        }
        return new LittleVec(x, y, z);
    }

    public LittleVec getNearstedPointTo(LittleBox box) {
        int x = 0;
        x = this.minX >= box.minX && this.minX <= box.maxX ? this.minX : (box.minX >= this.minX && box.minX <= box.maxX ? box.minX : (Math.abs(this.minX - box.maxX) > Math.abs(this.maxX - box.minX) ? this.maxX : this.minX));
        int y = 0;
        y = this.minY >= box.minY && this.minY <= box.maxY ? this.minY : (box.minY >= this.minY && box.minY <= box.maxY ? box.minY : (Math.abs(this.minY - box.maxY) > Math.abs(this.maxY - box.minY) ? this.maxY : this.minY));
        int z = 0;
        z = this.minZ >= box.minZ && this.minZ <= box.maxZ ? this.minZ : (box.minZ >= this.minZ && box.minZ <= box.maxZ ? box.minZ : (Math.abs(this.minZ - box.maxZ) > Math.abs(this.maxZ - box.minZ) ? this.maxZ : this.minZ));
        return new LittleVec(x, y, z);
    }

    public double distanceTo(LittleBox box) {
        return this.distanceTo(box.getNearstedPointTo(this));
    }

    public double distanceTo(LittleVec vec) {
        return this.getNearstedPointTo(vec).distanceTo(vec);
    }

    public boolean intersectsWithFace(Facing facing, LittleVec vec) {
        Axis one = facing.one();
        Axis two = facing.two();
        return vec.get(one) >= this.getMin(one) && vec.get(one) <= this.getMax(one) && vec.get(two) >= this.getMin(two) && vec.get(two) <= this.getMax(two);
    }

    public boolean intersectsWithAxis(LittleGrid context, Axis axis, Vec3 vec) {
        switch (axis) {
            case X: {
                return this.intersectsWithYZ(context, vec);
            }
            case Y: {
                return this.intersectsWithXZ(context, vec);
            }
            case Z: {
                return this.intersectsWithXY(context, vec);
            }
        }
        return false;
    }

    public boolean intersectsWithYZ(LittleGrid context, Vec3 vec) {
        return vec.f_82480_ >= context.toVanillaGrid(this.minY) && vec.f_82480_ < context.toVanillaGrid(this.maxY) && vec.f_82481_ >= context.toVanillaGrid(this.minZ) && vec.f_82481_ < context.toVanillaGrid(this.maxZ);
    }

    public boolean intersectsWithXZ(LittleGrid context, Vec3 vec) {
        return vec.f_82479_ >= context.toVanillaGrid(this.minX) && vec.f_82479_ < context.toVanillaGrid(this.maxX) && vec.f_82481_ >= context.toVanillaGrid(this.minZ) && vec.f_82481_ < context.toVanillaGrid(this.maxZ);
    }

    public boolean intersectsWithXY(LittleGrid context, Vec3 vec) {
        return vec.f_82479_ >= context.toVanillaGrid(this.minX) && vec.f_82479_ < context.toVanillaGrid(this.maxX) && vec.f_82480_ >= context.toVanillaGrid(this.minY) && vec.f_82480_ < context.toVanillaGrid(this.maxY);
    }

    public boolean isVecInside(Vec3f vec) {
        return vec.x > (float)this.minX && vec.x < (float)this.maxX && vec.y > (float)this.minY && vec.y < (float)this.maxY && vec.z > (float)this.minZ && vec.z < (float)this.maxZ;
    }

    public LittleVec getCenter() {
        return new LittleVec((this.maxX + this.minX) / 2, (this.maxY + this.minY) / 2, (this.maxZ + this.minZ) / 2);
    }

    @Nullable
    public static Vec3 getIntermediateWithAxisValue(Vec3 first, Vec3 second, Axis axis, double value) {
        double d0 = second.f_82479_ - first.f_82479_;
        double d1 = second.f_82480_ - first.f_82480_;
        double d2 = second.f_82481_ - first.f_82481_;
        double axisValue = axis.get(d0, d1, d2);
        if (axisValue * axisValue < (double)1.0E-4f) {
            return null;
        }
        double d3 = (value - first.m_82507_(axis.toVanilla())) / axisValue;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vec3(first.f_82479_ + d0 * d3, first.f_82480_ + d1 * d3, first.f_82481_ + d2 * d3) : null;
    }

    @Nullable
    protected Vec3 collideWithPlane(LittleGrid context, Axis axis, double value, Vec3 vecA, Vec3 vecB) {
        Vec3 result = LittleBox.getIntermediateWithAxisValue(vecA, vecB, axis, value);
        return result != null && this.intersectsWithAxis(context, axis, result) ? result : null;
    }

    @Nullable
    public BlockHitResult rayTrace(LittleGrid grid, BlockPos blockPos, Vec3 pos, Vec3 look) {
        pos = pos.m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        look = look.m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        Vec3 collision = null;
        Facing collided = null;
        for (int i = 0; i < Facing.VALUES.length; ++i) {
            Facing facing = Facing.VALUES[i];
            Vec3 temp = this.collideWithPlane(grid, facing.axis, grid.toVanillaGrid(this.get(facing)), pos, look);
            if (temp == null || !LittleBox.isClosest(pos, collision, temp)) continue;
            collided = facing;
            collision = temp;
        }
        if (collision == null) {
            return null;
        }
        return new BlockHitResult(collision.m_82520_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), collided.toVanilla(), blockPos, true);
    }

    public Vec3f[] getVecArray(BoxCorner[] corners) {
        Vec3f[] result = new Vec3f[corners.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Vec3f((float)this.get(corners[i].x), (float)this.get(corners[i].y), (float)this.get(corners[i].z));
        }
        return result;
    }

    public boolean doesTouch(LittleGrid own, LittleGrid other, LittleBox box) {
        boolean z;
        LittleGrid context = LittleGrid.max(own, other);
        LittleBox thisBox = this;
        if (own != context) {
            thisBox = this.copy();
            thisBox.convertTo(own, context);
        }
        if (other != context) {
            box = box.copy();
            box.convertTo(other, context);
        }
        boolean x = box.maxX > thisBox.minX && box.minX < thisBox.maxX;
        boolean y = box.maxY > thisBox.minY && box.minY < thisBox.maxY;
        boolean bl = z = box.maxZ > thisBox.minZ && box.minZ < thisBox.maxZ;
        if (x && y && (thisBox.minZ == box.maxZ || box.minZ == thisBox.maxZ)) {
            return true;
        }
        if (x && z && (thisBox.minY == box.maxY || box.minY == thisBox.maxY)) {
            return true;
        }
        return y && z && (thisBox.minX == box.maxX || box.minX == thisBox.maxX);
    }

    public boolean doesTouch(LittleBox box) {
        boolean z;
        boolean x = box.maxX > this.minX && box.minX < this.maxX;
        boolean y = box.maxY > this.minY && box.minY < this.maxY;
        boolean bl = z = box.maxZ > this.minZ && box.minZ < this.maxZ;
        if (x && y && (this.minZ == box.maxZ || box.minZ == this.maxZ)) {
            return true;
        }
        if (x && z && (this.minY == box.maxY || box.minY == this.maxY)) {
            return true;
        }
        return y && z && (this.minX == box.maxX || box.minX == this.maxX);
    }

    public void rotate(Rotation rotation, LittleVec doubledCenter) {
        long tempMinX = this.minX * 2 - doubledCenter.x;
        long tempMinY = this.minY * 2 - doubledCenter.y;
        long tempMinZ = this.minZ * 2 - doubledCenter.z;
        long tempMaxX = this.maxX * 2 - doubledCenter.x;
        long tempMaxY = this.maxY * 2 - doubledCenter.y;
        long tempMaxZ = this.maxZ * 2 - doubledCenter.z;
        this.resort((int)((rotation.getMatrix().getX(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.x) / 2L), (int)((rotation.getMatrix().getY(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.y) / 2L), (int)((rotation.getMatrix().getZ(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.z) / 2L), (int)((rotation.getMatrix().getX(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.x) / 2L), (int)((rotation.getMatrix().getY(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.y) / 2L), (int)((rotation.getMatrix().getZ(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.z) / 2L));
        this.changed();
    }

    public void mirror(Axis axis, LittleVec doubledCenter) {
        long tempMin = this.getMin(axis) * 2 - doubledCenter.get(axis);
        long tempMax = this.getMax(axis) * 2 - doubledCenter.get(axis);
        int min = (int)(((long)doubledCenter.get(axis) - tempMin) / 2L);
        int max = (int)(((long)doubledCenter.get(axis) - tempMax) / 2L);
        this.setMin(axis, Math.min(min, max));
        this.setMax(axis, Math.max(min, max));
        this.changed();
    }

    public int hashCode() {
        return this.minX + this.minY + this.minZ + this.maxX + this.maxY + this.maxZ;
    }

    public boolean equals(Object object) {
        if (object instanceof LittleBox) {
            return object.getClass() == this.getClass() && this.minX == ((LittleBox)object).minX && this.minY == ((LittleBox)object).minY && this.minZ == ((LittleBox)object).minZ && this.maxX == ((LittleBox)object).maxX && this.maxY == ((LittleBox)object).maxY && this.maxZ == ((LittleBox)object).maxZ;
        }
        return super.equals(object);
    }

    public String toString() {
        return "[" + this.minX + "," + this.minY + "," + this.minZ + " -> " + this.maxX + "," + this.maxY + "," + this.maxZ + "]";
    }

    public LittleBox extractBox(int x, int y, int z, @Nullable LittleBoxReturnedVolume volume) {
        return new LittleBox(x, y, z, x + 1, y + 1, z + 1);
    }

    public LittleBox extractBox(LittleGrid grid, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, @Nullable LittleBoxReturnedVolume volume) {
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public LittleBox copy() {
        return new LittleBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public boolean isFaceAtEdge(LittleGrid context, Facing facing) {
        if (facing.positive) {
            return this.getMax(facing.axis) == context.count;
        }
        return this.getMin(facing.axis) == 0;
    }

    public void growAway(int size, Facing facing) {
        int invSize = size / 2;
        this.minX -= invSize;
        this.minY -= invSize;
        this.minZ -= invSize;
        this.maxX += (size -= invSize);
        this.maxY += size;
        this.maxZ += size;
        int by = facing.positive ? invSize : -size;
        this.setMin(facing.axis, this.getMin(facing.axis) + by);
        this.setMax(facing.axis, this.getMax(facing.axis) + by);
    }

    public void growCentered(int size) {
        int invSize = size / 2;
        this.minX -= invSize;
        this.minY -= invSize;
        this.minZ -= invSize;
        this.maxX += (size -= invSize);
        this.maxY += size;
        this.maxZ += size;
    }

    public void growToInclude(LittleBox box) {
        this.minX = Math.min(this.minX, box.minX);
        this.minY = Math.min(this.minY, box.minY);
        this.minZ = Math.min(this.minZ, box.minZ);
        this.maxX = Math.max(this.maxX, box.maxX);
        this.maxY = Math.max(this.maxY, box.maxY);
        this.maxZ = Math.max(this.maxZ, box.maxZ);
    }

    public LittleBox grow(Facing facing) {
        LittleBox result = this.copy();
        if (facing.positive) {
            result.setMax(facing.axis, this.getMax(facing.axis) + 1);
        } else {
            result.setMin(facing.axis, this.getMin(facing.axis) - 1);
        }
        return result;
    }

    public LittleBox shrink(Facing facing, boolean toLimit) {
        if (this.getSize(facing.axis) > 1) {
            LittleBox result = this.copy();
            if (facing.positive) {
                result.setMax(facing.axis, toLimit ? this.getMin(facing.axis) + 1 : this.getMax(facing.axis) - 1);
            } else {
                result.setMin(facing.axis, toLimit ? this.getMax(facing.axis) - 1 : this.getMin(facing.axis) + 1);
            }
            return result;
        }
        return null;
    }

    public void resort() {
        this.set(Math.min(this.minX, this.maxX), Math.min(this.minY, this.maxY), Math.min(this.minZ, this.maxZ), Math.max(this.minX, this.maxX), Math.max(this.minY, this.maxY), Math.max(this.minZ, this.maxZ));
    }

    public void resort(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ), Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
    }

    public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    @OnlyIn(value=Dist.CLIENT)
    public LittleRenderBox getRenderingBox(LittleGrid grid) {
        return new LittleRenderBox(grid, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public LittleRenderBox getRenderingBox(LittleGrid grid, LittleVec vec) {
        LittleBox box = this.copy();
        box.add(vec);
        return new LittleRenderBox(grid, box);
    }

    @OnlyIn(value=Dist.CLIENT)
    public LittleRenderBox getRenderingBox(LittleGrid grid, BlockState state) {
        return new LittleRenderBox(grid, this, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public LittleRenderBox getRenderingBox(LittleGrid grid, BlockState state, LittleVec vec) {
        LittleBox box = this.copy();
        box.add(vec);
        return new LittleRenderBox(grid, box, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public LittleRenderBox getRenderingBox(LittleGrid grid, LittleElement element) {
        return new LittleRenderBox(grid, this, element);
    }

    @Nullable
    public LittleFace generateFace(LittleGrid context, Facing facing) {
        Axis one = facing.one();
        Axis two = facing.two();
        return new LittleFace(this, null, null, context, facing, this.getMin(one), this.getMin(two), this.getMax(one), this.getMax(two), this.get(facing));
    }

    @Nullable
    public boolean set(LittleServerFace face, LittleGrid grid, Facing facing) {
        face.set(this.getMin(face.one), this.getMin(face.two), this.getMax(face.one), this.getMax(face.two), this.get(facing));
        return true;
    }

    public boolean intersectsWith(ILittleFace face) {
        return (face.facing().positive ? this.getMin(face.facing().axis) : this.getMax(face.facing().axis)) == face.origin() && face.maxOne() > this.getMin(face.one()) && face.minOne() < this.getMax(face.one()) && face.maxTwo() > this.getMin(face.two()) && face.minTwo() < this.getMax(face.two());
    }

    public LittleBox intersection(LittleBox other) {
        int minX = Math.max(this.minX, other.minX);
        int minY = Math.max(this.minY, other.minY);
        int minZ = Math.max(this.minZ, other.minZ);
        int maxX = Math.min(this.maxX, other.maxX);
        int maxY = Math.min(this.maxY, other.maxY);
        int maxZ = Math.min(this.maxZ, other.maxZ);
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean isFaceSolid(Facing facing) {
        return true;
    }

    public boolean canFaceBeCombined(LittleBox other) {
        return true;
    }

    public void fill(ILittleFace face) {
        if (this.intersectsWith(face)) {
            int minOne = Math.max(this.getMin(face.one()), face.minOne());
            int maxOne = Math.min(this.getMax(face.one()), face.maxOne());
            int minTwo = Math.max(this.getMin(face.two()), face.minTwo());
            int maxTwo = Math.min(this.getMax(face.two()), face.maxTwo());
            if (this.isFaceSolid(face.facing().opposite())) {
                for (int one = minOne; one < maxOne; ++one) {
                    for (int two = minTwo; two < maxTwo; ++two) {
                        face.set(one - face.minOne(), two - face.minTwo(), true);
                    }
                }
            } else if (face.supportsCutting()) {
                this.fillAdvanced(face);
            } else {
                face.setPartiallyFilled();
            }
        }
    }

    protected void fillAdvanced(ILittleFace face) {
    }

    public void resetFaceState() {
        this.faceCache = 0;
    }

    public boolean hasFaceState() {
        return this.faceCache != 0;
    }

    public boolean hasOrCreateFaceState(IParentCollection parent, LittleTile tile, LittleServerFace face) {
        if (this.hasFaceState()) {
            return true;
        }
        for (int i = 0; i < Facing.VALUES.length; ++i) {
            this.setFaceState(Facing.VALUES[i], face.set(parent, tile, this, Facing.VALUES[i]).calculate());
        }
        return false;
    }

    public void setFaceState(Facing facing, LittleFaceState state) {
        this.faceCache &= ~(15 << facing.ordinal() * 4);
        this.faceCache |= state.ordinal() << facing.ordinal() * 4;
    }

    public LittleFaceState getFaceState(Facing facing) {
        return LittleFaceState.values()[this.faceCache >> facing.ordinal() * 4 & 0xF];
    }

    public static void sortListByPosition(List<LittleBox> boxes, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, LittleBoxSorting sorting) {
        int i;
        LittleVec min = new LittleVec(minX, minY, minZ);
        LittleVec max = new LittleVec(maxX, maxY, maxZ);
        int col = max.get(sorting.first) - min.get(sorting.first);
        int row = col * (max.get(sorting.second) - min.get(sorting.second));
        for (i = 0; i < boxes.size(); ++i) {
            LittleBox box = boxes.get(i);
            box.faceCache = box.getMin(sorting.first) - min.get(sorting.first) + (box.getMin(sorting.second) - min.get(sorting.second)) * col + (box.getMin(sorting.third) - min.get(sorting.third)) * row;
        }
        boxes.sort(SORT_BY_FACHE_CACHE);
        for (i = 0; i < boxes.size(); ++i) {
            boxes.get(i).resetFaceState();
        }
    }

    public static LittleBox createExtended(int[] array) {
        LittleBox box = LittleBox.create(1, array);
        box.faceCache = array[0];
        return box;
    }

    public static LittleBox create(int[] array) {
        return LittleBox.create(0, array);
    }

    private static LittleBox create(int offset, int[] array) {
        if (array.length == offset + 6) {
            return new LittleBox(array[offset], array[offset + 1], array[offset + 2], array[offset + 3], array[offset + 4], array[offset + 5]);
        }
        if (array.length < offset + 6) {
            throw new InvalidParameterException("No valid box given " + Arrays.toString(array));
        }
        int identifier = array[offset + 6];
        if (identifier < 0) {
            return new LittleTransformableBox(offset, array);
        }
        if (array.length == offset + 7 || array.length == offset + 11) {
            return new LittleBox(array[offset], array[offset + 1], array[offset + 2], array[offset + 3], array[offset + 4], array[offset + 5]);
        }
        throw new InvalidParameterException("No valid box given " + Arrays.toString(array));
    }

    public static boolean isClosest(Vec3 from, @Nullable Vec3 optional, Vec3 toCheck) {
        return optional == null || from.m_82557_(toCheck) < from.m_82557_(optional);
    }

    public static boolean isClosest(Vec3d from, @Nullable Vec3d optional, Vec3d toCheck) {
        return optional == null || from.distanceSqr(toCheck) < from.distanceSqr(optional);
    }

    public static boolean intersectsWith(LittleBox box, LittleBox box2) {
        if (box.getClass() == LittleBox.class) {
            return box2.intersectsWith(box);
        }
        return box.intersectsWith(box2);
    }
}

