/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level.tick;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.level.handler.LevelHandlers;
import team.creative.littletiles.common.level.tick.LittleTickTicket;
import team.creative.littletiles.common.level.tick.LittleTicker;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;
import team.creative.littletiles.common.structure.signal.schedule.ISignalSchedulable;
import team.creative.littletiles.common.structure.signal.schedule.SignalScheduleTicket;

public class LittleTickers
extends LevelHandlers<LittleTicker> {
    private static final List<SignalScheduleTicket> UNSORTED_TICKETS = new ArrayList<SignalScheduleTicket>();
    private LittleTicker client;

    public LittleTickers() {
        MinecraftForge.EVENT_BUS.addListener(this::levelTick);
        MinecraftForge.EVENT_BUS.addListener(this::serverTick);
    }

    @Override
    protected Function<Level, LittleTicker> createFactory() {
        return level -> {
            LittleTicker ticker = new LittleTicker((Level)level);
            if (level.f_46443_) {
                this.client = ticker;
            }
            return ticker;
        };
    }

    @Override
    protected void unloadHandler(LittleTicker handler) {
        super.unloadHandler(handler);
        if (handler == this.client) {
            this.client = null;
        }
    }

    public void levelTick(TickEvent.LevelTickEvent event) {
        LittleTicker ticker;
        if (event.phase == TickEvent.Phase.END && (ticker = (LittleTicker)this.getWithoutCreate(event.level)) != null) {
            ticker.tick();
        }
    }

    public void serverTick(TickEvent.ServerTickEvent event) {
        if (!UNSORTED_TICKETS.isEmpty()) {
            Iterator<SignalScheduleTicket> iterator = UNSORTED_TICKETS.iterator();
            while (iterator.hasNext()) {
                SignalScheduleTicket ticket = iterator.next();
                Level level = ticket.getLevel();
                if (level == null) continue;
                ((LittleTicker)LittleTiles.TICKERS.get(level)).schedule(ticket.getDelay(), ticket);
                iterator.remove();
            }
        }
    }

    public synchronized List<SignalScheduleTicket> findTickets(ISignalComponent component, SignalOutputHandler condition) {
        Level level = component.getStructureLevel();
        if (level != null && !level.f_46443_) {
            ArrayList<SignalScheduleTicket> tickets = new ArrayList<SignalScheduleTicket>();
            for (LittleTickTicket ticket : (LittleTicker)LittleTiles.TICKERS.get(level)) {
                SignalScheduleTicket s;
                Runnable runnable = ticket.get();
                if (!(runnable instanceof SignalScheduleTicket) || !(s = (SignalScheduleTicket)runnable).is(condition)) continue;
                tickets.add(s);
            }
            return tickets;
        }
        return Collections.EMPTY_LIST;
    }

    public void markSignalChanged(Level level, ISignalSchedulable schedulable) {
        if (level == null) {
            return;
        }
        ((LittleTicker)this.get(level)).markSignalChanged(schedulable);
    }

    public synchronized SignalScheduleTicket schedule(SignalOutputHandler handler, SignalState result, int delay) {
        SignalScheduleTicket ticket = new SignalScheduleTicket(handler, result, delay);
        Level level = handler.component.getStructureLevel();
        if (level == null) {
            UNSORTED_TICKETS.add(ticket);
        } else {
            ((LittleTicker)LittleTiles.TICKERS.get(level)).schedule(delay, ticket);
        }
        return ticket;
    }

    public synchronized void markUpdate(LittleStructure structure, boolean notifyNeighbours) {
        ((LittleTicker)this.get(structure.getStructureLevel())).markUpdate(structure, notifyNeighbours);
    }

    public synchronized void queueNexTick(LittleStructure structure) {
        ((LittleTicker)this.get(structure.getStructureLevel())).queueNextTick(structure);
    }
}

