/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item.glove;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.simple.GuiColorPicker;
import team.creative.creativecore.common.gui.controls.simple.GuiShowItem;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.mc.TooltipUtils;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.LittleGuiUtils;
import team.creative.littletiles.common.gui.controls.GuiGridConfig;
import team.creative.littletiles.common.gui.tool.GuiGlove;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.item.glove.ElementGloveMode;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;

public class PixelMode
extends ElementGloveMode {
    public static LittleBox getBox(ItemStack stack) {
        if (stack.m_41784_().m_128441_("box")) {
            return LittleBox.create(stack.m_41783_().m_128465_("box"));
        }
        LittleBox box = new LittleBox(0, 0, 0, 1, 1, 1);
        PixelMode.setBox(stack.m_41784_(), box);
        return box;
    }

    public static void setBox(CompoundTag nbt, LittleBox box) {
        nbt.m_128385_("box", box.getArray());
    }

    @Override
    public void loadGui(GuiGlove gui) {
        LittleGrid grid;
        Player player = gui.getPlayer();
        ItemStack stack = gui.tool.get();
        ILittleTool tool = (ILittleTool)stack.m_41720_();
        LittleElement element = PixelMode.getElement(stack);
        LittleBox box = PixelMode.getBox(stack);
        LittleGrid oldContext = LittleGrid.get(stack.m_41783_());
        if (oldContext != (grid = tool.getPositionGrid(gui.getPlayer(), stack))) {
            box.convertTo(oldContext, grid);
        }
        if (box.minX == box.maxX) {
            ++box.maxX;
        }
        if (box.minY == box.maxY) {
            ++box.maxY;
        }
        if (box.minZ == box.maxZ) {
            ++box.maxZ;
        }
        LittleVec size = box.getSize();
        gui.registerEventChanged(x -> this.updateLabel(gui));
        GuiParent parent = new GuiParent();
        gui.add(parent.setExpandableX());
        GuiParent left = new GuiParent();
        parent.add((GuiControl)left);
        left.add(new GuiShowItem("item", ItemStack.f_41583_).setDim(32, 32));
        GuiParent right = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        parent.add(right.setAlign(Align.RIGHT).setExpandableX());
        right.add((GuiControl)new GuiSteppedSlider("sizeX", size.x, 1, grid.count));
        right.add((GuiControl)new GuiSteppedSlider("sizeY", size.y, 1, grid.count));
        right.add((GuiControl)new GuiSteppedSlider("sizeZ", size.z, 1, grid.count));
        right.add((GuiControl)new GuiGridConfig("grid", gui.getPlayer(), grid, x -> {
            GuiSteppedSlider sizeX = (GuiSteppedSlider)gui.get("sizeX");
            sizeX.setMaxValue((double)x.count);
            sizeX.setValue(Mth.m_14008_((double)sizeX.getValue(), (double)sizeX.getMinValue(), (double)sizeX.getMaxValue()));
            GuiSteppedSlider sizeY = (GuiSteppedSlider)gui.get("sizeY");
            sizeY.setMaxValue((double)x.count);
            sizeY.setValue(Mth.m_14008_((double)sizeY.getValue(), (double)sizeY.getMinValue(), (double)sizeY.getMaxValue()));
            GuiSteppedSlider sizeZ = (GuiSteppedSlider)gui.get("sizeZ");
            sizeZ.setMaxValue((double)x.count);
            sizeZ.setValue(Mth.m_14008_((double)sizeZ.getValue(), (double)sizeZ.getMinValue(), (double)sizeZ.getMaxValue()));
        }));
        gui.add((GuiControl)new GuiColorPicker("picker", new Color(element.color), LittleTiles.CONFIG.isTransparencyEnabled(player), LittleTiles.CONFIG.getMinimumTransparency(player)));
        GuiStackSelector selector = new GuiStackSelector("preview", player, LittleGuiUtils.getCollector(player), true);
        selector.setSelectedForce(element.getBlock().getStack());
        gui.add(selector.setExpandableX());
        this.updateLabel(gui);
    }

    protected LittleElement getElement(GuiGlove gui) {
        Item item;
        GuiStackSelector selector = (GuiStackSelector)gui.get("preview");
        GuiColorPicker picker = (GuiColorPicker)gui.get("picker");
        ItemStack selected = selector.getSelected();
        if (!selected.m_41619_() && (item = selected.m_41720_()) instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            return new LittleElement(item2.m_40614_().m_49966_(), picker.color.toInt());
        }
        return PixelMode.getElement(gui.tool.get());
    }

    protected LittleBox getBox(GuiGlove gui) {
        int sizeX = ((GuiSteppedSlider)gui.get("sizeX", GuiSteppedSlider.class)).getIntValue();
        int sizeY = ((GuiSteppedSlider)gui.get("sizeY", GuiSteppedSlider.class)).getIntValue();
        int sizeZ = ((GuiSteppedSlider)gui.get("sizeZ", GuiSteppedSlider.class)).getIntValue();
        return new LittleBox(0, 0, 0, sizeX, sizeY, sizeZ);
    }

    protected LittleGrid getGrid(GuiGlove gui) {
        return ((GuiGridConfig)gui.get("grid", GuiGridConfig.class)).get();
    }

    protected void updateLabel(GuiGlove gui) {
        ((GuiShowItem)gui.get((String)"item", GuiShowItem.class)).stack = ItemMultiTiles.of(this.getElement(gui), this.getGrid(gui), this.getBox(gui));
    }

    @Override
    public void saveGui(GuiGlove gui, CompoundTag nbt) {
        PixelMode.setElement(nbt, this.getElement(gui));
        PixelMode.setBox(nbt, this.getBox(gui));
        this.getGrid(gui).set(nbt);
    }

    @Override
    public void addExtraInformation(CompoundTag nbt, List<Component> tooltip) {
        super.addExtraInformation(nbt, tooltip);
        tooltip.add((Component)Component.m_237113_((String)TooltipUtils.printColor((int)PixelMode.getElement((CompoundTag)nbt).color)));
    }

    @Override
    public LittleGroup getTiles(ItemStack stack) {
        LittleGroup group = new LittleGroup();
        group.addTile(LittleGrid.get(stack.m_41783_()), new LittleTile(PixelMode.getElement(stack), PixelMode.getBox(stack)));
        return group;
    }

    @Override
    public void setTiles(LittleGroup previews, ItemStack stack) {
    }
}

