/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item.glove;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.item.glove.GloveMode;
import team.creative.littletiles.common.packet.action.BlockPacket;
import team.creative.littletiles.common.packet.action.VanillaBlockPacket;

public abstract class ElementGloveMode
extends GloveMode {
    public static LittleElement getElement(ItemStack stack) {
        if (stack.m_41784_().m_128441_("element")) {
            return new LittleElement(stack.m_41698_("element"));
        }
        LittleElement element = new LittleElement(Blocks.f_50069_.m_49966_(), -1);
        ElementGloveMode.setElement(stack, element);
        return element;
    }

    public static LittleElement getElement(CompoundTag nbt) {
        if (nbt.m_128441_("element")) {
            return new LittleElement(nbt.m_128469_("element"));
        }
        LittleElement element = new LittleElement(Blocks.f_50069_.m_49966_(), -1);
        nbt.m_128365_("element", (Tag)element.save(new CompoundTag()));
        return element;
    }

    public static void setElement(ItemStack stack, LittleElement element) {
        element.save(stack.m_41698_("element"));
    }

    public static void setElement(CompoundTag nbt, LittleElement element) {
        nbt.m_128365_("element", (Tag)element.save(new CompoundTag()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean wheelClickBlock(Level level, Player player, ItemStack stack, BlockHitResult result) {
        BlockState state = level.m_8055_(result.m_82425_());
        if (LittleAction.isBlockValid(state)) {
            LittleTiles.NETWORK.sendToServer((CreativePacket)new VanillaBlockPacket(result.m_82425_(), VanillaBlockPacket.VanillaBlockAction.GLOVE));
            return true;
        }
        if (state.m_60734_() instanceof BlockTile) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("secondMode", LittleActionHandlerClient.isUsingSecondMode());
            LittleTiles.NETWORK.sendToServer((CreativePacket)new BlockPacket(level, result.m_82425_(), player, BlockPacket.BlockPacketAction.GLOVE, nbt));
            return true;
        }
        return false;
    }

    public LittleGrid getGrid(ItemStack stack) {
        return LittleGrid.get(stack.m_41783_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasPreviewElement(ItemStack stack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleElement getPreviewElement(ItemStack stack) {
        return ElementGloveMode.getElement(stack);
    }

    @Override
    public void vanillaBlockAction(Level level, ItemStack stack, BlockPos pos, BlockState state) {
        if (LittleAction.isBlockValid(state)) {
            ElementGloveMode.setElement(stack, new LittleElement(state, -1));
        }
    }

    @Override
    public void littleBlockAction(Level level, BETiles be, LittleTileContext context, ItemStack stack, BlockPos pos, CompoundTag nbt) {
        if (LittleAction.isBlockValid(context.tile.getState())) {
            ElementGloveMode.setElement(stack, new LittleElement(context.tile.getState(), -1));
        }
    }
}

