/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item.glove;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.GuiGlove;
import team.creative.littletiles.common.item.glove.GloveMode;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.packet.action.BlockPacket;
import team.creative.littletiles.common.packet.action.VanillaBlockPacket;

public class BlueprintGloveMode
extends GloveMode {
    public static final String CONTENT = "c";

    public static LittleGroup getPreviews(ItemStack stack) {
        if (stack.m_41784_().m_128441_(CONTENT)) {
            return LittleGroup.load(stack.m_41698_(CONTENT));
        }
        LittleGroup group = new LittleGroup();
        group.add(LittleGrid.MIN, new LittleElement(Blocks.f_50069_.m_49966_(), -1), new LittleBox(0, 0, 0, 1, 1, 1));
        stack.m_41784_().m_128365_(CONTENT, (Tag)LittleGroup.save(group));
        return group;
    }

    public static BlockPos getOrigin(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        return new BlockPos(nbt.m_128451_("ox"), nbt.m_128451_("oy"), nbt.m_128451_("oz"));
    }

    public static void setOrigin(ItemStack stack, BlockPos pos) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_("ox", pos.m_123341_());
        nbt.m_128405_("oy", pos.m_123342_());
        nbt.m_128405_("oz", pos.m_123343_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean wheelClickBlock(Level level, Player player, ItemStack stack, BlockHitResult result) {
        BlockState state = level.m_8055_(result.m_82425_());
        if (LittleAction.isBlockValid(state)) {
            LittleTiles.NETWORK.sendToServer((CreativePacket)new VanillaBlockPacket(result.m_82425_(), VanillaBlockPacket.VanillaBlockAction.GLOVE));
            return true;
        }
        if (state.m_60734_() instanceof BlockTile) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("secondMode", LittleActionHandlerClient.isUsingSecondMode());
            LittleTiles.NETWORK.sendToServer((CreativePacket)new BlockPacket(level, result.m_82425_(), player, BlockPacket.BlockPacketAction.GLOVE, nbt));
            return true;
        }
        return false;
    }

    @Override
    public void littleBlockAction(Level level, BETiles be, LittleTileContext context, ItemStack stack, BlockPos pos, CompoundTag nbt) {
        LittleGroup previews = new LittleGroup();
        if (nbt.m_128471_("secondMode")) {
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                previews.add(((IParentCollection)pair.key).getGrid(), (LittleElement)pair.value, (Iterable)pair.value);
            }
        } else {
            previews.add(context.parent.getGrid(), (LittleElement)context.tile, context.box);
        }
        this.setTiles(previews, stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasPreviewElement(ItemStack stack) {
        return false;
    }

    @Override
    public LittleElement getPreviewElement(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadGui(GuiGlove gui) {
    }

    @Override
    public void saveGui(GuiGlove gui, CompoundTag nbt) {
        nbt.m_128365_(CONTENT, (Tag)LittleGroup.save(this.getTiles(gui.tool.get())));
    }

    @Override
    public LittleGroup getTiles(ItemStack stack) {
        return BlueprintGloveMode.getPreviews(stack);
    }

    @Override
    public void setTiles(LittleGroup previews, ItemStack stack) {
        stack.m_41784_().m_128365_(CONTENT, (Tag)LittleGroup.save(previews));
    }

    @Override
    public void vanillaBlockAction(Level level, ItemStack stack, BlockPos pos, BlockState state) {
        if (LittleAction.isBlockValid(state)) {
            LittleGroup group = new LittleGroup();
            group.add(LittleGrid.MIN, new LittleElement(state, -1), new LittleBox(0, 0, 0, 1, 1, 1));
            this.setTiles(group, stack);
        }
    }

    @Override
    public String tooltipTranslateKey(ItemStack stack, String defaultKey) {
        return "littletiles.tiles.tooltip";
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{LittleTilesClient.configure.m_90863_(), LittleTilesClient.arrowKeysTooltip(), LittleTilesClient.mirror.m_90863_()};
    }
}

