/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.creativecore.common.util.mc.NBTUtils;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.gui.tool.GuiModeSelector;
import team.creative.littletiles.common.item.tooltip.IItemTooltip;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.placement.setting.PlacementPlayerSetting;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadePreview;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadeRegistry;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

public class ItemPremadeStructure
extends Item
implements ILittlePlacer,
IItemTooltip {
    private static HashMap<String, LittleGroup> cachedPreviews = new HashMap();

    public static ItemStack of(String structure) {
        ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.PREMADE.get());
        CompoundTag nbt = new CompoundTag();
        CompoundTag structNbt = new CompoundTag();
        structNbt.m_128359_("id", structure);
        nbt.m_128365_("s", (Tag)structNbt);
        stack.m_41751_(nbt);
        return stack;
    }

    public static String getPremadeId(ItemStack stack) {
        return stack.m_41698_("s").m_128461_("id");
    }

    public static LittleStructurePremade.LittlePremadeType get(ItemStack stack) {
        return LittlePremadeRegistry.get(stack.m_41698_("s").m_128461_("id"));
    }

    public static LittlePremadePreview getPremade(ItemStack stack) {
        return LittlePremadeRegistry.getPreview(stack.m_41698_("s").m_128461_("id"));
    }

    public ItemPremadeStructure() {
        super(new Item.Properties());
    }

    public String m_5671_(ItemStack stack) {
        return "structure." + ItemPremadeStructure.getPremadeId(stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        if (LanguageUtils.can((String)("structure.description." + ItemPremadeStructure.getPremadeId(stack)))) {
            list.addAll(new TextBuilder().translate("structure.description." + ItemPremadeStructure.getPremadeId(stack)).build());
        }
    }

    @Override
    public GuiConfigure getConfigure(Player player, ContainerSlotView view) {
        return new GuiModeSelector(view, PlacementPlayerSetting.grid(player), PlacementPlayerSetting.placementMode(player)){

            @Override
            public CompoundTag saveConfiguration(CompoundTag nbt, LittleGrid grid, PlacementMode mode) {
                LittleTilesClient.setPlace(grid, mode);
                return null;
            }
        };
    }

    @Override
    public boolean hasTiles(ItemStack stack) {
        return LittlePremadeRegistry.getPreview(ItemPremadeStructure.getPremadeId(stack)) != null;
    }

    @Override
    public boolean shouldRenderInHand(ItemStack stack) {
        return this.hasTiles(stack);
    }

    public void removeUnnecessaryData(ItemStack stack) {
        if (stack.m_41782_()) {
            stack.m_41783_().m_128473_("tiles");
            stack.m_41783_().m_128473_("size");
            stack.m_41783_().m_128473_("min");
        }
    }

    public static void clearCache() {
        cachedPreviews.clear();
    }

    private LittleGroup getPreviews(String id) {
        if (cachedPreviews.containsKey(id)) {
            return cachedPreviews.get(id).copy();
        }
        LittleGroup previews = LittlePremadeRegistry.getLittleGroup(id);
        if (previews != null) {
            return previews.copy();
        }
        return null;
    }

    @Override
    public LittleGroup getTiles(ItemStack stack) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        LittleGroup previews = this.getPreviews(id);
        if (previews != null && previews.getStructureTag() != null && stack.m_41784_().m_128441_("s")) {
            NBTUtils.mergeNotOverwrite((CompoundTag)previews.getStructureTag(), (CompoundTag)stack.m_41783_().m_128469_("s"));
        }
        return previews;
    }

    @Override
    public LittleGroup getLow(ItemStack stack) {
        return this.getTiles(stack);
    }

    @Override
    public void rotate(Player player, ItemStack stack, Rotation rotation, boolean client) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        LittleGroup previews = this.getPreviews(id);
        if (previews.isEmpty()) {
            return;
        }
        previews.rotate(rotation, previews.getGrid().rotationCenter);
        this.saveTiles(stack, previews);
    }

    @Override
    public void mirror(Player player, ItemStack stack, Axis axis, boolean client) {
        String id = ItemPremadeStructure.getPremadeId(stack);
        LittleGroup previews = this.getPreviews(id);
        if (previews.isEmpty()) {
            return;
        }
        previews.mirror(axis, previews.getGrid().rotationCenter);
        this.saveTiles(stack, previews);
    }

    @Override
    public PlacementPreview getPlacement(Player player, Level level, ItemStack stack, PlacementPosition position, boolean allowLowResolution) {
        return PlacementPreview.relative(level, stack, position, allowLowResolution);
    }

    @Override
    public void saveTiles(ItemStack stack, LittleGroup group) {
        cachedPreviews.put(ItemPremadeStructure.getPremadeId(stack), group);
    }

    @Override
    public boolean sendTransformationUpdate() {
        return false;
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return true;
    }

    @Override
    public boolean shouldCache() {
        return false;
    }

    @Override
    public boolean canSnapToGrid(ItemStack stack) {
        LittleStructurePremade.LittlePremadeType type = LittlePremadeRegistry.get(ItemPremadeStructure.getPremadeId(stack));
        if (type instanceof LittleStructurePremade.LittlePremadeType) {
            LittleStructurePremade.LittlePremadeType premade = type;
            return premade.canSnapToGrid();
        }
        return false;
    }

    @Override
    public boolean snapToGridByDefault(ItemStack stack) {
        LittleStructurePremade.LittlePremadeType type = LittlePremadeRegistry.get(ItemPremadeStructure.getPremadeId(stack));
        if (type instanceof LittleStructurePremade.LittlePremadeType) {
            LittleStructurePremade.LittlePremadeType premade = type;
            return premade.snapToGrid;
        }
        return false;
    }

    @Override
    public String tooltipTranslateKey(ItemStack stack, String defaultKey) {
        return "littletiles.tiles.tooltip";
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{LittleTilesClient.configure.m_90863_(), LittleTilesClient.arrowKeysTooltip(), LittleTilesClient.mirror.m_90863_()};
    }
}

