/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.mc.TooltipUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.common.tool.ILittleEditor;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionColorBoxes;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.gui.tool.GuiPaintBrush;
import team.creative.littletiles.common.item.ItemLittleHammer;
import team.creative.littletiles.common.item.tooltip.IItemTooltip;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.packet.action.BlockPacket;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mark.IMarkMode;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;
import team.creative.littletiles.common.placement.shape.ShapeSelection;

public class ItemLittlePaintBrush
extends Item
implements ILittleEditor,
IItemTooltip {
    public static ShapeSelection selection;

    public static int getColor(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if (!stack.m_41783_().m_128441_("color")) {
            ItemLittlePaintBrush.setColor(stack, -1);
        }
        return stack.m_41783_().m_128451_("color");
    }

    public static void setColor(ItemStack stack, int color) {
        if (stack == null) {
            return;
        }
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128405_("color", color);
    }

    public ItemLittlePaintBrush() {
        super(new Item.Properties().m_41487_(1));
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return 0.0f;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        LittleShape shape = ItemLittlePaintBrush.getShape(stack);
        tooltip.add((Component)Component.m_237115_((String)"gui.shape").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)shape.getTranslatableName())));
        shape.addExtraInformation(stack.m_41783_(), tooltip);
        tooltip.add((Component)Component.m_237113_((String)TooltipUtils.printColor((int)ItemLittlePaintBrush.getColor(stack))));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
        }
        if (!level.f_46443_) {
            GuiCreator.ITEM_OPENER.open(player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    @Override
    public GuiConfigure getConfigure(Player player, ContainerSlotView view) {
        return new GuiPaintBrush(view);
    }

    public static LittleShape getShape(ItemStack stack) {
        return (LittleShape)ShapeRegistry.REGISTRY.get(stack.m_41784_().m_128461_("shape"));
    }

    @Override
    public void onDeselect(Level level, ItemStack stack, Player player) {
        selection = null;
    }

    @Override
    public boolean hasCustomBoxes(Level level, ItemStack stack, Player player, BlockState state, PlacementPosition pos, BlockHitResult result) {
        return LittleAction.isBlockValid(state) || level.m_7702_(result.m_82425_()) instanceof BETiles;
    }

    @Override
    public LittleBoxes getBoxes(Level level, ItemStack stack, Player player, PlacementPosition pos, BlockHitResult result) {
        if (selection == null) {
            selection = new ShapeSelection(stack, true);
        }
        selection.setLast(player, stack, pos, result);
        return selection.getBoxes(true, this.getPositionGrid(player, stack));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClickBlock(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        if (LittleActionHandlerClient.isUsingSecondMode()) {
            selection = null;
            LittleTilesClient.PREVIEW_RENDERER.removeMarked();
        } else if (selection != null && selection.addAndCheckIfPlace(player, position, result)) {
            if (ItemLittleHammer.isFiltered()) {
                LittleTilesClient.ACTION_HANDLER.execute(new LittleActionColorBoxes.LittleActionColorBoxesFiltered(level, selection.getBoxes(false, this.getPositionGrid(player, stack)), ItemLittlePaintBrush.getColor(stack), false, ItemLittleHammer.getFilter()));
            } else {
                LittleTilesClient.ACTION_HANDLER.execute(new LittleActionColorBoxes(level, selection.getBoxes(false, this.getPositionGrid(player, stack)), ItemLittlePaintBrush.getColor(stack), false));
            }
            selection = null;
            LittleTilesClient.PREVIEW_RENDERER.removeMarked();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onRightClick(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        if (selection != null) {
            selection.click(player);
        }
        return true;
    }

    @Override
    public void rotate(Player player, ItemStack stack, Rotation rotation, boolean client) {
        if (!client) {
            return;
        }
        if (selection != null) {
            selection.rotate(player, stack, rotation);
        } else {
            new ShapeSelection(stack, false).rotate(player, stack, rotation);
        }
    }

    @Override
    public void mirror(Player player, ItemStack stack, Axis axis, boolean client) {
        if (!client) {
            return;
        }
        if (selection != null) {
            selection.mirror(player, stack, axis);
        } else {
            new ShapeSelection(stack, false).mirror(player, stack, axis);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IMarkMode onMark(Player player, ItemStack stack, PlacementPosition position, BlockHitResult result, PlacementPreview previews) {
        if (selection != null) {
            selection.toggleMark();
        }
        return selection;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onMouseWheelClickBlock(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(result.m_82425_());
        if (blockEntity instanceof BETiles) {
            LittleTiles.NETWORK.sendToServer((CreativePacket)new BlockPacket(level, result.m_82425_(), player, BlockPacket.BlockPacketAction.PAINT_BRUSH, new CompoundTag()));
        }
        return true;
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{ItemLittlePaintBrush.getShape(stack).getTranslatable(), Minecraft.m_91087_().f_91066_.f_92097_.m_90863_(), LittleTilesClient.mark.m_90863_(), LittleTilesClient.configure.m_90863_()};
    }
}

