/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.mc.TooltipUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.gui.tool.GuiChisel;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.item.tooltip.IItemTooltip;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.packet.action.BlockPacket;
import team.creative.littletiles.common.packet.action.VanillaBlockPacket;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mark.IMarkMode;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;
import team.creative.littletiles.common.placement.shape.ShapeSelection;

public class ItemLittleChisel
extends Item
implements ILittlePlacer,
IItemTooltip {
    public static ShapeSelection selection;

    public ItemLittleChisel() {
        super(new Item.Properties().m_41487_(1));
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return 0.0f;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        LittleShape shape = ItemLittleChisel.getShape(stack);
        tooltip.add((Component)Component.m_237115_((String)"gui.shape").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)shape.getTranslatableName())));
        shape.addExtraInformation(stack.m_41783_(), tooltip);
        tooltip.add((Component)Component.m_237113_((String)TooltipUtils.printColor((int)ItemLittleChisel.getElement((ItemStack)stack).color)));
    }

    public static LittleShape getShape(ItemStack stack) {
        return ItemLittleChisel.getShape(stack.m_41784_());
    }

    public static LittleShape getShape(CompoundTag nbt) {
        return (LittleShape)ShapeRegistry.REGISTRY.get(nbt.m_128461_("shape"));
    }

    public static void setShape(ItemStack stack, LittleShape shape) {
        ItemLittleChisel.setShape(stack.m_41784_(), shape);
    }

    public static void setShape(CompoundTag nbt, LittleShape shape) {
        nbt.m_128359_("shape", shape.getKey());
    }

    public static LittleElement getElement(ItemStack stack) {
        if (stack.m_41784_().m_128441_("element")) {
            return new LittleElement(stack.m_41698_("element"));
        }
        LittleElement element = new LittleElement(Blocks.f_50069_.m_49966_(), -1);
        ItemLittleChisel.setElement(stack, element);
        return element;
    }

    public static LittleElement getElement(CompoundTag nbt) {
        if (nbt.m_128441_("element")) {
            return new LittleElement(nbt.m_128469_("element"));
        }
        return new LittleElement(Blocks.f_50069_.m_49966_(), -1);
    }

    public static void setElement(ItemStack stack, LittleElement element) {
        element.save(stack.m_41698_("element"));
    }

    public static void setElement(CompoundTag nbt, LittleElement element) {
        CompoundTag tag = new CompoundTag();
        element.save(tag);
        nbt.m_128365_("element", (Tag)tag);
    }

    @Override
    public boolean hasTiles(ItemStack stack) {
        return true;
    }

    @Override
    public LittleGroup getTiles(ItemStack stack) {
        return null;
    }

    @Override
    public boolean shouldRenderInHand(ItemStack stack) {
        return true;
    }

    @Override
    public LittleGroup getLow(ItemStack stack) {
        return null;
    }

    @Override
    public PlacementPreview getPlacement(Player player, Level level, ItemStack stack, PlacementPosition position, boolean allowLowResolution) {
        ShapeSelection sel = selection;
        if (sel != null) {
            LittleBoxes boxes = sel.getBoxes(allowLowResolution, this.getPositionGrid(player, stack));
            LittleGroupAbsolute previews = new LittleGroupAbsolute(boxes.pos);
            previews.add(boxes.grid, ItemLittleChisel.getElement(stack), boxes);
            return PlacementPreview.absolute(level, stack, previews, sel.getFirst().pos.facing);
        }
        return null;
    }

    @Override
    public void saveTiles(ItemStack stack, LittleGroup group) {
    }

    protected ShapeSelection createSelection(ItemStack stack) {
        return new ShapeSelection(stack, this.getPlacementMode((ItemStack)stack).placeInside);
    }

    @Override
    public void rotate(Player player, ItemStack stack, Rotation rotation, boolean client) {
        if (!client) {
            return;
        }
        if (selection != null) {
            selection.rotate(player, stack, rotation);
        } else {
            this.createSelection(stack).rotate(player, stack, rotation);
        }
    }

    @Override
    public void mirror(Player player, ItemStack stack, Axis axis, boolean client) {
        if (!client) {
            return;
        }
        if (selection != null) {
            selection.mirror(player, stack, axis);
        } else {
            this.createSelection(stack).mirror(player, stack, axis);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getPreviewAlphaFactor() {
        return 0.4f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tick(Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        if (selection == null) {
            selection = this.createSelection(stack);
        }
        selection.setLast(player, stack, position, result);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldCache() {
        return false;
    }

    @Override
    public void configured(ItemStack stack, CompoundTag nbt) {
        ILittlePlacer.super.configured(stack, nbt);
        if (selection != null && selection.countPositions() <= 1) {
            selection = null;
        }
    }

    @Override
    public void onDeselect(Level level, ItemStack stack, Player player) {
        selection = null;
    }

    @Override
    public void onClickAir(Player player, ItemStack stack) {
        if (selection != null) {
            selection.click(player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClickBlock(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        if (selection != null) {
            selection.click(player);
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onRightClick(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        if (LittleActionHandlerClient.isUsingSecondMode()) {
            selection = null;
            LittleTilesClient.PREVIEW_RENDERER.removeMarked();
        } else if (selection != null) {
            return selection.addAndCheckIfPlace(player, position, result);
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onMouseWheelClickBlock(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        BlockState state = level.m_8055_(result.m_82425_());
        if (LittleAction.isBlockValid(state)) {
            LittleTiles.NETWORK.sendToServer((CreativePacket)new VanillaBlockPacket(result.m_82425_(), VanillaBlockPacket.VanillaBlockAction.CHISEL));
            return true;
        }
        if (state.m_60734_() instanceof BlockTile) {
            LittleTiles.NETWORK.sendToServer((CreativePacket)new BlockPacket(level, result.m_82425_(), player, BlockPacket.BlockPacketAction.CHISEL, new CompoundTag()));
            return true;
        }
        return false;
    }

    @Override
    public GuiConfigure getConfigure(Player player, ContainerSlotView view) {
        return new GuiChisel(view);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IMarkMode onMark(Player player, ItemStack stack, PlacementPosition position, BlockHitResult result, PlacementPreview previews) {
        if (selection != null) {
            selection.toggleMark();
        }
        return selection;
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return false;
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{ItemLittleChisel.getShape(stack).getTranslatable(), Minecraft.m_91087_().f_91066_.f_92097_.m_90863_(), LittleTilesClient.mark.m_90863_(), LittleTilesClient.arrowKeysTooltip(), LittleTilesClient.configure.m_90863_()};
    }
}

