/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipe;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeSelection;
import team.creative.littletiles.common.item.tooltip.IItemTooltip;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.packet.action.BlockPacket;
import team.creative.littletiles.common.packet.item.SelectionModePacket;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.selection.SelectionMode;

public class ItemLittleBlueprint
extends Item
implements ILittlePlacer,
IItemTooltip {
    public static final String CONTENT_KEY = "c";
    public static final String SELECTION_KEY = "s";

    public ItemLittleBlueprint() {
        super(new Item.Properties());
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41784_().m_128441_(CONTENT_KEY) && stack.m_41698_(CONTENT_KEY).m_128441_(SELECTION_KEY) && stack.m_41698_(CONTENT_KEY).m_128469_(SELECTION_KEY).m_128441_("n")) {
            return Component.m_237113_((String)stack.m_41698_(CONTENT_KEY).m_128469_(SELECTION_KEY).m_128461_("n"));
        }
        return super.m_7626_(stack);
    }

    @Override
    public boolean hasTiles(ItemStack stack) {
        return stack.m_41784_().m_128441_(CONTENT_KEY) && !stack.m_41737_(CONTENT_KEY).m_128456_();
    }

    @Override
    public LittleGroup getTiles(ItemStack stack) {
        return LittleGroup.load(stack.m_41698_(CONTENT_KEY));
    }

    @Override
    public LittleGroup getLow(ItemStack stack) {
        return LittleGroup.loadLow(stack.m_41698_(CONTENT_KEY));
    }

    @Override
    public boolean shouldRenderInHand(ItemStack stack) {
        return LittleGroup.shouldRenderInHand(stack.m_41698_(CONTENT_KEY));
    }

    @Override
    public PlacementPreview getPlacement(Player player, Level level, ItemStack stack, PlacementPosition position, boolean allowLowResolution) {
        return PlacementPreview.relative(level, stack, position, allowLowResolution);
    }

    @Override
    public void saveTiles(ItemStack stack, LittleGroup group) {
        stack.m_41784_().m_128365_(CONTENT_KEY, (Tag)LittleGroup.save(group));
    }

    @Override
    public GuiConfigure getConfigure(Player player, ContainerSlotView view) {
        if (!((ItemLittleBlueprint)view.get().m_41720_()).hasTiles(view.get())) {
            return new GuiRecipeSelection(view);
        }
        return new GuiRecipe(view);
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onMouseWheelClickBlock(Level world, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        BlockState state = world.m_8055_(result.m_82425_());
        if (state.m_60734_() instanceof BlockTile) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("secondMode", LittleActionHandlerClient.isUsingSecondMode());
            LittleTiles.NETWORK.sendToServer((CreativePacket)new BlockPacket(world, result.m_82425_(), player, BlockPacket.BlockPacketAction.BLUEPRINT, nbt));
            return true;
        }
        return true;
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onRightClick(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        if (this.hasTiles(stack)) {
            return true;
        }
        ItemLittleBlueprint.getSelectionMode(stack).rightClick(player, stack.m_41698_(SELECTION_KEY), result.m_82425_());
        LittleTiles.NETWORK.sendToServer((CreativePacket)new SelectionModePacket(result.m_82425_(), true));
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClickBlock(Level level, Player player, ItemStack stack, PlacementPosition position, BlockHitResult result) {
        if (this.hasTiles(stack)) {
            return true;
        }
        ItemLittleBlueprint.getSelectionMode(stack).leftClick(player, stack.m_41698_(SELECTION_KEY), result.m_82425_());
        LittleTiles.NETWORK.sendToServer((CreativePacket)new SelectionModePacket(result.m_82425_(), false));
        return true;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        list.add(LittleGroup.printTooltip(stack.m_41698_(CONTENT_KEY)));
    }

    @Override
    public LittleVecGrid getCachedSize(ItemStack stack) {
        return LittleGroup.getSize(stack.m_41698_(CONTENT_KEY));
    }

    @Override
    public LittleVecGrid getCachedMin(ItemStack stack) {
        return LittleGroup.getMin(stack.m_41698_(CONTENT_KEY));
    }

    @Override
    public String tooltipTranslateKey(ItemStack stack, String defaultKey) {
        if (this.hasTiles(stack)) {
            return "littletiles.tiles.tooltip";
        }
        return "littletiles.blueprint.selection.tooltip";
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        if (this.hasTiles(stack)) {
            return new Object[]{LittleTilesClient.configure.m_90863_(), LittleTilesClient.arrowKeysTooltip(), LittleTilesClient.mirror.m_90863_()};
        }
        return new Object[]{Minecraft.m_91087_().f_91066_.f_92096_.m_90863_(), Minecraft.m_91087_().f_91066_.f_92095_.m_90863_(), Minecraft.m_91087_().f_91066_.f_92097_.m_90863_(), LittleTilesClient.configure.m_90863_()};
    }

    public static SelectionMode getSelectionMode(ItemStack stack) {
        return (SelectionMode)SelectionMode.REGISTRY.get(stack.m_41698_(SELECTION_KEY).m_128461_("selmode"));
    }

    public static void setSelectionMode(ItemStack stack, SelectionMode mode) {
        stack.m_41698_(SELECTION_KEY).m_128359_("selmode", mode.getName());
    }
}

