/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientInventory;
import team.creative.littletiles.common.ingredient.BlockIngredient;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.IngredientUtils;
import team.creative.littletiles.common.ingredient.LittleIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;

public class ItemBlockIngredient
extends Item
implements ILittleIngredientInventory {
    public ItemBlockIngredient() {
        super(new Item.Properties().m_41487_(1));
    }

    public static ItemStack of(BlockIngredientEntry entry) {
        ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.BLOCK_INGREDIENT.get());
        stack.m_41751_(new CompoundTag());
        ItemBlockIngredient.saveIngredient(stack, entry);
        return stack;
    }

    public static BlockIngredientEntry loadIngredient(ItemStack stack) {
        if (stack.m_41782_()) {
            return IngredientUtils.loadBlockIngredient(stack.m_41783_());
        }
        return null;
    }

    public static void saveIngredient(ItemStack stack, BlockIngredientEntry entry) {
        entry.save(stack.m_41783_());
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        return false;
    }

    public boolean m_142305_(ItemStack me, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess otherSlot) {
        BlockIngredientEntry otherEntry;
        BlockIngredientEntry meEntry;
        if (other.m_41720_() instanceof ItemBlockIngredient && (meEntry = ItemBlockIngredient.loadIngredient(me)).equals(otherEntry = ItemBlockIngredient.loadIngredient(other))) {
            double amount = Math.min(64.0 - meEntry.value, otherEntry.value);
            otherEntry.value -= amount;
            meEntry.value += amount;
            if (meEntry.value == 1.0) {
                slot.m_5852_(meEntry.getBlockStack());
            } else {
                ItemBlockIngredient.saveIngredient(me, meEntry);
            }
            if (otherEntry.value <= 0.0) {
                otherSlot.m_142104_(ItemStack.f_41583_);
            } else {
                ItemBlockIngredient.saveIngredient(other, otherEntry);
            }
            return true;
        }
        return false;
    }

    public Component m_7626_(ItemStack stack) {
        BlockIngredientEntry entry = ItemBlockIngredient.loadIngredient(stack);
        if (entry != null) {
            return entry.getBlockStack().m_41786_();
        }
        return super.m_7626_(stack);
    }

    public boolean m_41468_() {
        return true;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        BlockIngredientEntry entry = ItemBlockIngredient.loadIngredient(stack);
        if (entry != null) {
            tooltip.add(BlockIngredient.printVolume(entry.value, false));
        }
    }

    @Override
    public LittleIngredients getInventory(ItemStack stack) {
        BlockIngredientEntry entry = ItemBlockIngredient.loadIngredient(stack);
        if (entry != null) {
            BlockIngredient ingredient = new BlockIngredient();
            ingredient.add(entry);
            return new LittleIngredients(new LittleIngredient[]{ingredient.setLimits(1, 64.0)}){

                @Override
                protected boolean canAddNewIngredients() {
                    return false;
                }

                @Override
                protected boolean removeEmptyIngredients() {
                    return false;
                }
            };
        }
        return null;
    }

    @Override
    public void setInventory(ItemStack stack, LittleIngredients ingredients, LittleInventory inventory) {
        BlockIngredient blocks = ingredients.get(BlockIngredient.class);
        if (blocks != null && !blocks.isEmpty()) {
            for (BlockIngredientEntry entry : blocks) {
                if (entry.isEmpty() && !(entry.block instanceof AirBlock)) continue;
                if (inventory != null && entry.value >= 1.0) {
                    ItemStack overflow = entry.getBlockStack();
                    overflow.m_41764_((int)entry.value);
                    entry.value -= (double)overflow.m_41613_();
                    inventory.addStack(overflow);
                }
                if (!(entry.value > 0.0)) continue;
                ItemBlockIngredient.saveIngredient(stack, entry);
                return;
            }
        }
        stack.m_41751_(null);
        stack.m_41764_(0);
    }

    @Override
    public boolean shouldBeMerged() {
        return true;
    }
}

