/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.ingredient;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import team.creative.creativecore.common.util.inventory.InventoryUtils;
import team.creative.creativecore.common.util.mc.LevelUtils;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientInventory;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientSupplier;
import team.creative.littletiles.common.ingredient.LittleIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.NotEnoughIngredientsException;
import team.creative.littletiles.common.ingredient.StackIngredient;

public class LittleInventory
implements Iterable<ItemStack> {
    protected Player player;
    protected IItemHandler inventory;
    private boolean simulate;
    protected List<LittleInventory> subInventories;
    protected List<LittleIngredients> inventories;
    protected List<Integer> inventoriesId;
    protected List<ItemStack> cachedInventory;
    public boolean allowDrop = true;

    public LittleInventory(Player player) {
        this(player, (IItemHandler)player.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null));
    }

    public LittleInventory(IItemHandler inventory) {
        this(null, inventory);
    }

    public LittleInventory(Player player, IItemHandler inventory) {
        this.player = player;
        this.inventory = inventory;
        this.inventories = new ArrayList<LittleIngredients>();
        this.inventoriesId = new ArrayList<Integer>();
        this.subInventories = new ArrayList<LittleInventory>();
        this.reloadInventories(false);
    }

    public void reloadInventories(boolean onlyIngredientInventories) {
        this.inventories.clear();
        this.inventoriesId.clear();
        if (!onlyIngredientInventories) {
            this.subInventories.clear();
        }
        for (int i = 0; i < this.size(); ++i) {
            LazyOptional optional;
            ItemStack stack = this.get(i);
            if (stack.m_41720_() instanceof ILittleIngredientInventory) {
                LittleIngredients ingredient = ((ILittleIngredientInventory)stack.m_41720_()).getInventory(stack);
                if (ingredient == null) continue;
                this.inventories.add(ingredient);
                this.inventoriesId.add(i);
                continue;
            }
            if (onlyIngredientInventories || !(optional = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent()) continue;
            this.subInventories.add(new LittleInventory(this.player, (IItemHandler)optional.orElse(null)));
        }
    }

    public boolean isSimulation() {
        return this.simulate;
    }

    public void startSimulation() {
        this.cachedInventory = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.cachedInventory.add(this.inventory.getStackInSlot(i).m_41777_());
        }
        this.simulate = true;
        this.reloadInventories(false);
    }

    public void stopSimulation() {
        this.simulate = false;
        this.cachedInventory = null;
        this.reloadInventories(false);
    }

    public boolean addStack(ItemStack stack) {
        return this.addStack(stack, false);
    }

    public boolean addStack(ItemStack stack, boolean onlyMerge) {
        int i;
        for (i = 0; i < this.size(); ++i) {
            int amount;
            ItemStack inventoryStack = this.get(i);
            if (inventoryStack.m_41720_() instanceof ILittleIngredientInventory || !InventoryUtils.isItemStackEqual((ItemStack)inventoryStack, (ItemStack)stack) || (amount = Math.min(stack.m_41741_() - inventoryStack.m_41613_(), stack.m_41613_())) <= 0) continue;
            inventoryStack.m_41764_(inventoryStack.m_41613_() + amount);
            stack.m_41774_(amount);
            if (!stack.m_41619_()) continue;
            return true;
        }
        for (i = 0; i < this.subInventories.size(); ++i) {
            if (!this.subInventories.get(i).addStack(stack, true)) continue;
            return true;
        }
        if (onlyMerge) {
            return false;
        }
        for (i = 0; i < this.size(); ++i) {
            if (!this.get(i).m_41619_()) continue;
            if (this.simulate) {
                this.cachedInventory.set(i, stack);
            } else {
                this.inventory.insertItem(i, stack, false);
            }
            return true;
        }
        for (i = 0; i < this.subInventories.size(); ++i) {
            if (!this.subInventories.get(i).addStack(stack, false)) continue;
            return true;
        }
        return false;
    }

    public void addOrDropStacks(List<ItemStack> stacks) throws NotEnoughIngredientsException.NotEnoughSpaceException {
        ArrayList<ItemStack> toDrop = null;
        for (ItemStack stack : stacks) {
            if (this.addStack(stack)) continue;
            if (toDrop == null) {
                toDrop = new ArrayList<ItemStack>();
            }
            toDrop.add(stack);
        }
        if (toDrop != null) {
            if (this.player == null || !this.allowDrop) {
                throw new NotEnoughIngredientsException.NotEnoughSpaceException(new StackIngredient(toDrop));
            }
            if (!this.simulate && !this.player.m_9236_().f_46443_) {
                LevelUtils.dropItem((Player)this.player, toDrop);
            }
        }
    }

    public ItemStack get(int index) {
        return this.simulate ? this.cachedInventory.get(index) : this.inventory.getStackInSlot(index);
    }

    public int size() {
        if (this.inventory instanceof Inventory) {
            return 36;
        }
        return this.simulate ? this.cachedInventory.size() : this.inventory.getSlots();
    }

    @Override
    public Iterator<ItemStack> iterator() {
        if (this.simulate) {
            return this.cachedInventory.iterator();
        }
        return new Iterator<ItemStack>(){
            public int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < LittleInventory.this.inventory.getSlots();
            }

            @Override
            public ItemStack next() {
                return LittleInventory.this.inventory.getStackInSlot(this.index++);
            }
        };
    }

    protected LittleIngredient take(LittleIngredient ingredient) {
        for (LittleIngredients ingredients : this.inventories) {
            ingredient = ingredients.sub(ingredient);
            if (ingredient != null) continue;
            return null;
        }
        for (int i = 0; i < this.subInventories.size(); ++i) {
            ingredient = this.subInventories.get(i).take(ingredient);
            if (ingredient != null) continue;
            return null;
        }
        return ingredient;
    }

    protected boolean takeFromStacks(LittleIngredients ingredients, LittleIngredients overflow) {
        ItemStack stack;
        int i;
        for (i = 0; i < this.size(); ++i) {
            int amount;
            if (ingredients.isEmpty()) {
                return true;
            }
            stack = this.get(i);
            if (stack.m_41619_()) continue;
            LittleIngredients stackIngredients = LittleIngredient.extractWithoutCount(stack, false);
            if (stackIngredients != null && (amount = ingredients.getMinimumCount(stackIngredients, stack.m_41613_())) > -1) {
                stackIngredients.scale(amount);
                overflow.add(ingredients.sub(stackIngredients));
                stack.m_41774_(amount);
                continue;
            }
            LittleIngredient[] content = ingredients.getContent();
            for (int j = 0; j < content.length; ++j) {
                if (content[j] == null || !LittleIngredient.handleExtra(content[j], stack, overflow)) continue;
                content[j] = null;
            }
            if (!ingredients.isEmpty()) continue;
            return true;
        }
        for (i = 0; i < this.subInventories.size(); ++i) {
            if (!this.subInventories.get(i).takeFromStacks(ingredients, overflow)) continue;
            return true;
        }
        for (i = 0; i < this.size(); ++i) {
            if (ingredients.isEmpty()) {
                return true;
            }
            stack = this.get(i);
            if (!(stack.m_41720_() instanceof ILittleIngredientSupplier)) continue;
            ((ILittleIngredientSupplier)stack.m_41720_()).requestIngredients(stack, ingredients, overflow, this);
        }
        return ingredients.isEmpty();
    }

    public void take(LittleIngredients ingredients) throws NotEnoughIngredientsException {
        block6: {
            for (LittleIngredient ingredient : ingredients.getContent()) {
                if (ingredient == null) continue;
                ingredients.set(ingredient.getClass(), this.take(ingredient));
            }
            if (!ingredients.isEmpty()) {
                LittleIngredients overflow = new LittleIngredients();
                this.takeFromStacks(ingredients, overflow);
                if (!ingredients.isEmpty()) {
                    throw new NotEnoughIngredientsException(ingredients);
                }
                if (!overflow.isEmpty()) {
                    try {
                        this.give(overflow);
                    }
                    catch (NotEnoughIngredientsException.NotEnoughSpaceException e) {
                        List<ItemStack> stacks = overflow.handleOverflow();
                        if (stacks == null || stacks.isEmpty()) break block6;
                        this.addOrDropStacks(stacks);
                    }
                }
            }
        }
        this.saveInventories();
    }

    protected LittleIngredient tryGive(LittleIngredient ingredient) {
        for (LittleIngredients ingredients : this.inventories) {
            ingredient = ingredients.add(ingredient);
            if (ingredient != null) continue;
            return null;
        }
        for (int i = 0; i < this.subInventories.size(); ++i) {
            ingredient = this.subInventories.get(i).tryGive(ingredient);
            if (ingredient != null) continue;
            return null;
        }
        return ingredient;
    }

    protected LittleIngredient give(LittleIngredient ingredient) throws NotEnoughIngredientsException.NotEnoughSpaceException {
        if ((ingredient = this.tryGive(ingredient)) == null) {
            return null;
        }
        try {
            List<ItemStack> stacks = LittleIngredient.handleOverflow(ingredient);
            if (stacks != null) {
                this.addOrDropStacks(stacks);
            }
            return null;
        }
        catch (NotEnoughIngredientsException.NotEnoughSpaceException e) {
            return ingredient;
        }
    }

    public void give(LittleIngredients ingredients) throws NotEnoughIngredientsException.NotEnoughSpaceException {
        LittleIngredients remainings = new LittleIngredients();
        for (LittleIngredient ingredient : ingredients.getContent()) {
            if (ingredient == null) continue;
            remainings.set(ingredient.getClass(), this.give(ingredient));
        }
        if (!remainings.isEmpty()) {
            throw new NotEnoughIngredientsException.NotEnoughSpaceException(remainings);
        }
        this.saveInventories();
    }

    public void saveInventories() {
        for (int i = 0; i < this.inventoriesId.size(); ++i) {
            int index = this.inventoriesId.get(i);
            ItemStack stack = this.get(index);
            ((ILittleIngredientInventory)stack.m_41720_()).setInventory(stack, this.inventories.get(i), this);
        }
        this.reloadInventories(true);
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }
}

