/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.ingredient;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.littletiles.api.common.block.LittleBlock;

public class BlockIngredientEntry {
    public final LittleBlock block;
    public double value;

    BlockIngredientEntry(LittleBlock block, double value) {
        this.block = block;
        this.value = value;
    }

    public ItemStack getBlockStack() {
        return this.block.getStack();
    }

    public int hashCode() {
        return this.block.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof BlockIngredientEntry && ((BlockIngredientEntry)object).block == this.block;
    }

    public BlockState getState() {
        return this.block.getState();
    }

    public boolean is(ItemStack stack) {
        return this.block.is(stack);
    }

    public BlockIngredientEntry copy() {
        return new BlockIngredientEntry(this.block, this.value);
    }

    public BlockIngredientEntry copy(double value) {
        return new BlockIngredientEntry(this.block, value);
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128359_("block", this.block.blockName());
        nbt.m_128347_("volume", this.value);
        return nbt;
    }

    public boolean isEmpty() {
        return this.value <= 0.0;
    }

    public void scale(int count) {
        this.value *= (double)count;
    }

    public void scaleAdvanced(double scale) {
        this.value = (int)Math.ceil(this.value * scale);
    }

    public String toString() {
        return "[" + this.block.blockName() + "," + this.value + "]";
    }
}

