/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe.test;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.tree.GuiTreeItem;
import team.creative.creativecore.common.util.type.itr.SingleIterator;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignal;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignalEvents;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipe;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestError;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestModule;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestResults;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.component.ISignalStructureComponent;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalTarget;

public class RecipeSignalEquationTest
extends RecipeTestModule {
    @Override
    public void startTest(GuiRecipe recipe, RecipeTestResults results) {
    }

    @Override
    public void test(GuiTreeItemStructure item, RecipeTestResults results) {
        SignalTargetNotFound error;
        if (item.structure == null) {
            return;
        }
        GuiDialogSignalEvents.GuiSignalEvent[] internal = item.internalOutputs();
        for (int i = 0; i < internal.length; ++i) {
            GuiDialogSignalEvents.GuiSignalEvent event = internal[i];
            if (event == null || (error = this.checkCondition(item, false, i, event.condition, null, event)) == null) continue;
            results.reportError(error);
        }
        for (GuiDialogSignalEvents.GuiSignalEvent event : item.externalOutputs()) {
            error = this.checkCondition(item, true, event.component.index(), event.condition, null, event);
            if (error == null) continue;
            results.reportError(error);
        }
    }

    private SignalTargetNotFound checkCondition(GuiTreeItemStructure item, boolean external, int index, SignalInputCondition condition, SignalTargetNotFound error, GuiDialogSignalEvents.GuiSignalEvent event) {
        if (condition == null) {
            return error;
        }
        SignalTarget target = condition.target();
        if (target != null && !this.searchForTarget(item, target)) {
            if (error == null) {
                error = new SignalTargetNotFound(item, event);
            }
            error.addMissing(target);
        }
        Iterator<SignalInputCondition> iterator = condition.nested();
        while (iterator.hasNext()) {
            error = this.checkCondition(item, external, index, iterator.next(), error, event);
        }
        return error;
    }

    private boolean searchForTarget(GuiTreeItemStructure item, SignalTarget target) {
        if (target instanceof SignalTarget.SignalTargetParent) {
            SignalTarget.SignalTargetParent targetParent = (SignalTarget.SignalTargetParent)target;
            GuiTreeItem parent = item.getParentItem();
            if (parent instanceof GuiTreeItemStructure) {
                GuiTreeItemStructure p = (GuiTreeItemStructure)parent;
                return this.searchForTarget(p, targetParent.subTarget);
            }
            return false;
        }
        if (target instanceof SignalTarget.SignalTargetNested) {
            SignalTarget.SignalTargetNested nested = (SignalTarget.SignalTargetNested)target;
            if (nested.child < 0 || nested.child >= item.itemsCount()) {
                return false;
            }
            return this.searchForTarget((GuiTreeItemStructure)item.getItem(nested.child), nested.subTarget);
        }
        if (target instanceof SignalTarget.SignalTargetChild) {
            SignalTarget.SignalTargetChild c = (SignalTarget.SignalTargetChild)target;
            if (item.structure == null) {
                return false;
            }
            if (c.external) {
                if (c.child < 0 || c.child >= item.itemsCount()) {
                    return false;
                }
                GuiTreeItemStructure child = (GuiTreeItemStructure)item.getItem(c.child);
                LittleStructure littleStructure = child.structure;
                if (littleStructure instanceof ISignalStructureComponent) {
                    ISignalStructureComponent s = (ISignalStructureComponent)((Object)littleStructure);
                    return c.input ? s.getComponentType() == SignalComponentType.INPUT : s.getComponentType() == SignalComponentType.OUTPUT;
                }
                return false;
            }
            return target.getTarget(item.structure) != null;
        }
        return true;
    }

    @Override
    public void endTest(GuiRecipe recipe, RecipeTestResults results) {
    }

    public static class SignalTargetNotFound
    extends RecipeTestError {
        private final GuiDialogSignalEvents.GuiSignalEvent event;
        private final HashSet<String> targets = new HashSet();
        private final GuiTreeItemStructure structure;

        public SignalTargetNotFound(GuiTreeItemStructure structure, GuiDialogSignalEvents.GuiSignalEvent event) {
            this.structure = structure;
            this.event = event;
        }

        public void addMissing(SignalTarget target) {
            this.targets.add(target.writeBase());
        }

        @Override
        public Component header() {
            return GuiControl.translatable((String)"gui.recipe.test.signal.title", (Object[])new Object[]{this.event.component.name()});
        }

        @Override
        public Component description() {
            return GuiControl.translatable((String)"gui.recipe.test.signal.desc", (Object[])new Object[]{String.join((CharSequence)",", this.targets)});
        }

        @Override
        public Component tooltip(GuiTreeItemStructure structure) {
            return this.header();
        }

        @Override
        public Iterator<GuiTreeItemStructure> iterator() {
            return new SingleIterator((Object)this.structure);
        }

        @Override
        public void create(GuiRecipe recipe, GuiParent parent, Runnable refresh) {
            List<GuiSignalComponent> inputs = this.structure.signalSearch.search(true, true, true);
            parent.add((GuiControl)new GuiButton("edit", x -> ((GuiDialogSignal)LittleTilesGuiRegistry.SIGNAL_DIALOG.open(parent.getIntegratedParent(), new CompoundTag())).init(inputs, this.event)).setTranslate("gui.edit"));
            parent.add((GuiControl)new GuiButton("reset", x -> {
                this.event.reset();
                refresh.run();
            }).setTranslate("gui.clear"));
        }
    }
}

