/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.util.mc.TooltipUtils;
import team.creative.creativecore.common.util.type.itr.ArrayIterator;
import team.creative.creativecore.common.util.type.itr.SingleIterator;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipe;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeMove;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestError;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestModule;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestResults;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.box.collection.LittleBoxesNoOverlap;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;

public class RecipeOverlapTest
extends RecipeTestModule {
    private HashMap<BlockPos, RecipeOverlapTestBlock> blocks;
    private HashMap<GuiTreeItemStructure, LittleBoxesNoOverlap> overlapped;

    public static void removeOverlap(GuiTreeItemStructure item, LittleBoxesNoOverlap boxes) {
        boxes.sameGrid((IGridBased)item.group, () -> {
            Iterable cutter = boxes.all();
            ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
            Iterator<LittleTile> iterator = item.group.iterator();
            while (iterator.hasNext()) {
                LittleTile tile = iterator.next();
                tile.cutOut(item.group.getGrid(), (List<LittleBox>)cutter, cutout, null);
                if (!tile.isEmpty()) continue;
                iterator.remove();
            }
        });
        if (item.group.isEmpty()) {
            item.recipe.removeItem(item);
        } else {
            item.refreshAnimation();
        }
    }

    @Override
    public void startTest(GuiRecipe recipe, RecipeTestResults results) {
        this.blocks = new HashMap();
    }

    private RecipeOverlapTestBlock getOrCreate(BlockPos pos) {
        RecipeOverlapTestBlock block = this.blocks.get(pos);
        if (block == null) {
            block = new RecipeOverlapTestBlock();
            this.blocks.put(pos.m_7949_(), block);
        }
        return block;
    }

    private void addOverlap(GuiTreeItemStructure other, BlockPos pos, LittleGrid grid, LittleBox box) {
        LittleBoxesNoOverlap boxes;
        if (this.overlapped == null) {
            this.overlapped = new HashMap();
        }
        if ((boxes = this.overlapped.get(other)) == null) {
            boxes = new LittleBoxesNoOverlap(BlockPos.f_121853_, grid);
            this.overlapped.put(other, boxes);
        }
        boxes.addBox(grid, pos, box.copy());
    }

    @Override
    public void test(GuiTreeItemStructure item, RecipeTestResults results) {
        this.overlapped = null;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        LittleGrid grid = item.group.getGrid();
        LittleGroup group = item.group;
        LittleVecGrid offset = item.getOffset();
        if (offset != null) {
            group = group.copy();
            group.move(offset);
        }
        Iterator<Object> iterator = group.iterator();
        while (iterator.hasNext()) {
            LittleTile littleTile = iterator.next();
            for (LittleBox box : littleTile) {
                box.splitIterator(grid, pos, LittleVec.ZERO, (x, y) -> this.getOrCreate((BlockPos)x).add(item, (BlockPos)x, grid, (LittleBox)y));
            }
        }
        if (this.overlapped != null) {
            for (Map.Entry entry : this.overlapped.entrySet()) {
                if (entry.getKey() == item) {
                    results.reportError(new SelfOverlapError(item, (LittleBoxesNoOverlap)entry.getValue()));
                } else {
                    results.reportError(new OverlapError(item, (GuiTreeItemStructure)entry.getKey(), (LittleBoxesNoOverlap)entry.getValue()));
                }
                item.recipe.storage.addOverlap((LittleBoxes)entry.getValue());
            }
        }
        this.overlapped = null;
    }

    @Override
    public void endTest(GuiRecipe recipe, RecipeTestResults results) {
        this.blocks = null;
    }

    public class RecipeOverlapTestBlock
    implements IGridBased {
        public HashMap<GuiTreeItemStructure, List<LittleBox>> structureBoxes = new HashMap();
        private LittleGrid grid = LittleGrid.MIN;

        public void add(GuiTreeItemStructure item, BlockPos pos, LittleGrid grid, LittleBox box) {
            if (grid.count > this.grid.count) {
                this.convertTo(grid);
            } else if (grid.count < this.grid.count) {
                box.convertTo(grid, this.grid);
            }
            for (Map.Entry<GuiTreeItemStructure, List<LittleBox>> entry : this.structureBoxes.entrySet()) {
                for (LittleBox other : entry.getValue()) {
                    if (!LittleBox.intersectsWith(box, other)) continue;
                    LittleBox intersecting = box.intersection(other);
                    RecipeOverlapTest.this.addOverlap(entry.getKey(), pos, this.grid, intersecting);
                }
            }
            List<LittleBox> boxes = this.structureBoxes.get(item);
            if (boxes == null) {
                boxes = new ArrayList<LittleBox>();
                this.structureBoxes.put(item, boxes);
            }
            boxes.add(box);
        }

        @Override
        public LittleGrid getGrid() {
            return this.grid;
        }

        @Override
        public void convertTo(LittleGrid to) {
            for (List<LittleBox> boxes : this.structureBoxes.values()) {
                for (LittleBox box : boxes) {
                    box.convertTo(this.grid, to);
                }
            }
            this.grid = to;
        }

        @Override
        public int getSmallest() {
            int smallest = 0;
            for (List<LittleBox> boxes : this.structureBoxes.values()) {
                for (LittleBox box : boxes) {
                    smallest = Math.max(smallest, box.getSmallest(this.grid));
                }
            }
            return smallest;
        }
    }

    public static class SelfOverlapError
    extends RecipeTestError {
        private final GuiTreeItemStructure structure;
        private final LittleBoxesNoOverlap boxes;

        public SelfOverlapError(GuiTreeItemStructure structure, LittleBoxesNoOverlap boxes) {
            this.structure = structure;
            this.boxes = boxes;
        }

        @Override
        public Component header() {
            return GuiControl.translatable((String)"gui.recipe.test.overlap.self.title", (Object[])new Object[]{this.structure.getTitle()});
        }

        @Override
        public Component description() {
            int volume = this.boxes.littleVolume();
            if ((long)volume >= this.boxes.grid.count3d) {
                return GuiControl.translatable((String)"gui.recipe.test.overlap.desc.large", (Object[])new Object[]{TooltipUtils.print((double)(this.boxes.grid.pixelVolume * (double)volume))});
            }
            return GuiControl.translatable((String)"gui.recipe.test.overlap.desc.small", (Object[])new Object[]{TooltipUtils.print((int)volume), this.boxes.grid});
        }

        @Override
        public Component tooltip(GuiTreeItemStructure structure) {
            return this.header();
        }

        @Override
        public Iterator<GuiTreeItemStructure> iterator() {
            return new SingleIterator((Object)this.structure);
        }

        private void add(LittleElement element, LittleBox box, BlockPos.MutableBlockPos pos, LittleGrid grid, List<LittleBox> temp, List<LittleBox> temp2, HashMap<BlockPos, LittleCollection> blocks) {
            LittleCollection collection = blocks.get(pos);
            if (collection == null) {
                collection = new LittleCollection();
                blocks.put(pos.m_7949_(), collection);
            }
            for (LittleBox placedBox : collection.boxes()) {
                temp.add(placedBox);
            }
            List<LittleBox> remaining = box.cutOut(grid, temp, temp2, null);
            temp.clear();
            temp2.clear();
            if (remaining != null && !remaining.isEmpty()) {
                collection.add(element, remaining);
            }
        }

        @Override
        public void create(GuiRecipe recipe, GuiParent parent, Runnable refresh) {
            parent.add((GuiControl)new GuiButton("fix", x -> {
                LittleGroup group = this.structure.group;
                LittleGrid grid = group.getGrid();
                HashMap blocks = new HashMap();
                ArrayList temp = new ArrayList();
                ArrayList temp2 = new ArrayList();
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                Iterator<LittleTile> iterator = group.iterator();
                while (iterator.hasNext()) {
                    LittleTile tile = iterator.next();
                    for (LittleBox toAdd : tile) {
                        toAdd.splitIterator(grid, pos, LittleVec.ZERO, (blockPos, littleBox) -> this.add(tile, (LittleBox)littleBox, (BlockPos.MutableBlockPos)blockPos, grid, temp, temp2, blocks));
                    }
                }
                group = new LittleGroup(group.getStructureTag(), (List<LittleGroup>)Collections.EMPTY_LIST);
                LittleVec vec = new LittleVec(0, 0, 0);
                for (Map.Entry entry : blocks.entrySet()) {
                    vec.set(grid, (Vec3i)entry.getKey());
                    for (LittleTile tile : (LittleCollection)entry.getValue()) {
                        for (LittleBox box : tile) {
                            box.add(vec);
                        }
                        group.addTileFast(grid, tile);
                    }
                }
                group.convertToSmallest();
                group.combine(false);
                this.structure.group = group;
                this.structure.refreshAnimation();
                refresh.run();
            }).setTranslate("gui.recipe.test.overlap.fix"));
        }
    }

    public static class OverlapError
    extends RecipeTestError {
        private final GuiTreeItemStructure structure;
        private final GuiTreeItemStructure structure2;
        private final LittleBoxesNoOverlap boxes;

        public OverlapError(GuiTreeItemStructure structure, GuiTreeItemStructure structure2, LittleBoxesNoOverlap boxes) {
            this.structure = structure;
            this.structure2 = structure2;
            this.boxes = boxes;
        }

        @Override
        public Component header() {
            return GuiControl.translatable((String)"gui.recipe.test.overlap.title", (Object[])new Object[]{this.structure.getTitle(), this.structure2.getTitle()});
        }

        @Override
        public Component description() {
            int volume = this.boxes.littleVolume();
            if ((long)volume >= this.boxes.grid.count3d) {
                return GuiControl.translatable((String)"gui.recipe.test.overlap.desc.large", (Object[])new Object[]{TooltipUtils.print((double)(this.boxes.grid.pixelVolume * (double)volume))});
            }
            return GuiControl.translatable((String)"gui.recipe.test.overlap.desc.small", (Object[])new Object[]{TooltipUtils.print((int)volume), this.boxes.grid});
        }

        @Override
        public Iterator<GuiTreeItemStructure> iterator() {
            return new ArrayIterator((Object[])new GuiTreeItemStructure[]{this.structure, this.structure2});
        }

        @Override
        public Component tooltip(GuiTreeItemStructure structure) {
            return GuiControl.translatable((String)"gui.recipe.test.overlap.tooltip", (Object[])new Object[]{structure == this.structure ? this.structure2.getTitle() : this.structure.getTitle()});
        }

        @Override
        public void create(GuiRecipe recipe, GuiParent parent, Runnable refresh) {
            parent.add((GuiControl)new GuiLabel("remove").setTranslate("gui.recipe.test.overlap.remove"));
            parent.add((GuiControl)new GuiButton("remove", x -> {
                RecipeOverlapTest.removeOverlap(this.structure, this.boxes);
                refresh.run();
            }).setTitle((Component)Component.m_237113_((String)this.structure.getTitle())));
            parent.add((GuiControl)new GuiButton("remove2", x -> {
                RecipeOverlapTest.removeOverlap(this.structure2, this.boxes);
                refresh.run();
            }).setTitle((Component)Component.m_237113_((String)this.structure2.getTitle())));
            parent.add((GuiControl)new GuiButton("move", x -> ((GuiRecipeMove)recipe.OPEN_MOVE.open(new CompoundTag())).init(recipe)).setTranslate("gui.recipe.test.overlap.move"));
        }
    }
}

