/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.simple.GuiArraySlider;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.placement.selection.SelectionMode;

public class GuiRecipeSelection
extends GuiConfigure {
    public SelectionMode.SelectionResult result;
    public final GuiSyncLocal<CompoundTag> SAVE_SELECTION = this.getSyncHolder().register("save_selection", nbt -> {
        ItemStack stack = this.tool.get();
        SelectionMode mode = ItemLittleBlueprint.getSelectionMode(stack);
        try {
            LittleGroup previews = mode.getGroup(this.getPlayer().m_9236_(), this.getPlayer(), stack.m_41698_("s"), nbt.m_128471_("includeVanilla"), nbt.m_128471_("includeCB"), nbt.m_128471_("includeLT"), nbt.m_128471_("remember_structure"));
            if (nbt.m_128441_("grid")) {
                LittleGrid grid = LittleGrid.get(nbt.m_128451_("grid"));
                previews.convertTo(grid);
                LittleGrid aimedGrid = LittleGrid.get(nbt.m_128451_("aimedGrid"));
                if (aimedGrid.count > grid.count) {
                    LittleGroup.setGridSecretly(previews, aimedGrid);
                } else {
                    LittleGroup.advancedScale(previews, aimedGrid.count, grid.count);
                }
                previews.combineBlockwise();
            }
            previews.removeOffset();
            ((ItemLittleBlueprint)stack.m_41720_()).saveTiles(stack, previews);
            mode.clear(stack);
            this.tool.changed();
            LittleTilesGuiRegistry.OPEN_CONFIG.open(this.getPlayer());
        }
        catch (LittleActionException e) {
            GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"info", (Component)Component.m_237115_((String)"gui.ok"), (x, y) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
            return;
        }
    });
    public final GuiSyncLocal<EndTag> CLEAR_SELECTION = this.getSyncHolder().register("clear_selection", x -> {
        SelectionMode mode = ItemLittleBlueprint.getSelectionMode(this.tool.get());
        this.tool.get().m_41784_().m_128473_("s");
        ItemLittleBlueprint.setSelectionMode(this.tool.get(), mode);
        this.tool.changed();
        LittleTilesGuiRegistry.OPEN_CONFIG.open(this.getPlayer());
    });

    public GuiRecipeSelection(ContainerSlotView view) {
        super("recipe_selection", 200, 200, view);
        this.flow = GuiFlow.STACK_Y;
        this.registerEventChanged(x -> {
            if (!x.control.is("scale")) {
                this.updateSlider();
            }
        });
    }

    @Override
    public CompoundTag saveConfiguration(CompoundTag nbt) {
        return null;
    }

    public void create() {
        ItemStack stack = this.tool.get();
        SelectionMode mode = ItemLittleBlueprint.getSelectionMode(stack);
        GuiComboBoxMapped box = new GuiComboBoxMapped("selection_mode", new TextMapBuilder().addEntrySet(SelectionMode.REGISTRY.entrySet(), x -> ((SelectionMode)x.getValue()).getTranslation()));
        box.select((Object)mode);
        this.add(box.setExpandableX());
        this.result = mode.generateResult(this.getPlayer().m_9236_(), stack.m_41698_("s"));
        GuiCheckBox vanilla = new GuiCheckBox("includeVanilla", false).setTranslate("selection.include.vanilla");
        if (this.result != null && this.result.blocks > 0) {
            vanilla.setTooltip(new TextBuilder().text(this.result.blocks + " ").translate("selection.blocks").build());
        } else {
            vanilla.enabled = false;
        }
        this.add((GuiControl)vanilla);
        GuiCheckBox cb = new GuiCheckBox("includeCB", true).setTranslate("selection.include.cb");
        if (this.result != null && this.result.cbBlocks > 0) {
            cb.setTooltip(new TextBuilder().text(this.result.cbBlocks + " ").translate("gui.blocks").text(", " + this.result.cbTiles + " ").translate("gui.tiles").text(", " + this.result.minCBGrid.count + " ").translate("gui.grid").build());
        } else {
            cb.enabled = false;
        }
        this.add((GuiControl)cb);
        GuiCheckBox lt = new GuiCheckBox("includeLT", true).setTranslate("selection.include.lt");
        if (this.result != null && this.result.ltBlocks > 0) {
            cb.setTooltip(new TextBuilder().text(this.result.ltBlocks + " ").translate("gui.blocks").text(", " + this.result.ltTiles + " ").translate("gui.tiles").text(", " + this.result.minLtGrid.count + " ").translate("gui.grid").build());
        } else {
            lt.enabled = false;
        }
        this.add((GuiControl)lt);
        this.add((GuiControl)new GuiCheckBox("remember_structure", true).setTranslate("selection.include.structure"));
        GuiParent scale = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)scale);
        GuiLabel label = new GuiLabel("label_scale").setTitle((Component)Component.m_237115_((String)"selection.scale").m_130946_(": "));
        scale.add((GuiControl)label);
        scale.add(new GuiArraySlider("scale").setExpandableX());
        this.updateSlider();
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add(bottom.setAlign(Align.RIGHT).setExpandableX());
        bottom.addRight((GuiControl)new GuiButton("clear", x -> GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"clear_sekection", (Component)Component.m_237115_((String)"gui.selection.dialog.clear"), (g, b) -> {
            if (b == DialogGuiLayer.DialogButton.YES) {
                this.CLEAR_SELECTION.send((Tag)EndTag.f_128534_);
            }
        }, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.YES})).setTranslate("selection.clear"));
        bottom.addRight(new GuiButton("save", x -> {
            LittleGrid selected;
            boolean rememberStructure = ((GuiCheckBox)this.get((String)"remember_structure")).value;
            boolean includeVanilla = ((GuiCheckBox)this.get((String)"includeVanilla")).value;
            boolean includeCB = ((GuiCheckBox)this.get((String)"includeCB")).value;
            boolean includeLT = ((GuiCheckBox)this.get((String)"includeLT")).value;
            try {
                if (rememberStructure && mode.getGroup(this.getPlayer().m_9236_(), this.getPlayer(), stack.m_41698_("s"), includeVanilla, includeCB, includeLT, rememberStructure).isEmptyIncludeChildren()) {
                    GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"no_tiles", (Component)Component.m_237115_((String)"selection.no_tiles"), (g, b) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
                    return;
                }
            }
            catch (LittleActionException e) {
                GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"info", (Component)Component.m_237115_((String)"gui.ok"), (g, b) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
                return;
            }
            mode.save(stack);
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("save_selection", true);
            nbt.m_128379_("includeVanilla", includeVanilla);
            nbt.m_128379_("includeCB", includeCB);
            nbt.m_128379_("includeLT", includeLT);
            nbt.m_128379_("remember_structure", rememberStructure);
            LittleGrid minRequired = LittleGrid.MIN;
            if (nbt.m_128471_("includeCB") && this.result.minCBGrid != null) {
                minRequired = LittleGrid.max(minRequired, this.result.minCBGrid);
            }
            if (nbt.m_128471_("includeLT") && this.result.minLtGrid != null) {
                minRequired = LittleGrid.max(minRequired, this.result.minLtGrid);
            }
            if (minRequired != (selected = LittleGrid.gridByIndex(LittleGrid.gridCount() - 1 - ((GuiArraySlider)this.get("scale")).getIntValue()))) {
                nbt.m_128405_("grid", minRequired.count);
                nbt.m_128405_("aimedGrid", selected.count);
            }
            this.SAVE_SELECTION.send((Tag)nbt);
        }).setTranslate("gui.save").setEnabled(this.result != null));
    }

    public void updateSlider() {
        boolean includeLT;
        GuiArraySlider slider = (GuiArraySlider)this.get("scale");
        boolean includeVanilla = ((GuiCheckBox)this.get((String)"includeVanilla")).enabled && ((GuiCheckBox)this.get((String)"includeVanilla")).value;
        boolean includeCB = ((GuiCheckBox)this.get((String)"includeCB")).enabled && ((GuiCheckBox)this.get((String)"includeCB")).value;
        boolean bl = includeLT = ((GuiCheckBox)this.get((String)"includeLT")).enabled && ((GuiCheckBox)this.get((String)"includeLT")).value;
        if (this.result == null || !includeVanilla && !includeCB && !includeLT) {
            slider.setEnabled(false);
        } else {
            LittleGrid minRequired = LittleGrid.MIN;
            if (includeCB && this.result.minCBGrid != null) {
                minRequired = LittleGrid.max(minRequired, this.result.minCBGrid);
            }
            if (includeLT && this.result.minLtGrid != null) {
                minRequired = LittleGrid.max(minRequired, this.result.minLtGrid);
            }
            String value = slider.get();
            Object[] values = new String[LittleGrid.gridCount()];
            for (LittleGrid context : LittleGrid.grids()) {
                values[values.length - 1 - context.getIndex()] = minRequired.count + ":" + context.count + " x" + context.pixelLength / minRequired.pixelLength;
            }
            slider.setValues((String[])values);
            if (ArrayUtils.contains((Object[])values, (Object)value)) {
                slider.select(value);
            } else {
                slider.select((String)values[values.length - 1 - minRequired.getIndex()]);
            }
            slider.setEnabled(true);
        }
    }
}

