/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.common.gui.controls.tree.GuiTree;
import team.creative.creativecore.common.gui.controls.tree.GuiTreeItem;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxesVoxelShape;
import team.creative.creativecore.common.util.math.vec.SmoothValue;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.client.render.overlay.PreviewRenderer;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.AnimationPreview;
import team.creative.littletiles.common.gui.controls.animation.GuiAnimationViewerStorage;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.box.collection.LittleBoxesNoOverlap;
import team.creative.littletiles.common.math.vec.LittleVecGrid;

public class GuiRecipeAnimationStorage
implements Iterable<Map.Entry<GuiTreeItemStructure, AnimationPreview>>,
GuiAnimationViewerStorage {
    private boolean highlightSelected = false;
    private final GuiTree tree;
    private LinkedHashMap<GuiTreeItemStructure, AnimationPreview> availablePreviews = new LinkedHashMap();
    private LittleBoxesNoOverlap overlappingBoxes = null;
    private ConcurrentLinkedQueue<AnimationPair> change = new ConcurrentLinkedQueue();
    private AABB overall = null;
    private SmoothValue offX = new SmoothValue(200L);
    private SmoothValue offY = new SmoothValue(200L);
    private SmoothValue offZ = new SmoothValue(200L);
    private boolean unloaded = false;

    public GuiRecipeAnimationStorage(GuiTree tree) {
        this.tree = tree;
    }

    @Override
    public boolean highlightSelected() {
        return this.highlightSelected;
    }

    @Override
    public void highlightSelected(boolean value) {
        this.highlightSelected = value;
    }

    @Override
    public boolean isReady() {
        return this.overall != null && !this.availablePreviews.isEmpty();
    }

    public void resetOverlap() {
        this.overlappingBoxes = null;
    }

    public boolean hasOverlap() {
        return this.overlappingBoxes != null && !this.overlappingBoxes.isEmpty();
    }

    public LittleBoxesNoOverlap getOverlap() {
        return this.overlappingBoxes;
    }

    public void addOverlap(LittleBoxes boxes) {
        if (this.overlappingBoxes == null) {
            this.overlappingBoxes = new LittleBoxesNoOverlap(BlockPos.f_121853_, LittleGrid.MIN);
        }
        if (boxes instanceof LittleBoxesNoOverlap) {
            LittleBoxesNoOverlap no = (LittleBoxesNoOverlap)boxes;
            for (Map.Entry entry : no.generateBlockWise().entrySet()) {
                this.overlappingBoxes.addBoxes(boxes.getGrid(), (BlockPos)entry.getKey(), (Iterable)entry.getValue());
            }
        } else {
            for (LittleBox box : boxes.all()) {
                this.overlappingBoxes.addBox(boxes.getGrid(), boxes.pos, box.copy());
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Iterable<AnimationPreview> previewsToRender() {
        return Collections.EMPTY_LIST;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItem(GuiTreeItem item, PoseStack pose, Matrix4f projection, Minecraft mc) {
        pose.m_85836_();
        if ((!item.tree.hasCheckboxes() || item.isChecked()) && item instanceof GuiTreeItemStructure) {
            GuiTreeItemStructure s = (GuiTreeItemStructure)item;
            AnimationPreview preview = this.get(s);
            if (preview == null) {
                pose.m_85849_();
                return;
            }
            s.prepareRendering(preview);
            RenderSystem.applyModelViewMatrix();
            LittleVecGrid offset = s.getOffset();
            if (offset != null) {
                pose.m_85837_(offset.getPosX(), offset.getPosY(), offset.getPosZ());
            }
            this.renderPreview(pose, projection, preview, mc);
        }
        for (GuiTreeItem child : item.items()) {
            this.renderItem(child, pose, projection, mc);
        }
        pose.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderAll(PoseStack pose, Matrix4f projection, Minecraft mc) {
        this.renderItem(this.tree.root(), pose, projection, mc);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack empty = new PoseStack();
        empty.m_166856_();
        RenderSystem.applyModelViewMatrix();
        GuiTreeItemStructure selected = (GuiTreeItemStructure)this.tree.selected();
        if (this.highlightSelected && selected != null) {
            LittleVecGrid offset = selected.getOffset();
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (offset != null) {
                x = offset.getPosX();
                y = offset.getPosY();
                z = offset.getPosZ();
            }
            LittleGrid grid = selected.group.getGrid();
            ArrayList<ABB> boxes = new ArrayList<ABB>();
            for (LittleBox box : selected.group.allBoxes()) {
                boxes.add(box.getABB(grid));
            }
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderSystem.setShader(GameRenderer::m_172757_);
            bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
            RenderSystem.lineWidth((float)1.0f);
            PreviewRenderer.renderShape(empty, (VertexConsumer)bufferbuilder, (VoxelShape)BoxesVoxelShape.create(boxes), x, y, z, 1.0f, 1.0f, 1.0f, 1.0f);
            tesselator.m_85914_();
        }
        if (this.hasOverlap()) {
            RenderSystem.setShader(GameRenderer::m_172757_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            int colorAlpha = 102;
            LittleBoxesNoOverlap overlap = this.overlappingBoxes;
            LittleGrid grid = overlap.getGrid();
            for (Map.Entry entry : overlap.generateBlockWise().entrySet()) {
                pose.m_85836_();
                pose.m_252880_((float)((BlockPos)entry.getKey()).m_123341_(), (float)((BlockPos)entry.getKey()).m_123342_(), (float)((BlockPos)entry.getKey()).m_123343_());
                RenderSystem.applyModelViewMatrix();
                for (LittleBox box : (ArrayList)entry.getValue()) {
                    LittleRenderBox renderBox = box.getRenderingBox(grid);
                    RenderSystem.disableDepthTest();
                    RenderSystem.lineWidth((float)4.0f);
                    bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
                    renderBox.renderLines(empty, (VertexConsumer)bufferbuilder, colorAlpha);
                    tesselator.m_85914_();
                    RenderSystem.enableDepthTest();
                    RenderSystem.lineWidth((float)2.0f);
                    renderBox.color = -65536;
                    bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
                    renderBox.renderLines(empty, (VertexConsumer)bufferbuilder, colorAlpha);
                    tesselator.m_85914_();
                }
                pose.m_85849_();
            }
            RenderSystem.disableDepthTest();
        }
        selected = null;
    }

    private void updateBox() {
        if (this.availablePreviews.isEmpty()) {
            this.overall = null;
            return;
        }
        boolean init = this.overall == null;
        this.overall = null;
        for (AnimationPreview preview : this.availablePreviews.values()) {
            if (this.overall == null) {
                this.overall = preview.box;
                continue;
            }
            this.overall = this.overall.m_82367_(preview.box);
        }
        Vec3 center = this.overall.m_82399_();
        if (init) {
            this.offX.setStart(center.f_82479_);
            this.offY.setStart(center.f_82480_);
            this.offZ.setStart(center.f_82481_);
        } else {
            this.offX.set(center.f_82479_);
            this.offY.set(center.f_82480_);
            this.offZ.set(center.f_82481_);
        }
    }

    @Override
    public Vec3d center() {
        return new Vec3d(this.offX.current(), this.offY.current(), this.offZ.current());
    }

    @Override
    public double longestSide() {
        return Math.max(this.overall.f_82291_ - this.overall.f_82288_, Math.max(this.overall.f_82292_ - this.overall.f_82289_, this.overall.f_82293_ - this.overall.f_82290_));
    }

    @Override
    public AABB overall() {
        return this.overall;
    }

    public boolean isReady(GuiTreeItemStructure structure) {
        return this.availablePreviews.containsKey(structure);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItemAndChildren(PoseStack pose, Matrix4f projection, Minecraft mc, GuiTreeItemStructure structure) {
        int[][] pixels = GuiAnimationViewerStorage.makeLightBright();
        this.renderItemAndChildrenInternal(pose, projection, mc, structure);
        GuiAnimationViewerStorage.resetLight(pixels);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderItemAndChildrenInternal(PoseStack pose, Matrix4f projection, Minecraft mc, GuiTreeItemStructure structure) {
        AnimationPreview preview = this.availablePreviews.get(structure);
        if (preview != null) {
            this.renderPreview(pose, projection, preview, mc);
        }
        for (GuiTreeItem item : structure.items()) {
            this.renderItemAndChildrenInternal(pose, projection, mc, (GuiTreeItemStructure)item);
        }
    }

    public AnimationPreview get(GuiTreeItemStructure structure) {
        return this.availablePreviews.get(structure);
    }

    protected void remove(GuiTreeItemStructure structure) {
        AnimationPreview removed = (AnimationPreview)this.availablePreviews.remove(structure);
        if (removed != null) {
            removed.unload();
        }
        this.updateBox();
    }

    protected void put(GuiTreeItemStructure structure, AnimationPreview preview) {
        AnimationPreview previous = this.availablePreviews.put(structure, preview);
        if (previous != null) {
            previous.unload();
        }
        if (this.unloaded) {
            preview.unload();
        }
        this.updateBox();
    }

    public void removed(GuiTreeItemStructure structure) {
        if (RenderSystem.isOnRenderThread()) {
            this.remove(structure);
        } else {
            this.change.add(new AnimationPair(structure, null));
        }
    }

    public void completed(GuiTreeItemStructure structure, AnimationPreview preview) {
        if (RenderSystem.isOnRenderThread()) {
            this.put(structure, preview);
        } else {
            this.change.add(new AnimationPair(structure, preview));
        }
    }

    public void renderTick() {
        this.offX.tick();
        this.offY.tick();
        this.offZ.tick();
        if (!this.change.isEmpty()) {
            AnimationPair pair;
            while ((pair = this.change.poll()) != null) {
                if (pair.preview == null) {
                    this.remove(pair.item);
                    continue;
                }
                this.put(pair.item, pair.preview);
            }
            this.updateBox();
        }
    }

    public void tick() {
        for (AnimationPreview preview : this.availablePreviews.values()) {
            preview.tick();
        }
    }

    @Override
    public Iterator<Map.Entry<GuiTreeItemStructure, AnimationPreview>> iterator() {
        return this.availablePreviews.entrySet().iterator();
    }

    public void unload() {
        this.unloaded = true;
        for (AnimationPair pair : this.change) {
            if (pair.preview == null) continue;
            pair.preview.unload();
        }
        for (AnimationPreview preview : this.availablePreviews.values()) {
            preview.unload();
        }
    }

    private record AnimationPair(GuiTreeItemStructure item, AnimationPreview preview) {
    }
}

