/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.parent.GuiPanel;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiShowItem;
import team.creative.creativecore.common.gui.controls.tree.GuiTree;
import team.creative.creativecore.common.gui.controls.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.client.level.little.FakeClientLevel;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.gui.AnimationPreview;
import team.creative.littletiles.common.gui.controls.animation.GuiAnimationPanel;
import team.creative.littletiles.common.gui.controls.animation.GuiAnimationViewerStorage;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipe;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.server.level.little.FakeServerLevel;

public class GuiRecipeAdd
extends GuiLayer
implements GuiAnimationViewerStorage {
    public GuiRecipe recipe;
    private ItemStack selected;
    private volatile int requestedPreview = 0;
    private volatile AnimationPreview current;
    private volatile int executedPreview = 0;
    private AtomicReference<GuiRecipeAddAnimationRequest> scheduled = new AtomicReference();

    public static String generateGroupName(LittleGroup group) {
        String name = group.getStructureName();
        if (name != null) {
            return name;
        }
        LittleStructureType type = group.getStructureType();
        if (type != null) {
            return type.id;
        }
        return "none";
    }

    public GuiRecipeAdd() {
        super("recipe.add", 400, 200);
        this.flow = GuiFlow.STACK_Y;
    }

    public void init(GuiRecipe recipe) {
        this.recipe = recipe;
        this.clear();
        this.init();
    }

    private List<ItemStack> collectTiles() {
        ArrayList<ItemStack> recipes = new ArrayList<ItemStack>();
        Inventory inv = this.getPlayer().m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            LittleGroup group;
            ILittlePlacer placer;
            ItemStack stack = inv.m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof ILittlePlacer) || !(placer = (ILittlePlacer)item).hasTiles(stack) || (group = placer.getTiles(stack)) == null || group.isEmptyIncludeChildren()) continue;
            recipes.add(stack);
        }
        return recipes;
    }

    private void addGroup(GuiTreeItem parent, LittleGroup group) {
        GuiRecipeAddTreeItem item = new GuiRecipeAddTreeItem(parent.tree, group);
        parent.addItem((GuiTreeItem)item);
        for (LittleGroup child : group.children.children()) {
            this.addGroup(item, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnimation(int index, AnimationPreview preview) {
        AtomicReference<GuiRecipeAddAnimationRequest> atomicReference = this.scheduled;
        synchronized (atomicReference) {
            if (this.requestedPreview == -1 || this.requestedPreview > index) {
                if (preview != null) {
                    preview.unload();
                }
            } else {
                this.scheduled.set(new GuiRecipeAddAnimationRequest(preview, index));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(ItemStack stack) {
        if (this.selected == stack) {
            return;
        }
        this.selected = stack;
        GuiTree tree = (GuiTree)this.get("tree");
        tree.root().clearItems();
        ILittlePlacer placer = (ILittlePlacer)stack.m_41720_();
        if (placer.hasTiles(stack)) {
            LittleGroup group = placer.getTiles(stack);
            if (group.isEmpty()) {
                for (LittleGroup child : group.children.children()) {
                    this.addGroup(tree.root(), child);
                }
            } else {
                this.addGroup(tree.root(), group);
            }
            tree.updateTree();
            AtomicReference<GuiRecipeAddAnimationRequest> atomicReference = this.scheduled;
            synchronized (atomicReference) {
                ++this.requestedPreview;
            }
            int request = this.requestedPreview;
            FakeClientLevel fakeLevel = FakeServerLevel.createClient("animationViewer");
            CompletableFuture.supplyAsync(() -> {
                try {
                    return new AnimationPreview(fakeLevel, null, group);
                }
                catch (LittleActionException e) {
                    throw new RuntimeException(e);
                }
            }).whenComplete((preview, throwable) -> {
                this.setAnimation(request, (AnimationPreview)preview);
                if (throwable != null) {
                    throwable.printStackTrace();
                }
            });
            this.get("save").setEnabled(true);
            return;
        }
        AtomicReference<GuiRecipeAddAnimationRequest> atomicReference = this.scheduled;
        synchronized (atomicReference) {
            ++this.requestedPreview;
        }
        this.setAnimation(this.requestedPreview, null);
        this.get("save").setEnabled(false);
    }

    public void create() {
        GuiParent upper = new GuiParent();
        this.add(upper.setExpandable());
        GuiScrollY items = new GuiScrollY();
        upper.add((GuiControl)items.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRatioRules().widthRatio(0.3f).maxWidth(150)));
        List<ItemStack> stacks = this.collectTiles();
        for (ItemStack stack : stacks) {
            items.add((GuiControl)new GuiRecipeAddEntry(stack, this.getPlayer()));
        }
        GuiTree tree = new GuiTree("tree").setRootVisibility(false).setCheckboxes(true, true);
        upper.add(tree.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRatioRules().widthRatio(0.3f).maxWidth(100)).setExpandableY());
        upper.add(new GuiAnimationPanel(tree, this, false, null).setExpandable());
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("cancel", x -> this.closeThisLayer()).setTranslate("gui.cancel"));
        bottom.addLeft((GuiControl)new GuiButton("reload", x -> {
            this.selected = null;
            this.clear();
            this.init();
        }).setTranslate("gui.reload"));
        bottom.addRight(new GuiButton("save", x -> {
            LittleGroup group;
            if (this.selected == null) {
                return;
            }
            GuiTreeItem parent = this.recipe.tree.selected();
            if (parent == null) {
                parent = this.recipe.tree.root();
            }
            if ((group = this.reconstructBlueprint()) == null || group.isEmptyIncludeChildren()) {
                return;
            }
            this.recipe.buildStructureTree(this.recipe.tree, parent, group, parent.itemsCount());
            this.closeThisLayer();
            this.recipe.tree.updateTree();
        }).setTranslate("gui.import").setEnabled(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GuiGraphics graphics, GuiChildControl control, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        AtomicReference<GuiRecipeAddAnimationRequest> atomicReference = this.scheduled;
        synchronized (atomicReference) {
            GuiRecipeAddAnimationRequest request = this.scheduled.getAndSet(null);
            if (request != null && this.executedPreview < request.index) {
                if (this.current != null) {
                    this.current.unload();
                }
                this.current = request.preview;
                this.executedPreview = request.index;
            }
        }
        super.render(graphics, control, controlRect, realRect, scale, mouseX, mouseY);
    }

    protected LittleGroup reconstructBlueprint(GuiRecipeAddTreeItem item) {
        ArrayList<LittleGroup> children = new ArrayList<LittleGroup>();
        for (GuiTreeItem child : item.itemsChecked()) {
            children.add(this.reconstructBlueprint((GuiRecipeAddTreeItem)child));
        }
        return new LittleGroup(item.group.getStructureTag(), item.group.copyExceptChildren(), children);
    }

    protected LittleGroup reconstructBlueprint() {
        GuiTree tree = (GuiTree)this.get("tree");
        if (tree.root().itemsCount() == 1) {
            return this.reconstructBlueprint((GuiRecipeAddTreeItem)((Object)tree.root().items().iterator().next()));
        }
        ArrayList<LittleGroup> children = new ArrayList<LittleGroup>();
        for (GuiTreeItem child : tree.root().itemsChecked()) {
            children.add(this.reconstructBlueprint((GuiRecipeAddTreeItem)child));
        }
        if (children.isEmpty()) {
            return null;
        }
        return new LittleGroup((CompoundTag)null, children);
    }

    public void closed() {
        super.closed();
        this.requestedPreview = -1;
        if (this.current != null) {
            this.current.unload();
        }
    }

    @Override
    public boolean isReady() {
        return this.current != null;
    }

    @Override
    public double longestSide() {
        return Math.max(this.current.box.f_82291_ - this.current.box.f_82288_, Math.max(this.current.box.f_82292_ - this.current.box.f_82289_, this.current.box.f_82293_ - this.current.box.f_82290_));
    }

    @Override
    public AABB overall() {
        return this.current.box;
    }

    @Override
    public Vec3d center() {
        return new Vec3d(this.current.box.m_82399_());
    }

    @Override
    public boolean highlightSelected() {
        return false;
    }

    @Override
    public void highlightSelected(boolean value) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Iterable<AnimationPreview> previewsToRender() {
        return Collections.EMPTY_LIST;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderAll(PoseStack pose, Matrix4f projection, Minecraft mc) {
        this.renderPreview(pose, projection, this.current, mc);
    }

    public static class GuiRecipeAddTreeItem
    extends GuiTreeItem {
        public final LittleGroup group;

        public GuiRecipeAddTreeItem(GuiTree tree, LittleGroup group) {
            super("item", tree);
            this.group = group;
            this.setTitle((Component)Component.m_237113_((String)GuiRecipeAdd.generateGroupName(group)));
        }
    }

    private record GuiRecipeAddAnimationRequest(AnimationPreview preview, int index) {
    }

    public class GuiRecipeAddEntry
    extends GuiPanel {
        public final ItemStack stack;

        public GuiRecipeAddEntry(ItemStack stack, Player player) {
            this.stack = stack;
            this.flow = GuiFlow.STACK_X;
            this.add(new GuiShowItem("show", stack).setDim(40, 40));
            GuiParent right = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
            this.add(right.setVAlign(VAlign.CENTER).setExpandable());
            for (Component line : stack.m_41651_(player, (TooltipFlag)TooltipFlag.f_256752_)) {
                right.add((GuiControl)new GuiLabel("label").setTitle(line));
            }
        }

        public boolean mouseClicked(Rect rect, double x, double y, int button) {
            GuiRecipeAdd.this.select(this.stack);
            GuiRecipeAddEntry.playSound((Holder.Reference)SoundEvents.f_12490_);
            return true;
        }
    }
}

