/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiColorPicker;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.controls.GuiGridConfig;
import team.creative.littletiles.common.gui.controls.filter.GuiElementFilter;
import team.creative.littletiles.common.gui.tool.GuiConfigureTool;
import team.creative.littletiles.common.item.ItemLittleHammer;
import team.creative.littletiles.common.item.ItemLittlePaintBrush;
import team.creative.littletiles.common.placement.setting.PlacementPlayerSetting;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;

public class GuiPaintBrush
extends GuiConfigureTool {
    protected GuiElementFilter filter;

    public GuiPaintBrush(ContainerSlotView view) {
        super("paint_brush", 140, 200, view);
        this.registerEventChanged(x -> {
            if (x.control.is("shape")) {
                this.onChange();
            }
        });
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
    }

    @Override
    public CompoundTag saveConfiguration(CompoundTag nbt) {
        GuiComboBoxMapped box = (GuiComboBoxMapped)this.get("shape");
        GuiScrollY scroll = (GuiScrollY)this.get("settings");
        LittleShape shape = (LittleShape)box.getSelected();
        nbt.m_128359_("shape", shape.getKey());
        shape.saveCustomSettings((GuiParent)scroll, nbt, this.getGrid());
        GuiColorPicker picker = (GuiColorPicker)this.get("picker", GuiColorPicker.class);
        nbt.m_128405_("color", picker.color.toInt());
        ItemLittleHammer.setFilter(!((GuiCheckBox)this.get((String)"any", GuiCheckBox.class)).value, this.filter.get());
        return nbt;
    }

    public void create() {
        if (!this.isClient()) {
            return;
        }
        Color color = new Color(ItemLittlePaintBrush.getColor(this.tool.get()));
        this.add((GuiControl)new GuiColorPicker("picker", color, LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
        GuiComboBoxMapped box = new GuiComboBoxMapped("shape", new TextMapBuilder().addComponent((Iterable)ShapeRegistry.REGISTRY.values(), x -> Component.m_237115_((String)x.getTranslatableName())));
        box.select((Object)ItemLittleHammer.getShape(this.tool.get()));
        GuiScrollY scroll = new GuiScrollY("settings").setExpandable();
        this.add((GuiControl)box);
        this.add((GuiControl)scroll);
        this.add((GuiControl)new GuiGridConfig("grid", this.getPlayer(), PlacementPlayerSetting.grid(this.getPlayer()), x -> {
            LittleTilesClient.grid(x);
            if (ItemLittlePaintBrush.selection != null) {
                ItemLittlePaintBrush.selection.convertTo((LittleGrid)x);
            }
        }));
        BiFilter<IParentCollection, LittleTile> selector = ItemLittleHammer.getFilter();
        boolean activeFilter = ItemLittleHammer.isFiltered();
        this.add((GuiControl)new GuiLabel("filter_label").setTranslate("gui.filter"));
        this.add((GuiControl)new GuiCheckBox("any", selector == null || !activeFilter).setTranslate("gui.any"));
        this.filter = (GuiElementFilter)GuiElementFilter.ofGroup(this.getPlayer(), selector).setExpandableX().setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRules().prefHeight(60));
        this.add((GuiControl)this.filter);
        this.onChange();
    }

    public void onChange() {
        GuiComboBoxMapped box = (GuiComboBoxMapped)this.get("shape");
        GuiScrollY scroll = (GuiScrollY)this.get("settings", GuiScrollY.class);
        LittleShape shape = (LittleShape)box.getSelected((Object)ShapeRegistry.TILE_SHAPE);
        scroll.clear();
        for (GuiControl control : shape.getCustomSettings(this.tool.get().m_41783_(), this.getGrid())) {
            scroll.add(control);
        }
        this.reflow();
    }
}

